/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.table;

import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.html.table.BaseColumn;
import com.ebm_ws.infra.bricks.components.base.img.IImage;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TextColumn
extends BaseColumn {
    private IBinding _xmlnode_opt_CellValue;
    private IMessage _xmlnode_req_Text;
    private IImage _xmlnode_opt_Icon;
    private IAction _xmlnode_opt_OnClick;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        super.checkThisNode(iValidSupport, iErrors);
        if (!(this._xmlnode_opt_CellValue == null || this._xmlnode_opt_CellValue.hasErrors() || this._xmlnode_opt_CellValue.getType().isPrimitive() || Comparable.class.isAssignableFrom(this._xmlnode_opt_CellValue.getType()))) {
            iErrors.logMessage((IXmlObject)this, "SortOn", 1, "Sortable value has to implement Comparable: " + this._xmlnode_opt_CellValue.getType().getName());
        }
    }

    public Object getCellValue(HttpServletRequest iRequest, Object iRowObject) throws Exception {
        if (this._xmlnode_opt_CellValue == null) {
            return this._xmlnode_req_Text.getMessage(iRequest);
        }
        return this._xmlnode_opt_CellValue.invoke(iRequest);
    }

    public String getCellText(HttpServletRequest iRequest, Object iRowObject) throws Exception {
        return this._xmlnode_req_Text.getMessage(iRequest);
    }

    public void renderCellContent(HttpServletRequest iRequest, HttpServletResponse iResponse, int icol, Object iRowObject) throws Exception {
        String iconSrc;
        PrintWriter writer = iResponse.getWriter();
        String text = this._xmlnode_req_Text.getMessage(iRequest);
        String textHtml = text == null || text.length() == 0 ? "&nbsp;" : HtmlUtils.encode2HTML(text);
        String url = null;
        if (this._xmlnode_opt_OnClick != null) {
            url = this._xmlnode_opt_OnClick.getURL(iRequest, true);
        }
        String string = iconSrc = this._xmlnode_opt_Icon == null ? null : this._xmlnode_opt_Icon.getImage(iRequest);
        if (url == null) {
            if (iconSrc != null) {
                writer.print("<img src='");
                writer.print(iconSrc);
                writer.print("' alt='");
                writer.print("'/>");
            }
            writer.print(textHtml);
        } else {
            writer.print("<a href=\"");
            writer.print(url);
            writer.print("\">");
            if (iconSrc != null) {
                writer.print("<img src='");
                writer.print(iconSrc);
                writer.print("' alt='");
                writer.print("'/>");
            }
            writer.print(textHtml);
            writer.print("</a>");
        }
    }

    public Class getCellType() {
        if (this._xmlnode_opt_CellValue == null) {
            return String.class;
        }
        return this._xmlnode_opt_CellValue.getType();
    }
}

