/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.html.tree;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.action.IAction;
import com.ebm_ws.infra.bricks.components.base.enums.Scope;
import com.ebm_ws.infra.bricks.components.base.html.IView;
import com.ebm_ws.infra.bricks.components.base.html.tree.ITreeItem;
import com.ebm_ws.infra.bricks.components.base.html.tree.ITreeItemsProvider;
import com.ebm_ws.infra.bricks.components.base.html.tree.ITreeNode;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.BeanUtils;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Tree
implements IView,
IXmlObject,
IIdentifiable {
    protected Application _xmlroot;
    private String _xmlattr_req_ID;
    private String _xmlattr_opt_CssClass = "Tree";
    private Scope _xmlattr_opt_StateScope = Scope.PageContext;
    private IAction _xmlnode_opt_OnClick;
    private ITreeItemsProvider _xmlnode_req_Content;
    private IIdentifiable _xmlancestor_id;

    public String getPathID() {
        if (this._xmlancestor_id == null) {
            return this.getElementID();
        }
        return this._xmlancestor_id.getPathID() + "." + this.getElementID();
    }

    private String getElementID() {
        return "Tree_" + this._xmlattr_req_ID;
    }

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlroot.registerRequestHandler(this.getPathID(), this) != null) {
            iErrors.logMessage((IXmlObject)this, "ID", 5, "Callback URLs may not be stable on this component. To solve this specify a unique ID in the page.");
        }
    }

    public void preRender(HttpServletRequest request) throws Exception {
    }

    private TreeState getState(HttpServletRequest iRequest) {
        TreeState state = (TreeState)BeanUtils.getBean(iRequest, TreeState.class, this.getPathID(), this._xmlattr_opt_StateScope);
        if (state == null) {
            state = new TreeState();
            BeanUtils.setBean(iRequest, state, this.getPathID(), this._xmlattr_opt_StateScope);
        }
        return state;
    }

    public void render(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        TreeState state = this.getState(iRequest);
        PrintWriter writer = iResponse.getWriter();
        HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Common.js");
        HtmlUtils.includeBricksJavaScript(iRequest, iResponse, "Tree.js");
        writer.print("<div");
        writer.print(" id='");
        writer.print(this._xmlattr_req_ID);
        writer.println("'");
        writer.print(" class='");
        writer.print(this._xmlattr_opt_CssClass);
        writer.print("'");
        writer.println(">");
        this.renderItems(iRequest, iResponse, this._xmlnode_req_Content, state);
        writer.println("</div>");
        UrlBuilder jsonRequestUrl = this._xmlroot.createServiceUrl(iRequest, this, "jsonRequest");
        writer.println("<script language='javascript' type='text/javascript'>");
        writer.println("Tree_init('" + this._xmlattr_req_ID + "', '" + jsonRequestUrl.toUrl(iResponse.getCharacterEncoding(), false) + "');");
        writer.println("</script>");
    }

    private void renderItems(HttpServletRequest iRequest, HttpServletResponse iResponse, ITreeItemsProvider iNode, TreeState state) throws Exception {
        PrintWriter writer = iResponse.getWriter();
        List<ITreeItem> items = iNode.getItems(iRequest);
        writer.println("<ul>");
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                ITreeItem item = items.get(i);
                String itemId = state.getId(iNode instanceof ITreeNode ? (ITreeNode)iNode : null, item, i);
                String text = item.getText(iRequest);
                String iconSrc = item.getIcon(iRequest);
                String url = this._xmlnode_opt_OnClick != null ? this._xmlnode_opt_OnClick.getURL(iRequest, true) : null;
                boolean isnode = item instanceof ITreeNode;
                boolean isexpanded = isnode ? state.isExpanded(itemId) : false;
                writer.print("<li");
                writer.print(" id='");
                writer.print(itemId);
                writer.print("'");
                if (i == items.size() - 1) {
                    writer.print(" class=last");
                }
                writer.print(">");
                if (isnode) {
                    writer.print("<a href='javascript:void(0)'");
                    if (isexpanded) {
                        writer.print(" class='anchor exp'");
                    } else {
                        writer.print(" class='anchor coll'");
                    }
                    writer.print(" onclick=\"Tree_onClickAnchor(event);\"></a>");
                }
                if (iconSrc != null) {
                    writer.print("<img src='");
                    writer.print(iconSrc);
                    writer.print("' alt='");
                    writer.print("'/>");
                }
                if (url == null) {
                    writer.print("<span class=label>");
                } else {
                    writer.print("<a class=label href=\"");
                    writer.print(url);
                    writer.print("\">");
                }
                writer.print(HtmlUtils.encode2HTML(text));
                if (url == null) {
                    writer.print("</span>");
                } else {
                    writer.print("</a>");
                }
                if (isnode && isexpanded) {
                    this.renderItems(iRequest, iResponse, (ITreeNode)item, state);
                }
                writer.println("</li>");
            }
        }
        writer.println("</ul>");
    }

    public void jsonRequest(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        System.out.println("--> Tree.jsonRequest(): " + iRequest.getQueryString());
        BricksSession session = BricksSession.getSession(iRequest);
        iResponse.setContentType("text/plain;charset=" + session.getLocaleConfig().getCharSet());
        iResponse.setHeader("Cache-Control", "no-cache");
        iResponse.setHeader("Pragma", "no-cache");
        iResponse.setDateHeader("Expires", 0L);
        PrintWriter iWriter = iResponse.getWriter();
        String action = iRequest.getParameter("action");
        if ("expand".equals(action)) {
            String nodeId = iRequest.getParameter("id");
            TreeState state = this.getState(iRequest);
            state.setExpanded(nodeId, true);
            ITreeNode node = (ITreeNode)state.getNode(nodeId);
            this.jsonRenderItems(iRequest, iResponse, node, state);
        } else if ("collapse".equals(action)) {
            String nodeId = iRequest.getParameter("id");
            TreeState state = this.getState(iRequest);
            state.setExpanded(nodeId, false);
        } else {
            System.out.println("unknown action: " + action);
        }
        iWriter.print(" ");
        iWriter.flush();
        iWriter.close();
    }

    private void jsonRenderItems(HttpServletRequest iRequest, HttpServletResponse iResponse, ITreeItemsProvider iNode, TreeState state) throws Exception {
        PrintWriter writer = iResponse.getWriter();
        List<ITreeItem> items = iNode.getItems(iRequest);
        writer.print("[");
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                boolean isexpanded;
                ITreeItem item = items.get(i);
                String itemId = state.getId(iNode instanceof ITreeNode ? (ITreeNode)iNode : null, item, i);
                String text = item.getText(iRequest);
                String iconSrc = item.getIcon(iRequest);
                String url = this._xmlnode_opt_OnClick != null ? this._xmlnode_opt_OnClick.getURL(iRequest, true) : null;
                boolean isnode = item instanceof ITreeNode;
                boolean bl = isexpanded = isnode ? state.isExpanded(itemId) : false;
                if (i > 0) {
                    writer.print(",");
                }
                writer.print("{");
                writer.print("id:");
                writer.print("'");
                writer.print(HtmlUtils.encode2JsString(itemId));
                writer.print("'");
                if (isnode) {
                    writer.print(",");
                    writer.print("isNode:true");
                    if (isexpanded) {
                        writer.print(",");
                        writer.print("isExp:true");
                    }
                }
                writer.print(",");
                writer.print("text:");
                writer.print("'");
                writer.print(HtmlUtils.encode2JsString(text));
                writer.print("'");
                if (iconSrc != null) {
                    writer.print(",");
                    writer.print("icon:");
                    writer.print("'");
                    writer.print(HtmlUtils.encode2JsString(iconSrc));
                    writer.print("'");
                }
                if (url != null) {
                    writer.print(",");
                    writer.print("url:");
                    writer.print("'");
                    writer.print(HtmlUtils.encode2JsString(url));
                    writer.print("'");
                }
                if (isnode && isexpanded) {
                    writer.print(",");
                    writer.print("children:");
                    this.jsonRenderItems(iRequest, iResponse, (ITreeNode)item, state);
                }
                writer.print("}");
            }
        }
        writer.print("]");
    }

    private class TreeState {
        private HashMap<ITreeItem, String> obj2Id = new HashMap();
        private HashMap<String, ITreeItem> id2Obj = new HashMap();
        private HashMap<String, Boolean> expanded = new HashMap();

        private TreeState() {
        }

        public String getId(ITreeNode father, ITreeItem item, int index) {
            String id = this.obj2Id.get(item);
            if (id == null) {
                String fatherId = father == null ? Tree.this._xmlattr_req_ID : this.obj2Id.get(father);
                id = fatherId + "_" + String.valueOf(index);
                this.obj2Id.put(item, id);
                this.id2Obj.put(id, item);
            }
            return id;
        }

        public ITreeItem getNode(String id) {
            return this.id2Obj.get(id);
        }

        public boolean isExpanded(String id) {
            return this.expanded.get(id) != null;
        }

        public void setExpanded(String id, boolean state) {
            if (state) {
                this.expanded.put(id, Boolean.TRUE);
            } else {
                this.expanded.remove(id);
            }
        }
    }
}

