/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.msg;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.base.msg.MessageProvider;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.session.ILocaleConfig;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import javax.servlet.http.HttpServletRequest;

public class Message
implements IMessage,
IXmlObject {
    private Application _xmlroot;
    private String _xmlattr_opt_Provider;
    private String _xmlattr_req_Key;
    private IBinding[] _xmlnode_0_unb_Args;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        MessageProvider provider = this._xmlroot.getMessageProvider(this._xmlattr_opt_Provider);
        if (provider == null) {
            iErrors.logMessage((IXmlObject)this, "Provider", 1, "Provider [" + this._xmlattr_opt_Provider + "] not found.");
        } else {
            ILocaleConfig[] langs = this._xmlroot.getAllLanguages();
            for (int i = 0; i < langs.length; ++i) {
                try {
                    if (provider.checkMessage(langs[i].getLocale(), this._xmlattr_req_Key)) continue;
                    iErrors.logMessage((IXmlObject)this, "Key", 3, "Message [" + this._xmlattr_req_Key + "] in provider [" + provider.getName() + "] is null for language " + langs[i].getLocale().getLanguage() + ".");
                    continue;
                }
                catch (Exception e) {
                    iErrors.logMessage((IXmlObject)this, "Key", 1, "Message [" + this._xmlattr_req_Key + "] in provider [" + provider.getName() + "] not found for language " + langs[i].getLocale().getLanguage() + ".");
                }
            }
        }
    }

    public String getMessage(HttpServletRequest iRequest) {
        BricksSession session = BricksSession.getSession(iRequest);
        MessageProvider provider = session.getApplication().getMessageProvider(this._xmlattr_opt_Provider);
        if (provider == null) {
            return "!" + this._xmlattr_req_Key + "!";
        }
        Object[] args = null;
        if (this._xmlnode_0_unb_Args != null && this._xmlnode_0_unb_Args.length > 0) {
            args = new Object[this._xmlnode_0_unb_Args.length];
            for (int i = 0; i < args.length; ++i) {
                try {
                    args[i] = this._xmlnode_0_unb_Args[i].invoke(iRequest);
                    continue;
                }
                catch (Exception e) {
                    args[i] = "!error!";
                }
            }
        }
        return provider.getMessage(session.getLocale(), this._xmlattr_req_Key, args);
    }
}

