/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.msg;

import com.ebm_ws.infra.bricks.components.base.msg.MessageProvider;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;

public class ResourceBundle
extends MessageProvider {
    private String _xmlattr_req_BaseName;

    public ResourceBundle() {
    }

    public ResourceBundle(String baseName) {
        this._xmlattr_req_BaseName = baseName;
    }

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlattr_req_BaseName != null) {
            try {
                java.util.ResourceBundle.getBundle(this._xmlattr_req_BaseName);
            }
            catch (MissingResourceException e) {
                iErrors.logMessage((IXmlObject)this, "BaseName", 1, "Resource bundle '" + this._xmlattr_req_BaseName + "' not found.");
            }
        }
    }

    public boolean checkMessage(Locale iLocale, String iKey) {
        try {
            java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle(this._xmlattr_req_BaseName, iLocale);
            return bundle.getString(iKey) != null;
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }

    public String getMessage(Locale iLocale, String iKey, Object[] iArgs) {
        java.util.ResourceBundle bundle = null;
        try {
            bundle = java.util.ResourceBundle.getBundle(this._xmlattr_req_BaseName, iLocale);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (bundle == null) {
            return "! " + iKey + " (no bundle) !";
        }
        String msg = null;
        try {
            msg = bundle.getString(iKey);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (msg == null) {
            return "! " + iKey + " (no key) !";
        }
        if (iArgs == null || iArgs.length == 0) {
            return msg;
        }
        return MessageFormat.format(ResourceBundle.escapeForMessageFormat(msg), iArgs);
    }

    private static String escapeForMessageFormat(String pattern) {
        if (pattern == null || pattern.indexOf(39) < 0) {
            return pattern;
        }
        int n = pattern.length();
        StringBuffer sb = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char ch = pattern.charAt(i);
            if (ch == '\'') {
                sb.append('\'');
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

