/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.page;

import com.ebm_ws.infra.bricks.components.base.Application;
import com.ebm_ws.infra.bricks.components.base.binding.IBinding;
import com.ebm_ws.infra.bricks.components.base.html.CssStyleSheet;
import com.ebm_ws.infra.bricks.components.base.html.IFrame;
import com.ebm_ws.infra.bricks.components.base.msg.IMessage;
import com.ebm_ws.infra.bricks.components.base.page.IPage;
import com.ebm_ws.infra.bricks.components.base.page.ctx.IPageContextDef;
import com.ebm_ws.infra.bricks.components.interfaces.BaseBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IBeanProvider;
import com.ebm_ws.infra.bricks.components.interfaces.IIdentifiable;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.util.HtmlUtils;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BasePage
extends BaseBeanProvider
implements IXmlObject,
IPage,
IIdentifiable {
    private Application _xmlroot;
    private String _xmlattr_opt_FrameName;
    private String _xmlattr_req_Name;
    private IPageContextDef _xmlnode_req_Context;
    private IBinding[] _xmlnode_0_unb_OnPreRender;
    private IMessage _xmlnode_req_Title;
    private IIdentifiable _xmlancestor_id;

    public String getPathID() {
        if (this._xmlancestor_id == null) {
            return this.getElementID();
        }
        return this._xmlancestor_id.getPathID() + "." + this.getElementID();
    }

    private String getElementID() {
        return "Page_" + this._xmlattr_req_Name;
    }

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
        if (this._xmlroot.getFrame(this._xmlattr_opt_FrameName) == null) {
            iErrors.logMessage((IXmlObject)this, "FrameName", 1, "Frame '" + this._xmlattr_opt_FrameName + "' not found.");
        }
    }

    public IPageContextDef getContextDef() {
        return this._xmlnode_req_Context;
    }

    public String getName() {
        return this._xmlattr_req_Name;
    }

    public String getFrameName() {
        return this._xmlattr_opt_FrameName;
    }

    public String getTitle(HttpServletRequest iRequest) throws Exception {
        return this._xmlnode_req_Title.getMessage(iRequest);
    }

    public void preRender(HttpServletRequest iRequest) throws Exception {
        if (this._xmlnode_0_unb_OnPreRender != null) {
            for (int i = 0; i < this._xmlnode_0_unb_OnPreRender.length; ++i) {
                this._xmlnode_0_unb_OnPreRender[i].invoke(iRequest);
            }
        }
    }

    public void servePage(HttpServletRequest iRequest, HttpServletResponse iResponse) throws Exception {
        BricksSession session = BricksSession.getSession(iRequest);
        iRequest.setAttribute("_RENDER_PAGE_", (Object)this);
        this._xmlroot.getFrame(this.getFrameName()).preRender(iRequest);
        iResponse.setContentType("text/html;charset=" + session.getLocaleConfig().getCharSet());
        iResponse.setHeader("Cache-Control", "no-cache");
        iResponse.setHeader("Pragma", "no-cache");
        iResponse.setDateHeader("Expires", 0L);
        PrintWriter htmlWriter = iResponse.getWriter();
        htmlWriter.println(HtmlUtils.getHTML401TransitionalDoctype());
        htmlWriter.print("<html lang=\"");
        htmlWriter.print(session.getLocaleConfig().getLocale().getLanguage());
        htmlWriter.println("\">");
        htmlWriter.println("<head>");
        htmlWriter.print("<title>");
        htmlWriter.print(HtmlUtils.encode2HTML(this.getTitle(iRequest)));
        htmlWriter.println("</title>");
        htmlWriter.println("<meta http-equiv='content-type' content='text/html;charset=" + session.getLocaleConfig().getCharSet() + "'>");
        htmlWriter.println("<meta http-equiv='cache-control' content='no-cache'>");
        htmlWriter.println("<meta http-equiv='pragma' content='no-cache'>");
        htmlWriter.println("<meta http-equiv='expires' content='0'>");
        htmlWriter.print("<base href='");
        htmlWriter.print(iRequest.getScheme());
        htmlWriter.print("://");
        htmlWriter.print(iRequest.getServerName());
        htmlWriter.print(":");
        htmlWriter.print(String.valueOf(iRequest.getServerPort()));
        htmlWriter.print(iRequest.getContextPath());
        htmlWriter.print("/");
        htmlWriter.println("'>");
        IFrame frame = this._xmlroot.getFrame(this.getFrameName());
        CssStyleSheet[] styleSheets = frame.getStyleSheets();
        if (styleSheets != null) {
            for (int i = 0; i < styleSheets.length; ++i) {
                htmlWriter.print("<link rel='stylesheet' type='text/css' href='");
                htmlWriter.print(styleSheets[i].getFile());
                htmlWriter.println("'>");
            }
        }
        htmlWriter.println("</head>");
        htmlWriter.println("<body>");
        frame.render(iRequest, iResponse);
        htmlWriter.println("</body>");
        htmlWriter.println("</html>");
        htmlWriter.flush();
        htmlWriter.close();
    }

    public Type getBeanGenericType(String iName) throws IBeanProvider.UnresolvedBeanError {
        Type t = this._xmlnode_req_Context.getBeanGenericType(iName);
        if (t != null) {
            return t;
        }
        return this.getParentBeanGenericType(iName);
    }

    public Class getBeanType(String iName) throws IBeanProvider.UnresolvedBeanError {
        Class c = this._xmlnode_req_Context.getBeanType(iName);
        if (c != null) {
            return c;
        }
        return this.getParentBeanType(iName);
    }

    public Object getBeanValue(HttpServletRequest iRequest, String iName) throws Exception {
        Object o = this._xmlnode_req_Context.getBeanValue(iRequest, iName);
        if (o != null) {
            return o;
        }
        return this.getParentBeanValue(iRequest, iName);
    }
}

