/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.validation;

import com.ebm_ws.infra.bricks.components.base.validation.IValidator;
import com.ebm_ws.infra.bricks.validation.LocalizedMessage;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.util.regex.Pattern;

public class Email
implements IXmlObject,
IValidator {
    private static Pattern EMAIL_RE = Pattern.compile("[a-zA-Z0-9_\\-\\.]+@[a-zA-Z0-9-]{2,}[.][a-zA-Z]{2,3}");

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
    }

    public boolean isTypeValid(Class iClass) {
        return iClass == String.class;
    }

    public void checkValidity(String iItemId, Object iValue, ValidationErrors iValidation) {
        if (iValue == null) {
            return;
        }
        if (iValue instanceof String) {
            if (((String)iValue).length() == 0) {
                return;
            }
            if (!EMAIL_RE.matcher((String)iValue).matches()) {
                iValidation.addItemError(iItemId, new LocalizedMessage("validator.email.not_an_email", "bricks"));
            }
        }
    }
}

