/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.components.base.validation;

import com.ebm_ws.infra.bricks.components.base.validation.IValidator;
import com.ebm_ws.infra.bricks.util.ReflectionHelper;
import com.ebm_ws.infra.bricks.validation.LocalizedMessage;
import com.ebm_ws.infra.bricks.validation.ValidationErrors;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;

public class MinMax
implements IXmlObject,
IValidator {
    private int _xmlattr_opt_Min = Integer.MIN_VALUE;
    private int _xmlattr_opt_Max = Integer.MAX_VALUE;

    public void checkThisNode(Object iValidSupport, IValidityLogger iErrors) {
    }

    public boolean isTypeValid(Class iClass) {
        return String.class == iClass || ReflectionHelper.isIntegerLike(iClass);
    }

    public void checkValidity(String iItemId, Object iValue, ValidationErrors iValidation) {
        if (iValue == null) {
            return;
        }
        if (ReflectionHelper.isIntegerLike(iValue.getClass())) {
            int i = ((Number)iValue).intValue();
            if (i < this._xmlattr_opt_Min) {
                iValidation.addItemError(iItemId, new LocalizedMessage("validator.min_max.int_too_low", "bricks", new Object[]{new Integer(this._xmlattr_opt_Min)}));
            }
            if (i > this._xmlattr_opt_Max) {
                iValidation.addItemError(iItemId, new LocalizedMessage("validator.min_max.int_too_high", "bricks", new Object[]{new Integer(this._xmlattr_opt_Max)}));
            }
        } else if (iValue instanceof String) {
            String s = (String)iValue;
            int i = s.length();
            if (i < this._xmlattr_opt_Min) {
                iValidation.addItemError(iItemId, new LocalizedMessage("validator.min_max.str_too_low", "bricks", new Object[]{new Integer(this._xmlattr_opt_Min)}));
            }
            if (i > this._xmlattr_opt_Max) {
                iValidation.addItemError(iItemId, new LocalizedMessage("validator.min_max.str_too_high", "bricks", new Object[]{new Integer(this._xmlattr_opt_Max)}));
            }
        }
    }
}

