/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.error;

import com.ebm_ws.infra.bricks.components.base.msg.MessageProvider;
import com.ebm_ws.infra.bricks.error.IError;
import com.ebm_ws.infra.bricks.session.BricksSession;
import javax.servlet.http.HttpServletRequest;

public class LocalizedError
extends IError {
    private static final long serialVersionUID = 1L;
    private String _msgProvider;
    private String _errorKey;
    private Object[] _args;
    private String nextUrl;

    public LocalizedError(String iErrorKey, String iMessageProvider, Object[] iArguments, Throwable iRootCause) {
        super("LocalizedError [" + iErrorKey + "]", iRootCause);
        this._msgProvider = iMessageProvider;
        this._errorKey = iErrorKey;
        this._args = iArguments;
    }

    public LocalizedError(String iErrorKey, String iMessageProvider, Object[] iArguments) {
        this(iErrorKey, iMessageProvider, iArguments, null);
    }

    public LocalizedError(String iErrorKey, Object[] iArguments) {
        this(iErrorKey, null, iArguments, null);
    }

    public LocalizedError(String iErrorKey, Object[] iArguments, Throwable iRootCause) {
        this(iErrorKey, null, iArguments, iRootCause);
    }

    public LocalizedError(String iErrorKey, String iMessageProvider) {
        this(iErrorKey, iMessageProvider, null, null);
    }

    public LocalizedError(String iErrorKey, Throwable iRootCause) {
        this(iErrorKey, null, null, iRootCause);
    }

    public LocalizedError(String iErrorKey) {
        this(iErrorKey, null, null, null);
    }

    public String getTitle(HttpServletRequest iRequest) {
        BricksSession session = BricksSession.getSession(iRequest);
        MessageProvider provider = session.getApplication().getMessageProvider(this._msgProvider);
        if (provider == null) {
            return "!" + this._errorKey + "!";
        }
        return provider.getMessage(session.getLocale(), "error." + this._errorKey + ".title", this._args);
    }

    public String getMessage(HttpServletRequest iRequest) {
        BricksSession session = BricksSession.getSession(iRequest);
        MessageProvider provider = session.getApplication().getMessageProvider(this._msgProvider);
        if (provider == null) {
            return "!" + this._errorKey + "!";
        }
        return provider.getMessage(session.getLocale(), "error." + this._errorKey + ".message", this._args);
    }

    public String getNextUrl() {
        return this.nextUrl;
    }

    public void setNextUrl(String nextUrl) {
        this.nextUrl = nextUrl;
    }
}

