/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.impl.file;

import com.ebm_ws.infra.bricks.components.interfaces.IRequestProcessor;
import com.ebm_ws.infra.bricks.components.interfaces.IValidationSupport;
import com.ebm_ws.infra.bricks.impl.UrlWatcher;
import com.ebm_ws.infra.bricks.impl.file.fake_j2ee.AttributeHolder;
import com.ebm_ws.infra.bricks.impl.file.fake_j2ee.FakeRequest;
import com.ebm_ws.infra.bricks.impl.file.fake_j2ee.FakeResponse;
import com.ebm_ws.infra.bricks.impl.file.fake_j2ee.FakeSession;
import com.ebm_ws.infra.xmlmapping.XmlInstantiator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;

public class MockupGenerator {
    private static String BRICKS_PROCESSOR = "bricks.do";

    public static void main(String[] args) {
        block20: {
            String xmlFile = null;
            String outputDir = null;
            String userCtxFile = null;
            String msgsRootDir = null;
            String msgBundle = null;
            String imgsRootDir = null;
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-xml")) {
                    int n = ++i;
                    ++i;
                    xmlFile = args[n];
                    continue;
                }
                if (args[i].equals("-outputdir")) {
                    int n = ++i;
                    ++i;
                    outputDir = args[n];
                    continue;
                }
                if (args[i].equals("-userctx")) {
                    int n = ++i;
                    ++i;
                    userCtxFile = args[n];
                    continue;
                }
                if (args[i].equals("-imgsdir")) {
                    int n = ++i;
                    ++i;
                    imgsRootDir = args[n];
                    continue;
                }
                if (args[i].equals("-msgsdir")) {
                    int n = ++i;
                    ++i;
                    msgsRootDir = args[n];
                    continue;
                }
                if (args[i].equals("-msgsbundle")) {
                    int n = ++i;
                    ++i;
                    msgBundle = args[n];
                    continue;
                }
                System.out.println("Unknown argument '" + args[i++] + "'.");
            }
            if (xmlFile == null) {
                System.out.println("specify the nav model file.");
                return;
            }
            try {
                String language;
                System.out.println("Static Mockup Generation");
                System.out.println("------------------------");
                System.out.println(" - portal model (XML)        : " + xmlFile);
                System.out.println(" - output mockup directory   : " + outputDir);
                System.out.println(" - user context (properties) : " + userCtxFile);
                System.out.println(" - messages directory        : " + msgsRootDir);
                System.out.println(" - images root directory     : " + imgsRootDir);
                System.out.println("");
                MessageBundleLoader messages = new MessageBundleLoader(msgsRootDir, msgBundle);
                System.out.println("1) load portal model...");
                XmlInstantiator doc = XmlInstantiator.instantiate((InputStream)new FileInputStream(xmlFile), (Object)new FileValidSupport(imgsRootDir, messages));
                if (doc.hasMessages(3)) {
                    System.out.println("Errors and Warnings:");
                    doc.dumpMessages(3, new PrintWriter(System.out));
                }
                if (outputDir == null) break block20;
                System.out.println("");
                System.out.println("2) generate mockup...");
                Properties config = new Properties();
                if (userCtxFile != null) {
                    config.load(new FileInputStream(userCtxFile));
                }
                if ((language = config.getProperty("Locale")) == null) {
                    language = "fr";
                    config.setProperty("Locale", language);
                }
                Locale locale = new Locale(language);
                AttributeHolder appState = new AttributeHolder();
                FakeSession session = new FakeSession(null);
                File outputdir = new File(outputDir);
                if (outputdir.exists()) {
                    String[] files = outputdir.list();
                    for (int ifile = 0; ifile < files.length; ++ifile) {
                        if (!files[ifile].startsWith(BRICKS_PROCESSOR) || !files[ifile].endsWith(".html")) continue;
                        new File(outputdir, files[ifile]).delete();
                    }
                } else {
                    outputdir.mkdir();
                }
                File summary = new File(outputdir, "summary.html");
                FileWriter summaryWriter = new FileWriter(summary);
                summaryWriter.write("<BODY bgcolor='#DDDDDD' style='margin-left: 10px; font-family: helvetica; font-size: 10pt; color: black'>\n");
                summaryWriter.write("<span style='font-weight: bold; color: darkblue; text-decoration: underline'>Summary</span><br>\n");
                Date now = new Date();
                summaryWriter.write("Generated by: " + System.getProperty("user.name") + "<br>\n");
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
                summaryWriter.write("Date: " + dateFormat.format(now) + "<br>\n");
                SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
                summaryWriter.write("Time: " + timeFormat.format(now) + "<br>\n");
                summaryWriter.write("<br>User FormRenderingContext:\n");
                summaryWriter.write("<ul>\n");
                Enumeration<Object> enu = config.keys();
                while (enu.hasMoreElements()) {
                    String key = (String)enu.nextElement();
                    String value = config.getProperty(key);
                    summaryWriter.write("<li>" + key + ": " + value + "</li>\n");
                }
                summaryWriter.write("</ul>\n");
                summaryWriter.write("</BODY>\n");
                ((Writer)summaryWriter).flush();
                ((Writer)summaryWriter).close();
                UrlWatcher urls = new UrlWatcher();
                urls.install();
                IRequestProcessor reqProc = (IRequestProcessor)doc.getRoot();
                while (urls.hasMoreUrls()) {
                    String url = urls.nextUrl();
                    String genFileName = MockupGenerator.toStaticFile(url) + ".html";
                    FileOutputStream output = new FileOutputStream(new File(outputdir, genFileName));
                    FakeRequest fakeRequest = new FakeRequest(url, locale, appState, session, "utf-8");
                    FakeResponse fakeResponse = new FakeResponse(output, "utf-8", locale);
                    System.out.println("  - making page for url '" + url + "'");
                    try {
                        reqProc.service(fakeRequest, fakeResponse);
                    }
                    catch (Throwable t) {
                        System.out.println("Error:");
                        t.printStackTrace();
                    }
                    output.flush();
                    output.close();
                }
                System.out.println("... Done.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String getRelativePath(File iDir, File iViewedFromDir) {
        int j;
        int i;
        if (iDir.equals(iViewedFromDir)) {
            return ".";
        }
        String[] dirTokens = MockupGenerator.tokenizePath(iDir);
        String[] fromDirTokens = MockupGenerator.tokenizePath(iViewedFromDir);
        for (i = 0; i < dirTokens.length && i < fromDirTokens.length && dirTokens[i].equals(fromDirTokens[i]); ++i) {
        }
        StringBuffer sb = new StringBuffer();
        for (j = i; j < fromDirTokens.length; ++j) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append("..");
        }
        for (j = i; j < dirTokens.length; ++j) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(dirTokens[i]);
        }
        return sb.toString();
    }

    private static String[] tokenizePath(File iFile) {
        String file = iFile.getAbsolutePath().replace('\\', '/');
        StringTokenizer st = new StringTokenizer(file, "/");
        String[] ret = new String[st.countTokens()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = st.nextToken();
        }
        return ret;
    }

    private static String toStaticFile(String iUrl) {
        StringBuffer sb = new StringBuffer();
        block9: for (int i = 0; i < iUrl.length(); ++i) {
            char c = iUrl.charAt(i);
            switch (c) {
                case '/': 
                case '\\': {
                    sb.append('!');
                    continue block9;
                }
                case '?': {
                    sb.append('@');
                    continue block9;
                }
                case ':': {
                    sb.append('=');
                    continue block9;
                }
                case '*': {
                    sb.append('#');
                    continue block9;
                }
                case '\"': {
                    sb.append('\'');
                    continue block9;
                }
                case '>': {
                    sb.append('}');
                    continue block9;
                }
                case '<': {
                    sb.append('{');
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static class FileValidSupport
    implements IValidationSupport {
        private String _imagesRootDir;
        private MessageBundleLoader _messages;

        public FileValidSupport(String iImagesRootDir, MessageBundleLoader iMessages) {
            this._imagesRootDir = iImagesRootDir;
            this._messages = iMessages;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public boolean checkResource(String iResourcePath) {
            return true;
        }
    }

    public static class MessageBundleLoader {
        private String _msgsRootDir;
        private String _msgBundle;
        private Hashtable _lang2Message = new Hashtable();

        public MessageBundleLoader(String iMsgsRootDir, String iMsgBundle) {
            this._msgsRootDir = iMsgsRootDir;
            this._msgBundle = iMsgBundle;
        }

        public ResourceBundle getBundle(String iLang) {
            ResourceBundle messages = (ResourceBundle)this._lang2Message.get(iLang);
            if (messages == null) {
                if (this._msgsRootDir != null) {
                    File msgFile = new File(this._msgsRootDir + "/messages_" + iLang + ".properties");
                    if (msgFile != null) {
                        try {
                            messages = new PropertyResourceBundle(new FileInputStream(msgFile));
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    Locale loc = new Locale(iLang);
                    messages = ResourceBundle.getBundle(this._msgBundle, loc);
                }
                if (messages != null) {
                    this._lang2Message.put(iLang, messages);
                }
            }
            return messages;
        }
    }
}

