/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.impl.j2ee;

import com.ebm_ws.infra.bricks.components.interfaces.IRequestProcessor;
import com.ebm_ws.infra.bricks.components.interfaces.IValidationSupport;
import com.ebm_ws.infra.xmlmapping.IXmlModelMessage;
import com.ebm_ws.infra.xmlmapping.XmlEditor;
import com.ebm_ws.infra.xmlmapping.impl.ModelMessageImpl;
import com.ebm_ws.infra.xmlmapping.impl.ObjInfo;
import com.ebm_ws.infra.xmlmapping.interfaces.IEnumeration;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import com.ebm_ws.infra.xmlmapping.schema.ISchema;
import com.ebm_ws.infra.xmlmapping.schema.ISchemaElement;
import com.ebm_ws.infra.xmlmapping.utils.EnumHelper;
import com.ebm_ws.infra.xmlmapping.utils.MappedField;
import com.ebm_ws.infra.xmlmapping.utils.MessagesHelper;
import com.ebm_ws.infra.xmlmapping.utils.XmlMappings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BricksEditor
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static String BUNDLE = "com.ebm_ws.infra.bricks.impl.j2ee.BricksEditor";
    private String _charset = "UTF-8";
    private IValidationSupport _validSupport;
    private static String FORM_PREFIX = "_attr_";
    private static String ACTION_PARAM = "action";
    private static String ACTION_TARGET_ID_PARAM = "tgtid";
    private static String MAPPING_NAME_PARAM = "mapping";
    private static String VIEW_PARAM = "frame";
    private static String CUR_ELEMENT_ID_PARAM = "eltid";
    private static String DELETE_NODE_ACTION = "delnode";
    private static String CREATE_NODE_ACTION = "newnode";
    private static String SET_TYPE_ACTION = "settype";
    private static String SET_ATTRIBUTES_ACTION = "setattr";
    private static String XMLTREE_VIEW = "xmltree";
    private static String MAIN_VIEW = "main";

    public void init() throws ServletException {
        System.err.println("BricksAdminServlet Init:");
        try {
            this._validSupport = new J2EEValidator(this.getServletContext());
            System.err.println("BricksAdminServlet Init Done.");
        }
        catch (Exception e) {
            System.err.println("Error while initializing BricksAdminServlet:");
            e.printStackTrace(System.err);
        }
    }

    public XmlEditor getEditor(HttpServletRequest iRequest) throws ParserConfigurationException, SAXException, IOException {
        XmlEditor ctx = (XmlEditor)iRequest.getSession().getAttribute("XmlEditor");
        if (ctx == null) {
            System.out.println("initializing context...");
            ctx = new XmlEditor((Object)this._validSupport);
            String xmlfile = this.getInitParameter("xml");
            InputStream is = this.getServletContext().getResourceAsStream(xmlfile);
            ctx.load(is);
            is.close();
            System.out.println("Schemas: ");
            ISchema[] schemas = ctx.getSchemas().getAllSchemas();
            for (int i = 0; i < schemas.length; ++i) {
                System.out.println(" -" + i + ": " + schemas[i]);
            }
            iRequest.getSession().setAttribute("XmlEditor", (Object)ctx);
        }
        return ctx;
    }

    public String getNiceName(Locale iLocale, IXmlObject iObj) {
        return MessagesHelper.getInstanceName((Locale)iLocale, (Object)iObj);
    }

    public String getMessage(Locale iLocale, String iKey, Object[] iArgs) {
        try {
            String msg = PropertyResourceBundle.getBundle(BUNDLE, iLocale).getString(iKey);
            if (iArgs != null) {
                msg = MessageFormat.format(BricksEditor.escapeForMessageFormat(msg), iArgs);
            }
            return msg;
        }
        catch (Exception e) {
            return "(!)" + iKey;
        }
    }

    public String getMessage(Locale iLocale, String iKey) {
        return this.getMessage(iLocale, iKey, null);
    }

    private String getCharSet() {
        return this._charset;
    }

    public void service(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException {
        try {
            this.doservice(iRequest, iResponse);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            this.renderStackPage(iRequest, iResponse, t);
        }
    }

    public void doservice(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException, IllegalArgumentException, IllegalAccessException, ParserConfigurationException, SAXException {
        String view;
        System.out.println("BricksAdminServlet.service() (" + iRequest.getMethod() + "). Params: ");
        Enumeration params = iRequest.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            String value = iRequest.getParameter(name);
            System.out.println(" - [" + name + "]: [" + value + "]");
        }
        XmlEditor ctx = this.getEditor(iRequest);
        String action = iRequest.getParameter(ACTION_PARAM);
        if (action != null) {
            ObjInfo targetInfo;
            String targetEltId;
            if (action.equals(DELETE_NODE_ACTION)) {
                targetEltId = iRequest.getParameter(ACTION_TARGET_ID_PARAM);
                ObjInfo targetInfo2 = ctx.getInfoFromId(targetEltId);
                if (targetInfo2 != null) {
                    ctx.delete(targetInfo2.getObject());
                }
            } else if (action.equals(SET_TYPE_ACTION)) {
                targetEltId = iRequest.getParameter(ACTION_TARGET_ID_PARAM);
                ObjInfo targetInfo3 = ctx.getInfoFromId(targetEltId);
                if (targetInfo3 != null) {
                    String className = iRequest.getParameter("type");
                    Class<?> c = null;
                    try {
                        c = Class.forName(className);
                        ctx.changeType(targetInfo3.getObject(), c);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            } else if (action.equals(SET_ATTRIBUTES_ACTION)) {
                targetEltId = iRequest.getParameter(CUR_ELEMENT_ID_PARAM);
                ObjInfo targetInfo4 = ctx.getInfoFromId(targetEltId);
                if (targetInfo4 != null) {
                    XmlMappings mappings = XmlMappings.getMappings(targetInfo4.getObject().getClass(), (boolean)true);
                    MappedField[] fields = mappings.getMappings(9);
                    Object[] values = new Object[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        MappedField fieldMapping;
                        fields[i] = fieldMapping = fields[i];
                        String value = iRequest.getParameter(FORM_PREFIX + fieldMapping.getName());
                        if (value == null || value.trim().length() == 0) {
                            values[i] = null;
                            continue;
                        }
                        if (String.class.isAssignableFrom(fieldMapping.getBaseClass())) {
                            values[i] = value;
                            continue;
                        }
                        if (Integer.TYPE.isAssignableFrom(fieldMapping.getBaseClass()) || Integer.class.isAssignableFrom(fieldMapping.getBaseClass())) {
                            values[i] = new Integer(value);
                            continue;
                        }
                        if (Boolean.TYPE.isAssignableFrom(fieldMapping.getBaseClass()) || Boolean.class.isAssignableFrom(fieldMapping.getBaseClass())) {
                            values[i] = new Boolean("true".equals(value));
                            continue;
                        }
                        if (!IEnumeration.class.isAssignableFrom(fieldMapping.getBaseClass())) continue;
                        values[i] = EnumHelper.getItem((Class)fieldMapping.getBaseClass(), (String)value);
                    }
                    ctx.changeValues(targetInfo4.getObject(), fields, values);
                }
            } else if (action.equals(CREATE_NODE_ACTION) && (targetInfo = ctx.getInfoFromId(targetEltId = iRequest.getParameter(CUR_ELEMENT_ID_PARAM))) != null) {
                String mappingName = iRequest.getParameter(MAPPING_NAME_PARAM);
                XmlMappings mappings = XmlMappings.getMappings(targetInfo.getObject().getClass(), (boolean)true);
                MappedField mapping = mappings.getMappingByNameAndType(mappingName, 2);
                if (mapping == null) {
                    System.out.println("create node error : mapping '" + mappingName + "' not found for class '" + targetInfo.getObject().getClass().getName() + "'");
                } else {
                    ISchemaElement defaultElt = null;
                    if (mapping.getBaseClass().isInterface()) {
                        ISchemaElement[] implementors = ctx.getSchemas().getAllImplementors(mapping.getBaseClass());
                        if (implementors != null && implementors.length > 0) {
                            defaultElt = implementors[0];
                        }
                    } else {
                        defaultElt = ctx.getSchemas().getElement(mapping.getBaseClass());
                    }
                    if (defaultElt == null) {
                        System.out.println("create node error : not default implementor found for type '" + mapping.getBaseClass().getName() + "' (mapping '" + mappingName + "')");
                    } else {
                        System.out.println("create node: create default implementor '" + defaultElt.getMappedClass().getName() + "' for mapping '" + mappingName + "'.");
                        try {
                            ctx.add(targetInfo.getObject(), mapping, (IXmlObject)defaultElt.getMappedClass().newInstance());
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        if ("tree".equals(view = iRequest.getParameter(VIEW_PARAM))) {
            this.renderTree(iRequest, iResponse);
        } else if (MAIN_VIEW.equals(view)) {
            this.renderMain(iRequest, iResponse);
        } else if ("header".equals(view)) {
            this.renderHeader(iRequest, iResponse);
        } else if ("errors".equals(view)) {
            this.renderErrors(iRequest, iResponse);
        } else if (XMLTREE_VIEW.equals(view)) {
            this.renderTreeXml(iRequest, iResponse);
        } else {
            this.renderFrameset(iRequest, iResponse);
        }
    }

    public void renderFrameset(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException {
        OutputStreamWriter htmlWriter = new OutputStreamWriter((OutputStream)iResponse.getOutputStream(), this.getCharSet());
        iResponse.setContentType("text/html");
        htmlWriter.write("<html>");
        htmlWriter.write("<head>");
        htmlWriter.write("<title>Bricks Administration Page</title>\n");
        htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset=" + this.getCharSet() + "'>\n");
        htmlWriter.write("<meta http-equiv='cache-control' content='no-cache'>\n");
        htmlWriter.write("<meta http-equiv='pragma' content='no-cache'>\n");
        htmlWriter.write("<meta http-equiv='expires' content='0'>\n");
        htmlWriter.write("<link href='" + iRequest.getContextPath() + "/bricks_admin/css/bricks_admin.css' rel='stylesheet' type='text/css'>\n");
        htmlWriter.write("<script language='JavaScript' src='" + iRequest.getContextPath() + "/bricks_admin/js/Common.js'></script>\n");
        htmlWriter.write("</head>");
        htmlWriter.write("<frameset rows='38,*' framespacing='1' border='1' frameborder='yes' bordercolor='black'>");
        htmlWriter.write("\t<frame name='header' src='" + iRequest.getRequestURI() + "?frame=header' scrolling='no' noresize border='0' frameborder='no'>");
        htmlWriter.write("\t<frameset id='SplitV' cols='200,*' framespacing='5' border='5' frameborder='yes' bordercolor='#FFA111'>");
        htmlWriter.write("\t\t<frame name='tree' src='" + iRequest.getRequestURI() + "?frame=tree' scrolling='auto'></frame>");
        htmlWriter.write("\t\t<frameset id='SplitH' rows='*,200' framespacing='2' border='2' frameborder='yes' bordercolor='#FFA111'>");
        htmlWriter.write("\t\t\t<frame name='main' onload='onLoadMain()' src='" + iRequest.getRequestURI() + "?frame=main' scrolling='auto'></frame>");
        htmlWriter.write("\t\t\t<frame name='errors' src='" + iRequest.getRequestURI() + "?frame=errors' scrolling='auto' border='0' frameborder='no'>");
        htmlWriter.write("\t\t</frameset>");
        htmlWriter.write("\t</frameset>");
        htmlWriter.write("</frameset>");
        htmlWriter.write("</html>");
        ((Writer)htmlWriter).flush();
    }

    public void renderHeader(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException {
        OutputStreamWriter htmlWriter = new OutputStreamWriter((OutputStream)iResponse.getOutputStream(), this.getCharSet());
        iResponse.setContentType("text/html");
        htmlWriter.write("<html>\n");
        htmlWriter.write("<head>\n");
        htmlWriter.write("<title>Header</title>\n");
        htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset=" + this.getCharSet() + "'>\n");
        htmlWriter.write("<meta http-equiv='cache-control' content='no-cache'>\n");
        htmlWriter.write("<meta http-equiv='pragma' content='no-cache'>\n");
        htmlWriter.write("<meta http-equiv='expires' content='0'>\n");
        htmlWriter.write("<link href='" + iRequest.getContextPath() + "/bricks_admin/css/bricks_admin.css' rel='stylesheet' type='text/css'>\n");
        htmlWriter.write("</head>\n");
        htmlWriter.write("<body class=Header>\n");
        htmlWriter.write("Header\n");
        htmlWriter.write("</body>\n");
        htmlWriter.write("</html>\n");
        ((Writer)htmlWriter).flush();
    }

    public void renderTree(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException {
        OutputStreamWriter htmlWriter = new OutputStreamWriter((OutputStream)iResponse.getOutputStream(), this.getCharSet());
        iResponse.setContentType("text/html");
        htmlWriter.write("<html>\n");
        htmlWriter.write("<head>\n");
        htmlWriter.write("<title>Bricks Tree Model</title>\n");
        htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset=" + this.getCharSet() + "'>\n");
        htmlWriter.write("<meta http-equiv='cache-control' content='no-cache'>\n");
        htmlWriter.write("<meta http-equiv='pragma' content='no-cache'>\n");
        htmlWriter.write("<meta http-equiv='expires' content='0'>\n");
        htmlWriter.write("<link href='" + iRequest.getContextPath() + "/bricks_admin/css/bricks_admin.css' rel='stylesheet' type='text/css'>\n");
        htmlWriter.write("<script language='JavaScript' src='" + iRequest.getContextPath() + "/bricks_admin/js/Common.js'></script>\n");
        htmlWriter.write("<script language='JavaScript' src='" + iRequest.getContextPath() + "/bricks_admin/js/Tree.js'></script>\n");
        htmlWriter.write("</head>\n");
        htmlWriter.write("<body class=Tree onload=\"initTree('" + iRequest.getRequestURI() + "', '" + iRequest.getContextPath() + "/bricks_admin/icons')\">\n");
        htmlWriter.write("</body>\n");
        htmlWriter.write("</html>\n");
        ((Writer)htmlWriter).flush();
    }

    public void renderTreeXml(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException, ParserConfigurationException, SAXException {
        iResponse.setContentType("text/xml");
        XmlEditor ctx = this.getEditor(iRequest);
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document viewDoc = docBuilder.newDocument();
            IXmlObject root = ctx.getRoot();
            this.makeViewNode(iRequest, root, viewDoc, ctx);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)iResponse.getOutputStream(), this.getCharSet());
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(viewDoc.getDocumentElement());
            StreamResult result = new StreamResult(writer);
            trans.transform(source, result);
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            System.err.println("Error:");
            e.printStackTrace(System.err);
        }
    }

    private void makeViewNode(HttpServletRequest iRequest, IXmlObject iObject, Node iViewParent, XmlEditor iCtx) throws IllegalArgumentException, IllegalAccessException {
        ObjInfo info = iCtx.getInfoFromObj(iObject);
        Class<?> eltClass = iObject.getClass();
        Document viewDoc = iViewParent instanceof Document ? (Document)iViewParent : iViewParent.getOwnerDocument();
        Element viewElt = viewDoc.createElement("object");
        iViewParent.appendChild(viewElt);
        viewElt.setAttribute("id", info.getId());
        viewElt.setAttribute("name", this.getNiceName(iRequest.getLocale(), info.getObject()));
        String details = MessagesHelper.getComponentDetails((Locale)iRequest.getLocale(), eltClass);
        if (details != null) {
            viewElt.setAttribute("details", details);
        }
        XmlMappings mappings = XmlMappings.getMappings(eltClass, (boolean)true);
        MappedField[] childMappings = mappings.getMappings(6);
        for (int i = 0; i < childMappings.length; ++i) {
            int nbChildren;
            Object children;
            IXmlObject child;
            MappedField mapping = childMappings[i];
            if (mapping.getMappingType() == 2) {
                int nbChildren2;
                if (mapping.getMaxOccurs() <= 1) {
                    child = (IXmlObject)mapping.getField().get(iObject);
                    if (child == null) continue;
                    Element nodeMappingElt = viewDoc.createElement("attr");
                    viewElt.appendChild(nodeMappingElt);
                    nodeMappingElt.setAttribute("id", mapping.getName());
                    nodeMappingElt.setAttribute("name", MessagesHelper.getAttributeName((Locale)iRequest.getLocale(), eltClass, (String)mapping.getName()));
                    String attrdetails = MessagesHelper.getAttributeDetails((Locale)iRequest.getLocale(), eltClass, (String)mapping.getName());
                    if (attrdetails != null) {
                        nodeMappingElt.setAttribute("details", attrdetails);
                    }
                    this.makeViewNode(iRequest, child, nodeMappingElt, iCtx);
                    continue;
                }
                children = mapping.getField().get(iObject);
                int n = nbChildren2 = children == null ? 0 : Array.getLength(children);
                if (nbChildren2 <= 0) continue;
                Element nodeMappingElt = viewDoc.createElement("attr");
                viewElt.appendChild(nodeMappingElt);
                nodeMappingElt.setAttribute("id", mapping.getName());
                nodeMappingElt.setAttribute("name", MessagesHelper.getAttributeName((Locale)iRequest.getLocale(), eltClass, (String)mapping.getName()));
                String attrdetails = MessagesHelper.getAttributeDetails((Locale)iRequest.getLocale(), eltClass, (String)mapping.getName());
                if (attrdetails != null) {
                    nodeMappingElt.setAttribute("details", attrdetails);
                }
                for (int j = 0; j < nbChildren2; ++j) {
                    IXmlObject child2 = (IXmlObject)Array.get(children, j);
                    this.makeViewNode(iRequest, child2, nodeMappingElt, iCtx);
                }
                continue;
            }
            if (mapping.getMaxOccurs() <= 1) {
                child = (IXmlObject)mapping.getField().get(iObject);
                if (child == null) continue;
                this.makeViewNode(iRequest, child, viewElt, iCtx);
                continue;
            }
            children = mapping.getField().get(iObject);
            int n = nbChildren = children == null ? 0 : Array.getLength(children);
            if (nbChildren <= 0) continue;
            for (int j = 0; j < nbChildren; ++j) {
                IXmlObject child3 = (IXmlObject)Array.get(children, j);
                this.makeViewNode(iRequest, child3, viewElt, iCtx);
            }
        }
    }

    public void renderMain(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException, IllegalArgumentException, IllegalAccessException, ParserConfigurationException, SAXException {
        MappedField mapping;
        int i;
        MappedField[] collectMappings;
        MappedField[] childMappings;
        IXmlModelMessage[] messages;
        ObjInfo oi;
        Locale locale = iRequest.getLocale();
        OutputStreamWriter htmlWriter = new OutputStreamWriter((OutputStream)iResponse.getOutputStream(), this.getCharSet());
        iResponse.setContentType("text/html");
        htmlWriter.write("<html>\n");
        htmlWriter.write("<head>\n");
        htmlWriter.write("<title>Bricks Main Editor</title>\n");
        htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset=" + this.getCharSet() + "'>\n");
        htmlWriter.write("<meta http-equiv='cache-control' content='no-cache'>\n");
        htmlWriter.write("<meta http-equiv='pragma' content='no-cache'>\n");
        htmlWriter.write("<meta http-equiv='expires' content='0'>\n");
        htmlWriter.write("<link href='" + iRequest.getContextPath() + "/bricks_admin/css/bricks_admin.css' rel='stylesheet' type='text/css'>\n");
        htmlWriter.write("</head>\n");
        htmlWriter.write("<script language=JavaScript>\n");
        htmlWriter.write("function getAbsPos(obj, relativeToObj)\n");
        htmlWriter.write("{\n");
        htmlWriter.write("\tvar topOffset = 0;\n");
        htmlWriter.write("\tvar leftOffset = 0;\n");
        htmlWriter.write("\tif(relativeToObj == null) relativeToObj = document.body;\n");
        htmlWriter.write("\twhile(true)\n");
        htmlWriter.write("\t{\n");
        htmlWriter.write("\t\ttopOffset += obj.offsetTop;\n");
        htmlWriter.write("\t\tleftOffset += obj.offsetLeft;\n");
        htmlWriter.write("\t\tobj = obj.offsetParent;\n");
        htmlWriter.write("\t\tif(!obj) break;\n");
        htmlWriter.write("\t\tif(relativeToObj && relativeToObj == obj) break;\n");
        htmlWriter.write("\t\ttopOffset -= obj.scrollTop;\n");
        htmlWriter.write("\t\tleftOffset -= obj.scrollLeft;\n");
        htmlWriter.write("\t}\n");
        htmlWriter.write("\treturn [leftOffset, topOffset];\n");
        htmlWriter.write("}\n");
        htmlWriter.write("function getAncestor(elt, tag)\n");
        htmlWriter.write("{\n");
        htmlWriter.write("\twhile(elt.parentNode != null && elt.nodeName != tag)\n");
        htmlWriter.write("\t\telt = elt.parentNode;\n");
        htmlWriter.write("\treturn elt;\n");
        htmlWriter.write("}\n");
        htmlWriter.write("function showPopup(evt, obj, id)\n");
        htmlWriter.write("{\n");
        htmlWriter.write("\tvar div = document.getElementById(id);\n");
        htmlWriter.write("\tif(!div) return;\n");
        htmlWriter.write("\tvar pos = getAbsPos(obj);\n");
        htmlWriter.write("\tdiv.style.top = pos[1]+obj.offsetHeight;\n");
        htmlWriter.write("\tvar left = pos[0];\n");
        htmlWriter.write("\tif(left+div.offsetWidth > document.body.clientWidth)\n");
        htmlWriter.write("\t\tleft = document.body.clientWidth - div.offsetWidth;\n");
        htmlWriter.write("\tdiv.style.left = left;\n");
        htmlWriter.write("\tdiv.style.visibility = 'visible';\n");
        htmlWriter.write("}\n");
        htmlWriter.write("function hidePopup(evt, id)\n");
        htmlWriter.write("{\n");
        htmlWriter.write("\tvar div = document.getElementById(id);\n");
        htmlWriter.write("\tif(!div) return;\n");
        htmlWriter.write("\tdiv.style.visibility = 'hidden';\n");
        htmlWriter.write("}\n");
        htmlWriter.write("</script>\n");
        htmlWriter.write("<body class=Main>\n");
        XmlEditor ctx = this.getEditor(iRequest);
        String curid = iRequest.getParameter(CUR_ELEMENT_ID_PARAM);
        ObjInfo info = null;
        if (curid != null) {
            info = ctx.getInfoFromId(curid);
        }
        if (info == null) {
            info = ctx.getInfoFromObj(ctx.getRoot());
        }
        IXmlObject curObj = info.getObject();
        Class<?> eltClass = curObj.getClass();
        XmlMappings mappings = XmlMappings.getMappings(eltClass, (boolean)true);
        MappedField parentMapping = info.getParentMapping();
        System.out.println("Mapped class: " + eltClass.getName());
        Vector<ObjInfo> ancestors = new Vector<ObjInfo>();
        for (oi = info.getParent(); oi != null; oi = oi.getParent()) {
            ancestors.insertElementAt(oi, 0);
        }
        for (int i2 = 0; i2 < ancestors.size(); ++i2) {
            oi = (ObjInfo)ancestors.elementAt(i2);
            htmlWriter.write("&nbsp;&gt;&nbsp;");
            htmlWriter.write("<a href='" + iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + CUR_ELEMENT_ID_PARAM + "=" + oi.getIdPath() + "'>");
            htmlWriter.write(this.getNiceName(iRequest.getLocale(), oi.getObject()));
            htmlWriter.write("</a>\n");
        }
        htmlWriter.write("<h1>");
        htmlWriter.write(this.getNiceName(iRequest.getLocale(), info.getObject()));
        htmlWriter.write("</h1>\n");
        String objDetails = MessagesHelper.getComponentDetails((Locale)locale, eltClass);
        if (objDetails != null) {
            htmlWriter.write("<h3>");
            htmlWriter.write(objDetails);
            htmlWriter.write("</h3>\n");
        }
        if ((messages = ctx.getGlobalElementMessages(curObj)) != null) {
            htmlWriter.write("<div class=GlobalErrors>\n");
            htmlWriter.write(" " + messages.length + " global messages!");
            htmlWriter.write("</div>\n");
        }
        htmlWriter.write("<table border=0 cellpadding=0 cellspacing=0 class=Form>\n");
        int row = 1;
        htmlWriter.write("<tr class=even>\n");
        htmlWriter.write("<td class=AttrName align=right valign=top>");
        htmlWriter.write(this.getMessage(locale, "ObjForm.Type.Label"));
        htmlWriter.write("</td>\n");
        ISchemaElement[] compatibleTypes = null;
        compatibleTypes = parentMapping == null ? ctx.getSchemas().getAllImplementors(IRequestProcessor.class) : (parentMapping.getBaseClass().isInterface() ? ctx.getSchemas().getAllImplementors(parentMapping.getBaseClass()) : new ISchemaElement[]{ctx.getSchemas().getElement(parentMapping.getBaseClass())});
        htmlWriter.write("<td class=AttrValue align=left valign=top>\n");
        if (compatibleTypes.length == 1) {
            htmlWriter.write(compatibleTypes[0].getTagName());
        } else {
            htmlWriter.write("<form method=post action='" + iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + ACTION_PARAM + "=" + SET_TYPE_ACTION + "&" + CUR_ELEMENT_ID_PARAM + "=" + curid + "'>\n");
            htmlWriter.write("<select name='type' onchange='this.form.submit()'>\n");
            for (int i3 = 0; i3 < compatibleTypes.length; ++i3) {
                htmlWriter.write("<option value='");
                htmlWriter.write(compatibleTypes[i3].getMappedClass().getName());
                htmlWriter.write("'");
                if (compatibleTypes[i3].getMappedClass() == eltClass) {
                    htmlWriter.write(" selected");
                }
                htmlWriter.write(">");
                htmlWriter.write(compatibleTypes[i3].getTagName());
                htmlWriter.write("</option>\n");
            }
            htmlWriter.write("</select>\n");
            htmlWriter.write("</form>\n");
        }
        htmlWriter.write("</td>\n");
        htmlWriter.write("<td class=AttrErrors align=left valign=top>\n");
        htmlWriter.write("&nbsp;</td>\n");
        htmlWriter.write("</tr>\n");
        MappedField[] attrMappings = mappings.getMappings(9);
        if (attrMappings != null && attrMappings.length > 0) {
            htmlWriter.write("<form method=post action='" + iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + ACTION_PARAM + "=" + SET_ATTRIBUTES_ACTION + "&" + CUR_ELEMENT_ID_PARAM + "=" + curid + "'>\n");
            htmlWriter.write("<tr class=Title>\n");
            htmlWriter.write("<td colspan=3>");
            htmlWriter.write(this.getMessage(locale, "ObjForm.Attributes"));
            htmlWriter.write("</td>\n");
            htmlWriter.write("</tr>\n");
            for (int i4 = 0; i4 < attrMappings.length; ++i4) {
                MappedField mapping2 = attrMappings[i4];
                this.renderMappingField(iRequest, htmlWriter, info, eltClass, row++, mapping2);
            }
            htmlWriter.write("<tr class=Buttons>\n");
            htmlWriter.write("<td>&nbsp;</td>");
            htmlWriter.write("<td align=left colspan=2>\n");
            htmlWriter.write("<input type=submit value='" + this.getMessage(locale, "ObjForm.Submit.Label") + "'>\n");
            htmlWriter.write("</td>\n");
            htmlWriter.write("</tr>\n");
            htmlWriter.write("</form>\n");
        }
        if ((childMappings = mappings.getMappings(2)).length + (collectMappings = mappings.getMappings(4)).length > 0) {
            htmlWriter.write("<tr class=Title>\n");
            htmlWriter.write("<td colspan=3>");
            htmlWriter.write(this.getMessage(locale, "ObjForm.Elements"));
            htmlWriter.write("</td>\n");
            htmlWriter.write("</tr>\n");
        }
        for (i = 0; i < childMappings.length; ++i) {
            mapping = childMappings[i];
            if (mapping.getMaxOccurs() > 1) continue;
            this.renderMappingField(iRequest, htmlWriter, info, eltClass, row++, mapping);
        }
        for (i = 0; i < collectMappings.length; ++i) {
            mapping = collectMappings[i];
            if (mapping.getMaxOccurs() > 1) continue;
            this.renderMappingField(iRequest, htmlWriter, info, eltClass, row++, mapping);
        }
        for (i = 0; i < childMappings.length; ++i) {
            mapping = childMappings[i];
            if (mapping.getMaxOccurs() <= 1) continue;
            this.renderMappingField(iRequest, htmlWriter, info, eltClass, row++, mapping);
        }
        for (i = 0; i < collectMappings.length; ++i) {
            mapping = collectMappings[i];
            if (mapping.getMaxOccurs() <= 1) continue;
            this.renderMappingField(iRequest, htmlWriter, info, eltClass, row++, mapping);
        }
        htmlWriter.write("</table>\n");
        htmlWriter.write("</body>\n");
        htmlWriter.write("</html>\n");
        ((Writer)htmlWriter).flush();
    }

    public void renderMappingField(HttpServletRequest iRequest, Writer htmlWriter, ObjInfo info, Class eltClass, int iRow, MappedField mapping) throws IOException, IllegalArgumentException, IllegalAccessException, ParserConfigurationException, SAXException {
        ObjInfo childInfo;
        IXmlObject child;
        Object children;
        IXmlObject child2;
        int j;
        Object val;
        XmlEditor ctx = this.getEditor(iRequest);
        IXmlObject curObj = info.getObject();
        Locale locale = iRequest.getLocale();
        boolean even = iRow % 2 == 0;
        htmlWriter.write("<tr class=" + (even ? "even" : "odd") + ">\n");
        htmlWriter.write("<td class=AttrName align=right valign=top nowrap>");
        String name = MessagesHelper.getAttributeName((Locale)locale, (Class)eltClass, (String)mapping.getName());
        String details = MessagesHelper.getAttributeDetails((Locale)locale, (Class)eltClass, (String)mapping.getName());
        if (details != null) {
            htmlWriter.write(" <span style='text-decoration: underline' title=\"");
            htmlWriter.write(details);
            htmlWriter.write("\">");
            htmlWriter.write(name + ":");
            htmlWriter.write("</span>");
        } else {
            htmlWriter.write(name + ":");
        }
        htmlWriter.write("</td>\n");
        htmlWriter.write("<td class=AttrValue align=left valign=top nowrap>\n");
        if (mapping.getMappingType() == 1) {
            val = mapping.getField().get(curObj);
            if (String.class.isAssignableFrom(mapping.getBaseClass())) {
                String strVal = (String)val;
                htmlWriter.write("<input name='" + FORM_PREFIX + mapping.getName() + "' type=text value='" + (strVal == null ? "" : strVal) + "'>\n");
            } else if (Integer.TYPE.isAssignableFrom(mapping.getBaseClass()) || Integer.class.isAssignableFrom(mapping.getBaseClass())) {
                Integer intVal = (Integer)val;
                htmlWriter.write("<input name='" + FORM_PREFIX + mapping.getName() + "' type=text value='" + (intVal == null ? "" : intVal) + "'>\n");
            } else if (Boolean.TYPE.isAssignableFrom(mapping.getBaseClass()) || Boolean.class.isAssignableFrom(mapping.getBaseClass())) {
                Boolean boolVal = (Boolean)val;
                if (boolVal == null) {
                    boolVal = Boolean.FALSE;
                }
                htmlWriter.write("<select name='" + FORM_PREFIX + mapping.getName() + "'>\n");
                htmlWriter.write("<option class=null value=''" + (boolVal == null ? " selected" : "") + ">");
                htmlWriter.write(this.getMessage(locale, "ObjForm.Object.Null"));
                htmlWriter.write("</option>\n");
                htmlWriter.write("<option value='true'" + (boolVal == Boolean.TRUE ? " selected" : "") + ">");
                htmlWriter.write(this.getMessage(locale, "ObjForm.Boolean.True"));
                htmlWriter.write("</option>\n");
                htmlWriter.write("<option value='false'" + (boolVal == Boolean.FALSE ? " selected" : "") + ">");
                htmlWriter.write(this.getMessage(locale, "ObjForm.Boolean.False"));
                htmlWriter.write("</option>\n");
                htmlWriter.write("</select>\n");
            } else if (IEnumeration.class.isAssignableFrom(mapping.getBaseClass())) {
                htmlWriter.write("<select name='" + FORM_PREFIX + mapping.getName() + "'>\n");
                htmlWriter.write("<option class=null value=''" + (val == null ? " selected" : "") + ">");
                htmlWriter.write(this.getMessage(locale, "ObjForm.Object.Null"));
                htmlWriter.write("</option>\n");
                int nbElts = EnumHelper.getNbOfItems((Class)mapping.getBaseClass());
                for (j = 0; j < nbElts; ++j) {
                    String eltName = EnumHelper.getItemName((Class)mapping.getBaseClass(), (int)j);
                    IEnumeration curVal = EnumHelper.getItem((Class)mapping.getBaseClass(), (int)j);
                    htmlWriter.write("<option value='" + eltName + "'" + (curVal.equals(val) ? " selected" : "") + ">");
                    htmlWriter.write(eltName);
                    htmlWriter.write("</option>\n");
                }
                htmlWriter.write("</select>\n");
            } else {
                htmlWriter.write("unsuppported type: ");
                htmlWriter.write(mapping.getBaseClass().getName());
            }
        } else if (mapping.getMappingType() == 8) {
            val = mapping.getField().get(curObj);
            String content = (String)val;
            if (content == null) {
                content = "";
            }
            htmlWriter.write("<textarea name='" + FORM_PREFIX + mapping.getName() + "'>");
            htmlWriter.write(content);
            htmlWriter.write("</textarea>\n");
        } else if (mapping.getMappingType() == 2) {
            if (mapping.getMaxOccurs() <= 1) {
                child2 = (IXmlObject)mapping.getField().get(curObj);
                if (child2 == null) {
                    htmlWriter.write("<a href='");
                    htmlWriter.write(iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + ACTION_PARAM + "=" + CREATE_NODE_ACTION + "&" + MAPPING_NAME_PARAM + "=" + mapping.getName() + "&" + CUR_ELEMENT_ID_PARAM + "=" + info.getIdPath());
                    htmlWriter.write("'");
                    htmlWriter.write(" title='");
                    htmlWriter.write(this.getMessage(locale, "action.create"));
                    htmlWriter.write("'>");
                    htmlWriter.write("<img src='");
                    htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/new_16.gif");
                    htmlWriter.write("'>");
                    htmlWriter.write("</a>\n");
                    htmlWriter.write("&nbsp;&lt;");
                    htmlWriter.write(this.getMessage(locale, "ObjForm.Object.Null"));
                    htmlWriter.write("&gt;");
                } else {
                    ObjInfo childInfo2 = ctx.getInfoFromObj(child2);
                    htmlWriter.write("<a href='");
                    htmlWriter.write(iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + ACTION_PARAM + "=" + DELETE_NODE_ACTION + "&" + ACTION_TARGET_ID_PARAM + "=" + childInfo2.getIdPath() + "&" + CUR_ELEMENT_ID_PARAM + "=" + info.getIdPath());
                    htmlWriter.write("'");
                    htmlWriter.write(" title='");
                    htmlWriter.write(this.getMessage(locale, "action.delete"));
                    htmlWriter.write("'>");
                    htmlWriter.write("<img src='");
                    htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/trash_16.gif");
                    htmlWriter.write("'>");
                    htmlWriter.write("</a>\n");
                    htmlWriter.write("&nbsp;");
                    htmlWriter.write("<a href='" + iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + CUR_ELEMENT_ID_PARAM + "=" + childInfo2.getIdPath() + "'>");
                    htmlWriter.write(this.getNiceName(iRequest.getLocale(), childInfo2.getObject()));
                    htmlWriter.write("</a>\n");
                }
            } else {
                children = mapping.getField().get(curObj);
                int nbChidren = children == null ? 0 : Array.getLength(children);
                htmlWriter.write("<table border=1 cellpadding=0 cellspacing=0 class=List>\n");
                htmlWriter.write("<tr>\n");
                htmlWriter.write("<th>");
                htmlWriter.write(this.getMessage(locale, "list.index"));
                htmlWriter.write("</th>\n");
                htmlWriter.write("<th>");
                htmlWriter.write(this.getMessage(locale, "list.delete"));
                htmlWriter.write("</th>\n");
                htmlWriter.write("<th>");
                htmlWriter.write(this.getMessage(locale, "list.object"));
                htmlWriter.write("</th>\n");
                htmlWriter.write("<th colspan=2>");
                htmlWriter.write(this.getMessage(locale, "list.move"));
                htmlWriter.write("</th>\n");
                htmlWriter.write("</tr>\n");
                if (nbChidren == 0) {
                    htmlWriter.write("<tr>\n");
                    htmlWriter.write("<td colspan=5>\n");
                    htmlWriter.write(this.getMessage(locale, "list.empty"));
                    htmlWriter.write("</td>\n");
                    htmlWriter.write("</tr>\n");
                } else {
                    for (j = 0; j < nbChidren; ++j) {
                        child = (IXmlObject)Array.get(children, j);
                        childInfo = ctx.getInfoFromObj(child);
                        htmlWriter.write("<tr>\n");
                        htmlWriter.write("<td align=center>");
                        htmlWriter.write(String.valueOf(j));
                        htmlWriter.write("</td>\n");
                        htmlWriter.write("<td align=center>");
                        htmlWriter.write("<a href='");
                        htmlWriter.write(iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + ACTION_PARAM + "=" + DELETE_NODE_ACTION + "&" + ACTION_TARGET_ID_PARAM + "=" + childInfo.getIdPath() + "&" + CUR_ELEMENT_ID_PARAM + "=" + info.getIdPath());
                        htmlWriter.write("'");
                        htmlWriter.write(" title='");
                        htmlWriter.write(this.getMessage(locale, "action.delete"));
                        htmlWriter.write("'>");
                        htmlWriter.write("<img src='");
                        htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/trash_16.gif");
                        htmlWriter.write("'>");
                        htmlWriter.write("</a>\n");
                        htmlWriter.write("</td>\n");
                        htmlWriter.write("<td align=left nowrap>\n");
                        htmlWriter.write("<a href='" + iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + CUR_ELEMENT_ID_PARAM + "=" + childInfo.getIdPath() + "'>");
                        htmlWriter.write(this.getNiceName(iRequest.getLocale(), childInfo.getObject()));
                        htmlWriter.write("</a>\n");
                        htmlWriter.write("</td>\n");
                        htmlWriter.write("<td align=center>");
                        if (j > 0) {
                            htmlWriter.write("<a href='");
                            htmlWriter.write("#");
                            htmlWriter.write("'");
                            htmlWriter.write(" title='");
                            htmlWriter.write(this.getMessage(locale, "action.up"));
                            htmlWriter.write("'>");
                            htmlWriter.write("<img src='");
                            htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/up_16.gif");
                            htmlWriter.write("'>");
                            htmlWriter.write("</a>");
                        } else {
                            htmlWriter.write("&nbsp;");
                        }
                        htmlWriter.write("</td>\n");
                        htmlWriter.write("<td align=center>");
                        if (j < nbChidren - 1) {
                            htmlWriter.write("<a href='");
                            htmlWriter.write("#");
                            htmlWriter.write("'");
                            htmlWriter.write(" title='");
                            htmlWriter.write(this.getMessage(locale, "action.down"));
                            htmlWriter.write("'>");
                            htmlWriter.write("<img src='");
                            htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/down_16.gif");
                            htmlWriter.write("'>");
                            htmlWriter.write("</a>");
                        } else {
                            htmlWriter.write("&nbsp;");
                        }
                        htmlWriter.write("</td>\n");
                        htmlWriter.write("</tr>\n");
                    }
                }
                if (nbChidren < mapping.getMaxOccurs()) {
                    htmlWriter.write("<tr>\n");
                    htmlWriter.write("<th>&nbsp;</th>\n");
                    htmlWriter.write("<th>&nbsp;</th>\n");
                    htmlWriter.write("<th nowrap>\n");
                    htmlWriter.write("<a href='");
                    htmlWriter.write(iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + ACTION_PARAM + "=" + CREATE_NODE_ACTION + "&" + MAPPING_NAME_PARAM + "=" + mapping.getName() + "&" + CUR_ELEMENT_ID_PARAM + "=" + info.getIdPath());
                    htmlWriter.write("'");
                    htmlWriter.write(" title='");
                    htmlWriter.write(this.getMessage(locale, "action.add"));
                    htmlWriter.write("'>");
                    htmlWriter.write("<img src='");
                    htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/new_16.gif");
                    htmlWriter.write("'>");
                    htmlWriter.write("&nbsp;");
                    htmlWriter.write(this.getMessage(locale, "action.add"));
                    htmlWriter.write("</a>\n");
                    htmlWriter.write("</th>\n");
                    htmlWriter.write("<th>&nbsp;</th>\n");
                    htmlWriter.write("<th>&nbsp;</th>\n");
                    htmlWriter.write("</tr>\n");
                }
                htmlWriter.write("</table>\n");
            }
        } else if (mapping.getMappingType() == 4) {
            if (mapping.getMaxOccurs() <= 1) {
                child2 = (IXmlObject)mapping.getField().get(curObj);
                if (child2 == null) {
                    htmlWriter.write("<a href='");
                    htmlWriter.write(iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + ACTION_PARAM + "=" + CREATE_NODE_ACTION + "&" + MAPPING_NAME_PARAM + "=" + mapping.getName() + "&" + CUR_ELEMENT_ID_PARAM + "=" + info.getIdPath());
                    htmlWriter.write("'");
                    htmlWriter.write(" title='");
                    htmlWriter.write(this.getMessage(locale, "action.create"));
                    htmlWriter.write("'>");
                    htmlWriter.write("<img src='");
                    htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/new_16.gif");
                    htmlWriter.write("'>");
                    htmlWriter.write("</a>\n");
                    htmlWriter.write("&nbsp;");
                    htmlWriter.write("&lt;");
                    htmlWriter.write(this.getMessage(locale, "ObjForm.Object.Null"));
                    htmlWriter.write("&gt;");
                } else {
                    ObjInfo childInfo3 = ctx.getInfoFromObj(child2);
                    htmlWriter.write("<a href='");
                    htmlWriter.write(iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + ACTION_PARAM + "=" + DELETE_NODE_ACTION + "&" + ACTION_TARGET_ID_PARAM + "=" + childInfo3.getIdPath() + "&" + CUR_ELEMENT_ID_PARAM + "=" + info.getIdPath());
                    htmlWriter.write("'");
                    htmlWriter.write(" title='");
                    htmlWriter.write(this.getMessage(locale, "action.delete"));
                    htmlWriter.write("'>");
                    htmlWriter.write("<img src='");
                    htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/trash_16.gif");
                    htmlWriter.write("'>");
                    htmlWriter.write("</a>\n");
                    htmlWriter.write("&nbsp;");
                    htmlWriter.write("<a href='" + iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + CUR_ELEMENT_ID_PARAM + "=" + childInfo3.getIdPath() + "'>");
                    htmlWriter.write(this.getNiceName(iRequest.getLocale(), childInfo3.getObject()));
                    htmlWriter.write("</a>\n");
                }
            } else {
                children = mapping.getField().get(curObj);
                int nbChidren = children == null ? 0 : Array.getLength(children);
                htmlWriter.write("<table border=1 cellpadding=0 cellspacing=0 class=List>\n");
                htmlWriter.write("<tr>\n");
                htmlWriter.write("<th>");
                htmlWriter.write(this.getMessage(locale, "list.index"));
                htmlWriter.write("</th>\n");
                htmlWriter.write("<th>");
                htmlWriter.write(this.getMessage(locale, "list.delete"));
                htmlWriter.write("</th>\n");
                htmlWriter.write("<th>");
                htmlWriter.write(this.getMessage(locale, "list.object"));
                htmlWriter.write("</th>\n");
                htmlWriter.write("<th colspan=2>");
                htmlWriter.write(this.getMessage(locale, "list.move"));
                htmlWriter.write("</th>\n");
                htmlWriter.write("</tr>\n");
                if (nbChidren == 0) {
                    htmlWriter.write("<tr>\n");
                    htmlWriter.write("<td colspan=5>\n");
                    htmlWriter.write(this.getMessage(locale, "list.empty"));
                    htmlWriter.write("</td>\n");
                    htmlWriter.write("</tr>\n");
                } else {
                    for (j = 0; j < nbChidren; ++j) {
                        child = (IXmlObject)Array.get(children, j);
                        childInfo = ctx.getInfoFromObj(child);
                        htmlWriter.write("<tr>\n");
                        htmlWriter.write("<td align=center>");
                        htmlWriter.write(String.valueOf(j));
                        htmlWriter.write("</td>\n");
                        htmlWriter.write("<td align=center>");
                        htmlWriter.write("<a href='");
                        htmlWriter.write(iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + ACTION_PARAM + "=" + DELETE_NODE_ACTION + "&" + ACTION_TARGET_ID_PARAM + "=" + childInfo.getIdPath() + "&" + CUR_ELEMENT_ID_PARAM + "=" + info.getIdPath());
                        htmlWriter.write("'");
                        htmlWriter.write(" title='");
                        htmlWriter.write(this.getMessage(locale, "action.delete"));
                        htmlWriter.write("'>");
                        htmlWriter.write("<img src='");
                        htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/trash_16.gif");
                        htmlWriter.write("'>");
                        htmlWriter.write("</a>\n");
                        htmlWriter.write("</td>\n");
                        htmlWriter.write("<td align=left nowrap>\n");
                        htmlWriter.write("<a href='" + iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + CUR_ELEMENT_ID_PARAM + "=" + childInfo.getIdPath() + "'>");
                        htmlWriter.write(this.getNiceName(iRequest.getLocale(), childInfo.getObject()));
                        htmlWriter.write("</a>\n");
                        htmlWriter.write("</td>\n");
                        htmlWriter.write("<td align=center>");
                        if (j > 0) {
                            htmlWriter.write("<a href='");
                            htmlWriter.write("#");
                            htmlWriter.write("'");
                            htmlWriter.write(" title='");
                            htmlWriter.write(this.getMessage(locale, "action.up"));
                            htmlWriter.write("'>");
                            htmlWriter.write("<img src='");
                            htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/up_16.gif");
                            htmlWriter.write("'>");
                            htmlWriter.write("</a>");
                        } else {
                            htmlWriter.write("&nbsp;");
                        }
                        htmlWriter.write("</td>\n");
                        htmlWriter.write("<td align=center>");
                        if (j < nbChidren - 1) {
                            htmlWriter.write("<a href='");
                            htmlWriter.write("#");
                            htmlWriter.write("'");
                            htmlWriter.write(" title='");
                            htmlWriter.write(this.getMessage(locale, "action.down"));
                            htmlWriter.write("'>");
                            htmlWriter.write("<img src='");
                            htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/down_16.gif");
                            htmlWriter.write("'>");
                            htmlWriter.write("</a>");
                        } else {
                            htmlWriter.write("&nbsp;");
                        }
                        htmlWriter.write("</td>\n");
                        htmlWriter.write("</tr>\n");
                    }
                }
                if (nbChidren < mapping.getMaxOccurs()) {
                    htmlWriter.write("<tr>\n");
                    htmlWriter.write("<th>&nbsp;</th>\n");
                    htmlWriter.write("<th>&nbsp;</th>\n");
                    htmlWriter.write("<th nowrap>\n");
                    htmlWriter.write("<a href='");
                    htmlWriter.write(iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + ACTION_PARAM + "=" + CREATE_NODE_ACTION + "&" + MAPPING_NAME_PARAM + "=" + mapping.getName() + "&" + CUR_ELEMENT_ID_PARAM + "=" + info.getIdPath());
                    htmlWriter.write("'");
                    htmlWriter.write(" title='");
                    htmlWriter.write(this.getMessage(locale, "action.add"));
                    htmlWriter.write("'>");
                    htmlWriter.write("<img src='");
                    htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/new_16.gif");
                    htmlWriter.write("'>");
                    htmlWriter.write("&nbsp;");
                    htmlWriter.write(this.getMessage(locale, "action.add"));
                    htmlWriter.write("</a>\n");
                    htmlWriter.write("</th>\n");
                    htmlWriter.write("<th>&nbsp;</th>\n");
                    htmlWriter.write("<th>&nbsp;</th>\n");
                    htmlWriter.write("</tr>\n");
                }
                htmlWriter.write("</table>\n");
            }
        }
        htmlWriter.write("</td>\n");
        IXmlModelMessage[] messages = ctx.getMappingElementMessages(curObj, mapping.getName());
        htmlWriter.write("<td class=AttrErrors align=left valign=top nowrap>\n");
        if (messages != null) {
            int nbErrors = 0;
            int nbWarnings = 0;
            int nbInfos = 0;
            htmlWriter.write("<div id='Err" + mapping.getName() + "' class=Errors style='position: absolute; display: inline; visibility: hidden;'>\n");
            htmlWriter.write("<table border=0 cellpadding=0 cellspacing=2>\n");
            for (int i = 0; i < messages.length; ++i) {
                htmlWriter.write("<tr>\n");
                htmlWriter.write("<td align=center valign=middle>");
                htmlWriter.write("<img src='");
                switch (messages[i].getSeverity()) {
                    case 0: 
                    case 1: {
                        htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/I_Msg_Error.gif");
                        ++nbErrors;
                        break;
                    }
                    case 2: 
                    case 3: {
                        htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/I_Msg_Warning.gif");
                        ++nbWarnings;
                        break;
                    }
                    default: {
                        htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/I_Msg_Info.gif");
                        ++nbInfos;
                    }
                }
                htmlWriter.write("'>");
                htmlWriter.write("</td>\n");
                htmlWriter.write("<td align=left valign=middle>");
                htmlWriter.write(messages[i].getMessage());
                htmlWriter.write("</td>\n");
                htmlWriter.write("</tr>\n");
            }
            htmlWriter.write("</table>\n");
            htmlWriter.write("</div>\n");
            htmlWriter.write("<span class=Errors onmouseover=\"showPopup(event, this, 'Err" + mapping.getName() + "')\" onmouseout=\"hidePopup(event, 'Err" + mapping.getName() + "')\">\n");
            if (nbErrors > 0) {
                htmlWriter.write("<img src='");
                htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/I_Msg_Error.gif");
                htmlWriter.write("'>");
                htmlWriter.write("&nbsp;:&nbsp;");
                htmlWriter.write(String.valueOf(nbErrors));
            }
            if (nbWarnings > 0) {
                if (nbErrors > 0) {
                    htmlWriter.write(",&nbsp;");
                }
                htmlWriter.write("<img src='");
                htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/I_Msg_Warning.gif");
                htmlWriter.write("'>");
                htmlWriter.write("&nbsp;:&nbsp;");
                htmlWriter.write(String.valueOf(nbWarnings));
            }
            if (nbInfos > 0) {
                if (nbErrors + nbWarnings > 0) {
                    htmlWriter.write(",&nbsp;");
                }
                htmlWriter.write("<img src='");
                htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/I_Msg_Info.gif");
                htmlWriter.write("'>");
                htmlWriter.write("&nbsp;:&nbsp;");
                htmlWriter.write(String.valueOf(nbInfos));
            }
            htmlWriter.write("</span>\n");
        }
        htmlWriter.write("&nbsp;</td>\n");
        htmlWriter.write("</tr>\n");
    }

    public void renderErrors(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException, ParserConfigurationException, SAXException {
        OutputStreamWriter htmlWriter = new OutputStreamWriter((OutputStream)iResponse.getOutputStream(), this.getCharSet());
        iResponse.setContentType("text/html");
        htmlWriter.write("<html>\n");
        htmlWriter.write("<head>\n");
        htmlWriter.write("<title>Bricks Errors</title>\n");
        htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset=" + this.getCharSet() + "'>\n");
        htmlWriter.write("<meta http-equiv='cache-control' content='no-cache'>\n");
        htmlWriter.write("<meta http-equiv='pragma' content='no-cache'>\n");
        htmlWriter.write("<meta http-equiv='expires' content='0'>\n");
        htmlWriter.write("<link href='" + iRequest.getContextPath() + "/bricks_admin/css/bricks_admin.css' rel='stylesheet' type='text/css'>\n");
        htmlWriter.write("</head>\n");
        htmlWriter.write("<body class=Errors>\n");
        XmlEditor ctx = this.getEditor(iRequest);
        IXmlModelMessage[] messages = ctx.getAllMessages();
        htmlWriter.write("<table width='100%' class=Errors border=1 cellpadding=0 cellspacing=0>\n");
        htmlWriter.write("<tr>\n");
        htmlWriter.write("<th>\n");
        htmlWriter.write(this.getMessage(iRequest.getLocale(), "Errors.Index"));
        htmlWriter.write("</th>\n");
        htmlWriter.write("<th>\n");
        htmlWriter.write(this.getMessage(iRequest.getLocale(), "Errors.Severity"));
        htmlWriter.write("</th>\n");
        htmlWriter.write("<th>\n");
        htmlWriter.write(this.getMessage(iRequest.getLocale(), "Errors.Element"));
        htmlWriter.write("</th>\n");
        htmlWriter.write("<th width='100%'>\n");
        htmlWriter.write(this.getMessage(iRequest.getLocale(), "Errors.Message"));
        htmlWriter.write("</th>\n");
        htmlWriter.write("</tr>\n");
        for (int i = 0; i < messages.length; ++i) {
            ObjInfo info = ((ModelMessageImpl)messages[i]).getInfo();
            htmlWriter.write("<tr>\n");
            htmlWriter.write("<td align=center valign=middle>");
            htmlWriter.write(String.valueOf(i));
            htmlWriter.write("</td>\n");
            htmlWriter.write("<td align=center valign=middle>");
            htmlWriter.write("<img src='");
            switch (messages[i].getSeverity()) {
                case 0: 
                case 1: {
                    htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/I_Msg_Error.gif");
                    break;
                }
                case 2: 
                case 3: {
                    htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/I_Msg_Warning.gif");
                    break;
                }
                default: {
                    htmlWriter.write(iRequest.getContextPath() + "/bricks_admin/icons/I_Msg_Info.gif");
                }
            }
            htmlWriter.write("' title='");
            switch (messages[i].getSeverity()) {
                case 0: 
                case 1: {
                    htmlWriter.write(this.getMessage(iRequest.getLocale(), "Errors.error"));
                    break;
                }
                case 2: 
                case 3: {
                    htmlWriter.write(this.getMessage(iRequest.getLocale(), "Errors.warning"));
                    break;
                }
                default: {
                    htmlWriter.write(this.getMessage(iRequest.getLocale(), "Errors.info"));
                }
            }
            htmlWriter.write("'>");
            htmlWriter.write("</td>\n");
            htmlWriter.write("<td align=left valign=middle nowrap>");
            IXmlObject obj = messages[i].getObject();
            htmlWriter.write("<a target='" + MAIN_VIEW + "' href='" + iRequest.getRequestURI() + "?" + VIEW_PARAM + "=" + MAIN_VIEW + "&" + CUR_ELEMENT_ID_PARAM + "=" + info.getIdPath() + "'>");
            htmlWriter.write(this.getNiceName(iRequest.getLocale(), info.getObject()));
            htmlWriter.write("</a>\n");
            htmlWriter.write("</td>\n");
            htmlWriter.write("<td align=left valign=middle>");
            htmlWriter.write(messages[i].getMessage());
            htmlWriter.write("</td>\n");
            htmlWriter.write("</tr>\n");
        }
        htmlWriter.write("</table>\n");
        htmlWriter.write("</body>\n");
        htmlWriter.write("</html>\n");
        ((Writer)htmlWriter).flush();
    }

    private void renderStackPage(HttpServletRequest iRequest, HttpServletResponse iResponse, Throwable iThrowable) throws IOException {
        OutputStreamWriter htmlWriter = new OutputStreamWriter((OutputStream)iResponse.getOutputStream(), this.getCharSet());
        iResponse.setContentType("text/html");
        htmlWriter.write("<html>\n");
        htmlWriter.write("<head>\n");
        htmlWriter.write("<title>Error</title>\n");
        htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset=" + this.getCharSet() + "'>\n");
        htmlWriter.write("<meta http-equiv='cache-control' content='no-cache'>\n");
        htmlWriter.write("<meta http-equiv='pragma' content='no-cache'>\n");
        htmlWriter.write("<meta http-equiv='expires' content='0'>\n");
        htmlWriter.write("</head>\n");
        htmlWriter.write("<body bgcolor='#FFFFFF' style='font-family: Verdana' text='#192c8f'>\n");
        this.renderStack(iRequest, htmlWriter, iThrowable);
        htmlWriter.write("</body>\n");
        htmlWriter.write("</html>\n");
        ((Writer)htmlWriter).flush();
    }

    private void renderStack(HttpServletRequest iRequest, Writer writer, Throwable e) throws IOException {
        String token;
        writer.write("<h3 style='color: #990000;'>" + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()) + "</h3>\n");
        writer.write("Exception type : " + e.getClass().getName() + "<BR>\n");
        StringWriter stackInString = new StringWriter();
        PrintWriter print = new PrintWriter(stackInString);
        e.printStackTrace(print);
        print.close();
        StringTokenizer tokens = new StringTokenizer(stackInString.toString(), "\n");
        if (tokens.hasMoreElements()) {
            tokens.nextElement();
        }
        while (tokens.hasMoreElements()) {
            token = tokens.nextToken().trim();
            if (!token.startsWith("at ")) continue;
            token = token.substring(3);
            writer.write("Exception thrown in :<BR><A style='color: #990000;'>" + token + "</A>\n<P>");
            break;
        }
        tokens = new StringTokenizer(stackInString.toString(), "\n");
        writer.write("Stack trace :<BR><UL>\n");
        if (tokens.hasMoreElements()) {
            tokens.nextElement();
        }
        while (tokens.hasMoreElements()) {
            token = tokens.nextToken().trim();
            if (!token.startsWith("at ")) continue;
            if ((token = token.substring(3)).indexOf("java.lang.reflect.Method.invoke") >= 0 || token.indexOf("javax.servlet.http.HttpServlet.service") >= 0) break;
            writer.write("<LI>" + token + "</LI>\n");
        }
        writer.write("</UL>\n");
        writer.write("<A style='text-decoration: underline; cursor: pointer;' onClick=\"stack.style.display=stack.style.display == 'none' ? 'block' : 'none'\";'>Show Full Stack</A><BR>\n");
        writer.write("<PRE id=stack style='display: none;'>\n");
        writer.write(stackInString.toString());
        writer.write("\n</PRE>\n");
        writer.flush();
    }

    private static String escapeForMessageFormat(String pattern) {
        if (pattern == null || pattern.indexOf(39) < 0) {
            return pattern;
        }
        int n = pattern.length();
        StringBuffer sb = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char ch = pattern.charAt(i);
            if (ch == '\'') {
                sb.append('\'');
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public class J2EEValidator
    implements IValidationSupport {
        private ServletContext _ctx;

        public J2EEValidator(ServletContext context) {
            this._ctx = context;
        }

        public ServletContext getServletContext() {
            return this._ctx;
        }

        public boolean checkResource(String iResourcePath) {
            if (this._ctx == null) {
                return false;
            }
            return this._ctx.getResourceAsStream(iResourcePath) != null;
        }
    }
}

