/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.impl.j2ee;

import com.ebm_ws.infra.bricks.components.interfaces.IRequestProcessor;
import com.ebm_ws.infra.bricks.components.interfaces.IValidationSupport;
import com.ebm_ws.infra.xmlmapping.XmlInstantiator2;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BricksServlet
extends HttpServlet {
    private static final String PROCESSOR_ATTR_NAME = "Bricks.Processor";
    private static final long serialVersionUID = 1L;
    private String _charset = "UTF-8";
    private Exception _initException;
    private XmlInstantiator2 _doc;
    private IRequestProcessor _reqProc;

    public void init() throws ServletException {
        System.err.println("BricksServlet Init:");
        try {
            if (this.getInitParameter("encoding") != null) {
                try {
                    Charset.forName(this.getInitParameter("encoding"));
                    this._charset = this.getInitParameter("encoding");
                }
                catch (Exception e) {
                    System.err.println(" --> Warning: encoding charset '" + this.getInitParameter("encoding") + "' not found.");
                }
            }
            System.err.println(" --> encoding: " + this._charset);
            String xmlfile = this.getInitParameter("xml");
            if (xmlfile == null) {
                throw new ServletException("Init Parameter 'xml' unspecified.");
            }
            URL url = this.getServletContext().getResource(xmlfile);
            if (url == null) {
                throw new ServletException("xml file '" + xmlfile + "' not found.");
            }
            J2EEValidator validSupport = new J2EEValidator(this.getServletContext());
            this._doc = XmlInstantiator2.instantiate((URL)url, (Object)validSupport);
            System.err.println(" --> web site model '" + xmlfile + "' messages:");
            this._doc.dumpMessages(3, new PrintWriter(System.err));
            if (this._doc.getRoot() == null) {
                System.err.println(" --> web site root node instantiated from '" + xmlfile + "' is null.");
            } else if (!(this._doc.getRoot() instanceof IRequestProcessor)) {
                System.err.println(" --> web site root node instantiated from '" + xmlfile + "' is not a IRequestProcessor: " + this._doc.getRoot().getClass().getName());
            } else {
                this._reqProc = (IRequestProcessor)this._doc.getRoot();
                System.err.println(" --> web site root node successfully instantiated from '" + xmlfile + "'.");
            }
            System.err.println("BricksServlet Init Done.");
        }
        catch (Exception e) {
            this._initException = e;
            System.err.println("Error while initializing BricksServlet:");
            e.printStackTrace(System.err);
        }
    }

    private String getCharSet() {
        return this._charset;
    }

    public void service(HttpServletRequest iRequest, HttpServletResponse iResponse) throws ServletException, IOException {
        if (this._initException != null || this._reqProc == null) {
            this.renderInitErrors(iRequest, iResponse);
        } else {
            IRequestProcessor processorForUser = (IRequestProcessor)iRequest.getSession().getAttribute(PROCESSOR_ATTR_NAME);
            if (processorForUser == null) {
                processorForUser = this._reqProc;
                iRequest.getSession().setAttribute(PROCESSOR_ATTR_NAME, (Object)processorForUser);
            }
            try {
                processorForUser.service(iRequest, iResponse);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Throwable t) {
                this.renderStackPage(iRequest, iResponse, t);
            }
        }
    }

    private void renderInitErrors(HttpServletRequest iRequest, HttpServletResponse iResponse) throws IOException {
        OutputStreamWriter htmlWriter = new OutputStreamWriter((OutputStream)iResponse.getOutputStream(), this.getCharSet());
        htmlWriter.write("<html>\n");
        htmlWriter.write("<head>\n");
        htmlWriter.write("<title>Initialization Errors</title>\n");
        htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset=" + this.getCharSet() + "'>\n");
        htmlWriter.write("</head>\n");
        htmlWriter.write("<body>\n");
        if (this._doc.getRoot() == null) {
            htmlWriter.write("<h1>Web Site Model not initialized.</h1>\n");
        } else if (this._doc.hasMessages(1)) {
            htmlWriter.write("<h1>Web Site Model has errors.</h1>\n");
            htmlWriter.write("<pre>\n");
            this._doc.dumpMessages(1, new PrintWriter(htmlWriter));
            htmlWriter.write("</pre>\n");
        }
        if (this._initException != null) {
            this.renderStack(iRequest, iResponse, htmlWriter, this._initException);
        }
        htmlWriter.write("</body>");
        htmlWriter.write("</html>");
        ((Writer)htmlWriter).flush();
    }

    private void renderStackPage(HttpServletRequest iRequest, HttpServletResponse iResponse, Throwable iThrowable) throws IOException {
        OutputStreamWriter htmlWriter = new OutputStreamWriter((OutputStream)iResponse.getOutputStream(), this.getCharSet());
        htmlWriter.write("<html>\n");
        htmlWriter.write("<head>\n");
        htmlWriter.write("<title>Error</title>\n");
        htmlWriter.write("<meta http-equiv='content-type' content='text/html;charset=" + this.getCharSet() + "'>\n");
        htmlWriter.write("</head>\n");
        htmlWriter.write("<body bgcolor='#FFFFFF' style='font-family: Verdana' text='#192c8f'>\n");
        this.renderStack(iRequest, iResponse, htmlWriter, iThrowable);
        htmlWriter.write("</body>\n");
        htmlWriter.write("</html>\n");
        ((Writer)htmlWriter).flush();
    }

    private void renderStack(HttpServletRequest iRequest, HttpServletResponse iResponse, Writer writer, Throwable e) throws IOException {
        String token;
        writer.write("<h3 style='color: #990000;'>" + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()) + "</h3>\n");
        writer.write("Exception type : " + e.getClass().getName() + "<BR>\n");
        StringWriter stackInString = new StringWriter();
        PrintWriter print = new PrintWriter(stackInString);
        e.printStackTrace(print);
        print.close();
        StringTokenizer tokens = new StringTokenizer(stackInString.toString(), "\n");
        if (tokens.hasMoreElements()) {
            tokens.nextElement();
        }
        while (tokens.hasMoreElements()) {
            token = tokens.nextToken().trim();
            if (!token.startsWith("at ")) continue;
            token = token.substring(3);
            writer.write("Exception thrown in :<BR><A style='color: #990000;'>" + token + "</A>\n<P>");
            break;
        }
        tokens = new StringTokenizer(stackInString.toString(), "\n");
        writer.write("Stack trace :<BR><UL>\n");
        if (tokens.hasMoreElements()) {
            tokens.nextElement();
        }
        while (tokens.hasMoreElements()) {
            token = tokens.nextToken().trim();
            if (!token.startsWith("at ")) continue;
            if ((token = token.substring(3)).indexOf("java.lang.reflect.Method.invoke") >= 0 || token.indexOf("javax.servlet.http.HttpServlet.service") >= 0) break;
            writer.write("<LI>" + token + "</LI>\n");
        }
        writer.write("</UL>\n");
        writer.write("<A style='text-decoration: underline; cursor: hand;' onClick='stack.style.visibility=\"visible\";'>Show Full Stack</A><BR>\n");
        writer.write("<PRE id=stack style='visibility: hidden;'>\n");
        writer.write(stackInString.toString());
        writer.write("\n</PRE>\n");
        writer.flush();
    }

    public class J2EEValidator
    implements IValidationSupport {
        private ServletContext _ctx;

        public J2EEValidator(ServletContext iImageContext) {
            this._ctx = iImageContext;
        }

        public ServletContext getServletContext() {
            return this._ctx;
        }

        public boolean checkResource(String iResourcePath) {
            if (this._ctx == null) {
                return true;
            }
            if (iResourcePath == null) {
                return true;
            }
            if (!iResourcePath.startsWith("/")) {
                iResourcePath = "/" + iResourcePath;
            }
            try {
                return this._ctx.getResource(iResourcePath) != null;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
    }
}

