/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.impl.multiparts;

import com.ebm_ws.infra.bricks.impl.multiparts.IPart;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiPartsProcessor
extends InputStream
implements IPart {
    private static Log _trace = LogFactory.getLog(MultiPartsProcessor.class);
    private static Hashtable<String, String> _params = new Hashtable();
    private static char CR = (char)13;
    private static char LF = (char)10;
    private static String CR_ONLY = "\r";
    private static String CRLF = "\r\n";
    private static String BLANK_CHARS = " \t";
    private static String HEADERSEP_CHARS = "=;:";
    private static String RET_CHARS = "\n\r";
    private static String NULL_VALUE = "NULL";
    private static int BUFFER_MAX_LEN = 128;
    private ByteArrayOutputStream _bytesBuffer = new ByteArrayOutputStream();
    private String encoding;
    private byte[] _boundary;
    private InputStream _input;
    private int _curByte;
    private int _fifoPos = 0;
    private byte[] _fifoBuffer;
    private Hashtable<String, String> _formData = new Hashtable();
    private String _inputValue = null;
    private boolean _emptyStream = false;

    public MultiPartsProcessor(HttpServletRequest iRequest, String iCharSet, int bufferSize) throws IOException {
        this(iRequest.getContentType(), (InputStream)iRequest.getInputStream(), iCharSet, bufferSize);
    }

    public MultiPartsProcessor(String iContentType, InputStream iInput, String iCharSet, int bufferSize) throws IOException {
        this._input = iInput;
        if (bufferSize > 0) {
            this._input = new BufferedInputStream(iInput, bufferSize);
        }
        this.encoding = iCharSet;
        String boundary = this.getBoundary(iContentType);
        _trace.debug((Object)("new MultiPartsProcessor with boundary [" + boundary + "]."));
        boundary = CRLF + "--" + boundary;
        this._boundary = boundary.getBytes();
        this._fifoBuffer = new byte[this._boundary.length];
        this._fifoPos = 0;
        this._fifoBuffer[0] = (byte)CR;
        this._fifoBuffer[1] = (byte)LF;
        this.fillBuffer(this._fifoBuffer, 2, this._boundary.length - 2);
    }

    private String getBoundary(String iContentType) {
        int idx = iContentType.lastIndexOf("boundary=");
        if (idx < 0) {
            return null;
        }
        String boundary = iContentType.substring(idx + 9);
        if (boundary.charAt(0) == '\"') {
            idx = boundary.lastIndexOf(34);
            boundary = boundary.substring(1, idx);
        }
        return boundary;
    }

    private boolean isOnBoundary() {
        for (int i = this._boundary.length - 1; i >= 0; --i) {
            if (this._boundary[i] == this._fifoBuffer[(i + this._fifoPos) % this._boundary.length]) continue;
            return false;
        }
        return true;
    }

    private boolean internalHasMoreParts() throws IOException {
        int c;
        if (_trace.isDebugEnabled()) {
            _trace.debug((Object)"Info: look for next part...");
        }
        this._formData.clear();
        this._inputValue = null;
        this._emptyStream = false;
        this._bytesBuffer.reset();
        int skipped = 0;
        while ((c = this.read()) >= 0) {
            if (skipped <= BUFFER_MAX_LEN) {
                this._bytesBuffer.write(c);
            }
            ++skipped;
        }
        if (skipped > 0) {
            if (_trace.isDebugEnabled()) {
                if (skipped > this._bytesBuffer.size()) {
                    _trace.debug((Object)("Info: skipped " + skipped + " bytes from last part: [" + this._bytesBuffer.toString() + "...]."));
                } else {
                    _trace.debug((Object)("Info: skipped " + skipped + " bytes from last part: [" + this._bytesBuffer.toString() + "]."));
                }
            } else if (_trace.isDebugEnabled()) {
                _trace.debug((Object)("Info: skipped " + skipped + " bytes from last part."));
            }
        }
        int b1 = this.nextByte();
        int b2 = this.nextByte();
        if (b1 != CR || b2 != LF) {
            if (b1 != 45 || b2 != 45) {
                _trace.debug((Object)("Warning: unexpected bytes after terminating boundary: '" + b1 + "' '" + b2 + "'"));
            }
            b1 = this.nextByte();
            b2 = this.nextByte();
            if (b1 < 0 || b2 < 0) {
                _trace.debug((Object)"Info: terminating boundary read. No more part.");
                return false;
            }
            this._bytesBuffer.reset();
            skipped = 0;
            if (b1 != CR || b2 != LF) {
                this._bytesBuffer.write(b1);
                this._bytesBuffer.write(b2);
                skipped += 2;
            }
            while ((c = this.nextByte()) >= 0) {
                if (skipped <= BUFFER_MAX_LEN) {
                    this._bytesBuffer.write(c);
                }
                ++skipped;
            }
            _trace.debug((Object)"Info: terminating boundary read. No more part.");
            return false;
        }
        if (_trace.isDebugEnabled()) {
            _trace.debug((Object)"Info: init next part...");
        }
        this.readHeaders();
        int nbread = this.fillBuffer(this._fifoBuffer, 0, this._fifoBuffer.length);
        this._fifoPos = 0;
        if (nbread < this._boundary.length) {
            _trace.debug((Object)("Error: unexpected input stream end (" + nbread + " bytes read instead of " + this._boundary.length + ")."));
            return false;
        }
        if (this.isFileUpload()) {
            _trace.debug((Object)("Info: file upload part [" + this.getInputName() + "]=[" + this.getFileName() + "] (" + this.getFileContentType() + ") initialised."));
            if (this.isOnBoundary()) {
                this._emptyStream = true;
                _trace.debug((Object)"Warning: file input stream is empty.");
            }
        } else {
            this._bytesBuffer.reset();
            while ((c = this.read()) >= 0) {
                this._bytesBuffer.write(c);
            }
            this._inputValue = this._bytesBuffer.toString(this.encoding);
            _trace.debug((Object)("Info: input data part [" + this.getInputName() + "]=[" + this._inputValue + "]."));
            _params.put(this.getInputName(), this._inputValue);
        }
        return true;
    }

    private void readHeaders() throws IOException {
        String headerLine;
        while (this._curByte >= 0 && (headerLine = this.readUnicodeLine()) != null) {
            StringParser sa = new StringParser(headerLine);
            this.readHeader(sa);
            if (sa.available() <= 0) continue;
            _trace.debug((Object)("Warning: skipped " + sa.available() + " chars after terminating boundary: [" + sa.getAvailable() + "]."));
        }
    }

    private void readHeader(StringParser iParser) throws IOException {
        String headerName = iParser.readStringUntil(BLANK_CHARS + HEADERSEP_CHARS + CR);
        if (headerName == null) {
            _trace.debug((Object)"Warning: null header name read. Skip rest of line.");
            return;
        }
        headerName = headerName.toLowerCase();
        if (!iParser.readChar(':', BLANK_CHARS)) {
            _trace.debug((Object)("Warning: ':' expected after header name [" + headerName + "] : '" + this._curByte + "' read instead. Skip rest of line."));
            return;
        }
        iParser.skipChars(BLANK_CHARS);
        String headerValue = iParser.readStringUntil(BLANK_CHARS + HEADERSEP_CHARS + CR);
        if (headerValue == null) {
            _trace.debug((Object)("Warning: null header value read for [" + headerName + "]."));
            this._formData.put(headerName, NULL_VALUE);
        } else {
            if (_trace.isDebugEnabled()) {
                _trace.debug((Object)("Info: header read [" + headerName + "] = [" + headerValue + "]."));
            }
            this._formData.put(headerName, headerValue);
        }
        iParser.skipChars(BLANK_CHARS);
        while (iParser.available() > 0) {
            String optValue;
            if (!iParser.readChar(';', BLANK_CHARS)) {
                _trace.debug((Object)("Warning: ';' expected after header name and value [" + headerName + "] = [" + headerValue + "] : '" + this._curByte + "' read instead. Skip rest of line."));
                return;
            }
            iParser.skipChars(BLANK_CHARS);
            String optName = iParser.readStringUntil(BLANK_CHARS + HEADERSEP_CHARS + CR);
            if (optName == null) {
                _trace.debug((Object)"Warning: null optional header name. Skip rest of line.");
                return;
            }
            if (!iParser.readChar('=', BLANK_CHARS)) {
                _trace.debug((Object)("Warning: '=' expected after header optional name [" + optName + "]. '" + this._curByte + "' read instead. Skip rest of line."));
                return;
            }
            boolean quotes = iParser.readChar('\"', BLANK_CHARS);
            String string = optValue = quotes ? iParser.readStringUntil("\"" + CR) : iParser.readStringUntil(";" + CR);
            if (quotes && !iParser.readChar('\"', null)) {
                _trace.debug((Object)("Warning: closing quotes expected after header optional [" + optName + "] = [" + optValue + "]. '" + this._curByte + "' read instead. Skip rest of line."));
                return;
            }
            if (_trace.isDebugEnabled()) {
                _trace.debug((Object)("Info: optional header read [" + optName + "]=[" + optValue + "]"));
            }
            if (optValue == null) {
                this._formData.put(headerName + "@" + optName, NULL_VALUE);
            } else {
                this._formData.put(headerName + "@" + optName, optValue);
            }
            iParser.skipChars(BLANK_CHARS);
        }
    }

    private int nextByte() throws IOException {
        this._curByte = this._input.read();
        return this._curByte;
    }

    private int fillBuffer(byte[] oBuffer, int iOffset, int iLen) throws IOException {
        int len;
        for (len = this._input.read(oBuffer, iOffset, iLen); len < iLen; ++len) {
            int b = this._input.read();
            if (b < 0) {
                return len;
            }
            oBuffer[iOffset + len] = (byte)b;
        }
        return len;
    }

    private String readUnicodeLine() throws IOException {
        this._bytesBuffer.reset();
        int b1 = this.nextByte();
        int b2 = this.nextByte();
        while (b2 >= 0 && (b1 != CR || b2 != LF)) {
            this._bytesBuffer.write(b1);
            b1 = b2;
            b2 = this.nextByte();
        }
        if (this._bytesBuffer.size() == 0) {
            return null;
        }
        return this._bytesBuffer.toString(this.encoding);
    }

    public int read() throws IOException {
        if (this.isOnBoundary()) {
            return -1;
        }
        int newc = this.nextByte();
        if (newc < 0) {
            _trace.debug((Object)"Error: end of input stream reached before terminating boundary!");
            throw new IOException("End of input stream reached before terminating boundary.");
        }
        int retc = this._fifoBuffer[this._fifoPos];
        if (retc < 0) {
            retc += 256;
        }
        this._fifoBuffer[this._fifoPos] = (byte)newc;
        ++this._fifoPos;
        if (this._fifoPos >= this._boundary.length) {
            this._fifoPos = 0;
        }
        return retc;
    }

    public boolean hasMoreParts() {
        try {
            return this.internalHasMoreParts();
        }
        catch (IOException e) {
            _trace.debug((Object)"Error: IOException in internalHasMoreParts():", (Throwable)e);
            return false;
        }
    }

    public IPart nextPart() {
        return this;
    }

    public String getParameter(String iName) {
        return _params.get(iName);
    }

    private String getFormData(String iEntry) {
        String val = this._formData.get(iEntry);
        if (val == NULL_VALUE) {
            return null;
        }
        return val;
    }

    public String getFileName() {
        return this.getFormData("content-disposition@filename");
    }

    public InputStream getFileInputStream() {
        return this;
    }

    public String getInputName() {
        return this.getFormData("content-disposition@name");
    }

    public String getDataInputValue() {
        return this._inputValue;
    }

    public String getFileContentType() {
        return this.getFormData("content-type");
    }

    public boolean isFileUpload() {
        return this._formData.get("content-disposition@filename") != null;
    }

    public boolean looksLikeAnInvalidFile() {
        return this._emptyStream;
    }

    private static class StringParser {
        private String _string;
        private int idx = 0;

        public StringParser(String iString) {
            this._string = iString;
        }

        public int available() {
            return this._string.length() - this.idx;
        }

        public String getAvailable() {
            return this._string.substring(this.idx);
        }

        private int curChar() {
            if (this.idx >= this._string.length()) {
                return -1;
            }
            return this._string.charAt(this.idx);
        }

        private int nextChar() {
            ++this.idx;
            return this.curChar();
        }

        public boolean readChar(char c, String skip) {
            if (skip != null) {
                this.skipChars(skip);
            }
            if (this.curChar() != c) {
                return false;
            }
            this.nextChar();
            return true;
        }

        public void skipChars(String chars) {
            while (this.curChar() >= 0 && chars.indexOf(this.curChar()) >= 0) {
                this.nextChar();
            }
        }

        public String readStringUntil(String chars) throws IOException {
            StringBuffer sb = new StringBuffer();
            while (this.curChar() >= 0 && chars.indexOf(this.curChar()) < 0) {
                sb.append((char)this.curChar());
                this.nextChar();
            }
            if (sb.length() == 0) {
                return null;
            }
            return sb.toString();
        }
    }
}

