/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.impl.tools;

import com.ebm_ws.infra.bricks.components.interfaces.IValidationSupport;
import com.ebm_ws.infra.xmlmapping.XmlInstantiator2;
import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;

public class Validator {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: Validator <xml> <root web app> [<level>]");
            return;
        }
        String xmlFileName = args[0];
        String webRootDirName = args[1];
        String level = args.length > 2 ? args[2] : "w";
        int dumpLevel = 3;
        if (level.startsWith("e") || level.startsWith("E")) {
            dumpLevel = 1;
        } else if (level.startsWith("i") || level.startsWith("I")) {
            dumpLevel = 5;
        }
        File xmlFile = new File(xmlFileName);
        if (!xmlFile.exists()) {
            System.err.println("xml file [" + xmlFileName + "] not found.");
            return;
        }
        File webRootDir = new File(webRootDirName);
        if (!webRootDir.exists()) {
            System.err.println("Web App Root directory [" + webRootDirName + "] not found.");
            return;
        }
        File webInfDir = new File(webRootDir, "WEB-INF");
        if (!webInfDir.exists()) {
            System.err.println("Warning: Directory [" + webRootDirName + "] doesn't look like a Web App Root directory (no WEB-INF found).");
        }
        System.out.println("Validating Bricks XML: " + xmlFileName);
        String urlStr = "file:/" + xmlFile.getAbsolutePath().replace('\\', '/');
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            System.err.println("Error while building xml file url [" + urlStr + "].");
            e.printStackTrace(System.err);
            return;
        }
        try {
            J2EEValidator validSupport = new J2EEValidator(webRootDirName);
            XmlInstantiator2 doc = XmlInstantiator2.instantiate((URL)url, (Object)validSupport);
            System.out.println(" --> XML Model instantiation done.");
            System.out.println("Dumping messages (" + (dumpLevel == 1 ? "error" : (dumpLevel == 3 ? "warning" : "info")) + "):");
            doc.dumpMessages(dumpLevel, new PrintWriter(System.out));
        }
        catch (Exception e) {
            System.err.println("Error while instantiating xml model.");
            e.printStackTrace(System.err);
            return;
        }
    }

    public static class J2EEValidator
    implements IValidationSupport {
        private String _webRoot;

        public J2EEValidator(String iWebRoot) {
            this._webRoot = iWebRoot.replace('\\', '/');
            if (!this._webRoot.endsWith("/")) {
                this._webRoot = this._webRoot + "/";
            }
        }

        public ServletContext getServletContext() {
            return null;
        }

        public boolean checkResource(String iResourcePath) {
            File f = new File(this._webRoot + iResourcePath);
            return f.exists();
        }
    }
}

