/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.trash;

import com.ebm_ws.infra.bricks.util.HtmlUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;

public class HtmlWriterImpl
extends HtmlUtils {
    private static Vector _freeBuffers = new Vector();
    private static int MAX_BUFFERS_IN_CACHE = 256;
    private static int INIT_BUFFER_SIZE = 1024;
    private StringBuffer _buffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getBuffer() {
        if (this._buffer == null) {
            Vector vector = _freeBuffers;
            synchronized (vector) {
                if (_freeBuffers.size() > 0) {
                    this._buffer = (StringBuffer)_freeBuffers.lastElement();
                    _freeBuffers.setSize(_freeBuffers.size() - 1);
                }
            }
            if (this._buffer == null) {
                this._buffer = new StringBuffer(INIT_BUFFER_SIZE);
            }
        }
        return this._buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBuffer() {
        if (this._buffer != null) {
            this._buffer.setLength(0);
            Vector vector = _freeBuffers;
            synchronized (vector) {
                if (_freeBuffers.size() < MAX_BUFFERS_IN_CACHE) {
                    _freeBuffers.addElement(this._buffer);
                }
            }
            this._buffer = null;
        }
    }

    public void flush() throws IOException {
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.getBuffer().append(cbuf, off, len);
    }

    public void writeComment(String iComment) throws IOException {
        this.print("<!-- ========== ");
        this.print(HtmlWriterImpl.encode2HTML(iComment));
        this.println(" ========== -->");
    }

    public void print(String iHTML) throws IOException {
        if (iHTML == null) {
            iHTML = "@null@";
        }
        this.getBuffer().append(iHTML);
    }

    public void println(String iHTML) throws IOException {
        this.getBuffer().append(iHTML).append('\n');
    }

    public void flush(Writer iWriter) throws IOException {
        if (this._buffer != null) {
            iWriter.write(this._buffer.toString());
            this.releaseBuffer();
            iWriter.flush();
        }
    }

    public void close() {
        this.releaseBuffer();
    }

    public int getPosition() {
        if (this._buffer == null) {
            return 0;
        }
        return this._buffer.length();
    }

    public void rollbackToPosition(int iPosition) {
        if (this._buffer != null) {
            this._buffer.setLength(iPosition);
        }
    }

    protected void finalize() throws Throwable {
        this.releaseBuffer();
    }
}

