/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.util;

import com.ebm_ws.infra.bricks.components.base.enums.Scope;
import com.ebm_ws.infra.bricks.session.BricksSession;
import javax.servlet.http.HttpServletRequest;

public class BeanUtils {
    public static Object getBricksBean(HttpServletRequest iRequest, String iBeanName) throws Exception {
        BricksSession session = BricksSession.getSession(iRequest);
        return session.getApplication().getBeanValue(iRequest, iBeanName);
    }

    public static Object getBean(HttpServletRequest iRequest, Class iClass, String iName, Scope iScope) {
        String name = iName == null ? iClass.getName() : iName;
        Object obj = null;
        if (iScope == Scope.Request) {
            obj = iRequest.getAttribute(name);
        } else if (iScope == Scope.Session) {
            obj = iRequest.getSession().getAttribute(name);
        } else if (iScope == Scope.Application) {
            obj = iRequest.getSession().getServletContext().getAttribute(name);
        } else if (iScope == Scope.PageContext) {
            BricksSession session = BricksSession.getSession(iRequest);
            obj = session.getCurrentPageContext().getAttribute(name);
        }
        return obj;
    }

    public static void setBean(HttpServletRequest iRequest, Object iBean, String iName, Scope iScope) {
        String name;
        String string = name = iName == null ? iBean.getClass().getName() : iName;
        if (iScope == Scope.Request) {
            iRequest.setAttribute(name, iBean);
        } else if (iScope == Scope.Session) {
            iRequest.getSession().setAttribute(name, iBean);
        } else if (iScope == Scope.Application) {
            iRequest.getSession().getServletContext().setAttribute(name, iBean);
        } else if (iScope == Scope.PageContext) {
            BricksSession session = BricksSession.getSession(iRequest);
            session.getCurrentPageContext().setAttribute(name, iBean);
        }
    }
}

