/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.util;

import com.ebm_ws.infra.bricks.components.base.param.UrlParameterDef;
import com.ebm_ws.infra.bricks.session.BricksSession;
import com.ebm_ws.infra.bricks.session.IPageContext;
import com.ebm_ws.infra.bricks.util.UrlBuilder;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class BricksUrlBuilder
extends UrlBuilder {
    private String context;
    private String servlet;
    private String selector;
    private String path;
    public static final String PAGE_SELECTOR = "page";
    public static final String SERVICE_SELECTOR = "srv";
    public static final String RESOURCE_SELECTOR = "res";

    public static BricksUrlBuilder copyFromRequest(HttpServletRequest iRequest, boolean iCopyParameters) {
        return new BricksUrlBuilder(iRequest, iCopyParameters);
    }

    public static BricksUrlBuilder createPageUrl(HttpServletRequest iRequest, String iPage, boolean iKeepContext) {
        BricksSession session;
        IPageContext context;
        UrlParameterDef[] contextParameters;
        BricksUrlBuilder url = new BricksUrlBuilder(iRequest, false);
        url.setSelector(PAGE_SELECTOR);
        url.setPath(iPage);
        if (iKeepContext && (contextParameters = (context = (session = BricksSession.getSession(iRequest)).getCurrentPageContext()).getContextDef().getInputParameters()) != null) {
            for (int i = 0; i < contextParameters.length; ++i) {
                String val = context.getInputParameter(contextParameters[i].getName());
                if (val == null) continue;
                url.setParameter(contextParameters[i].getName(), val);
            }
        }
        return url;
    }

    public static BricksUrlBuilder createResourceUrl(HttpServletRequest iRequest, String iResourcePath, String iMimeType) {
        BricksUrlBuilder url = new BricksUrlBuilder(iRequest, false);
        url.setSelector(RESOURCE_SELECTOR);
        url.setPath(iResourcePath);
        if (iMimeType != null) {
            url.setParameter("mime-type", iMimeType);
        }
        return url;
    }

    private BricksUrlBuilder() {
        super(null);
    }

    private BricksUrlBuilder(HttpServletRequest iRequest, boolean iCopyParameters) {
        block11: {
            block10: {
                super(null);
                String[] path = iRequest.getRequestURI().split("/");
                int idx = 1;
                if (idx < path.length) {
                    this.context = path[idx++];
                    if (idx < path.length) {
                        this.servlet = path[idx++];
                        if (idx < path.length) {
                            this.selector = path[idx++];
                            if (idx < path.length) {
                                this.setPathTokens(path, idx);
                            }
                        }
                    }
                }
                if (!iCopyParameters) {
                    return;
                }
                boolean ispost = "post".equalsIgnoreCase(iRequest.getMethod());
                if (!ispost) break block10;
                String query = iRequest.getQueryString();
                if (query == null) {
                    return;
                }
                if (query.startsWith("?")) {
                    query = query.substring(1);
                }
                StringTokenizer st = new StringTokenizer(query, "&");
                while (st.hasMoreTokens()) {
                    String name = st.nextToken();
                    int idxEq = name.indexOf(61);
                    if (idxEq >= 0) {
                        name = name.substring(0, idxEq);
                    }
                    if (name.startsWith("_")) continue;
                    this.setParameter(name, iRequest.getParameter(name));
                }
                break block11;
            }
            Enumeration params = iRequest.getParameterNames();
            if (params == null) break block11;
            while (params.hasMoreElements()) {
                String name = (String)params.nextElement();
                if (name.startsWith("_")) continue;
                this.setParameter(name, iRequest.getParameter(name));
            }
        }
    }

    public String getContext() {
        return this.context;
    }

    public String getServlet() {
        return this.servlet;
    }

    public String getSelector() {
        return this.selector;
    }

    public String getPath() {
        return this.path;
    }

    public String[] getPathTokens() {
        if (this.path == null) {
            return null;
        }
        return this.path.split("/");
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPathTokens(String[] pathTokens, int offset) {
        if (pathTokens == null || pathTokens.length - offset <= 0) {
            this.setPath(null);
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < pathTokens.length; ++i) {
            if (i > offset) {
                sb.append("/");
            }
            sb.append(pathTokens[i]);
        }
        this.path = sb.toString();
    }

    public void setSelector(String selector) {
        this.selector = selector;
        this.path = null;
    }

    public String getRequestUri() {
        StringBuffer sb = new StringBuffer();
        sb.append("/");
        sb.append(this.context);
        sb.append("/");
        sb.append(this.servlet);
        if (this.selector != null) {
            sb.append("/");
            sb.append(this.selector);
            if (this.path != null) {
                sb.append("/");
                sb.append(this.path);
            }
        }
        return sb.toString();
    }
}

