/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.util;

import com.ebm_ws.infra.bricks.util.BricksUrlBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HtmlUtils {
    public static void writeStack(PrintWriter writer, Throwable iThrowable) throws IOException {
        writer.print("<p style='font-size: 10pt; color: black;'>");
        writer.print("<span style='font-size: 12pt; color: #FF9933;'>");
        if (iThrowable.getMessage() == null) {
            writer.print(iThrowable.getClass().getName());
        } else {
            writer.print(iThrowable.getMessage());
        }
        writer.print("</span>\n");
        writer.print("<br/>\n");
        writer.print("Exception type : ");
        writer.print(iThrowable.getClass().getName());
        writer.print("<br/>\n");
        StringWriter stackInString = new StringWriter();
        PrintWriter print = new PrintWriter(stackInString);
        iThrowable.printStackTrace(print);
        print.close();
        StringTokenizer tokens = new StringTokenizer(stackInString.toString(), "\n");
        if (tokens.hasMoreElements()) {
            tokens.nextElement();
        }
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken().trim();
            if (!token.startsWith("at ")) continue;
            token = token.substring(3);
            writer.print("Exception thrown in : ");
            writer.print("<span style='font-size: 12px; color: #FF9933;'>");
            writer.print(token);
            writer.print("</span>\n");
            writer.print("<br/>\n");
            break;
        }
        tokens = new StringTokenizer(stackInString.toString(), "\n");
        writer.print("<span style='font-size: 12px; color: #FF9933; text-decoration: underline; cursor: hand;' onclick='stack.style.display=\"block\";'>Show Full Stack</span><br/>\n");
        writer.print("<pre id=stack style='font: sans-serif; font-size: 8pt; color: black; display: none;'>\n");
        writer.print(stackInString.toString());
        writer.print("\n</pre>\n");
        writer.print("</p>\n");
    }

    public static String encode2HTML(String text) {
        return HtmlUtils.encode2HTML(text, false);
    }

    public static String encode2HTML(String text, boolean iNBSP) {
        if (text == null) {
            return "";
        }
        if (text.startsWith("\\html\\")) {
            return text.substring(6);
        }
        int nbChars = text.length();
        StringBuffer sb = new StringBuffer(nbChars);
        block10: for (int i = 0; i < nbChars; ++i) {
            char c = text.charAt(i);
            if (iNBSP && c == ' ') {
                sb.append("&nbsp;");
                continue;
            }
            switch (c) {
                case '\n': {
                    sb.append("<br>");
                    continue block10;
                }
                case '\r': {
                    sb.append(" ");
                    continue block10;
                }
                case '\t': {
                    sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    continue block10;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block10;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block10;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block10;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String encode2JsString(String text) {
        int nbChars = text.length();
        StringBuffer sb = new StringBuffer(nbChars);
        block7: for (int i = 0; i < nbChars; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static void includeJavaScript(HttpServletRequest iRequest, HttpServletResponse iResponse, String iJavascriptFilePath) throws IOException {
        if (iRequest.getAttribute("JAVASCRIPT_" + iJavascriptFilePath) != null) {
            return;
        }
        iRequest.setAttribute("JAVASCRIPT_" + iJavascriptFilePath, (Object)Boolean.TRUE);
        BricksUrlBuilder jsUrl = BricksUrlBuilder.createResourceUrl(iRequest, iJavascriptFilePath, null);
        iResponse.getWriter().print("<script language='javascript' type='text/javascript' src='");
        iResponse.getWriter().print(jsUrl.toUrl(iResponse.getCharacterEncoding(), true));
        iResponse.getWriter().println("'></script>");
    }

    public static void includeBricksJavaScript(HttpServletRequest iRequest, HttpServletResponse iResponse, String iJavascriptFileName) throws IOException {
        HtmlUtils.includeJavaScript(iRequest, iResponse, "com/ebm_ws/infra/bricks/js/" + iJavascriptFileName);
    }

    public static final String formatId(String iNonFormattedId) {
        if (iNonFormattedId == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(iNonFormattedId.length());
        int invalidCharsRead = 0;
        for (int i = 0; i < iNonFormattedId.length(); ++i) {
            char c = iNonFormattedId.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.') {
                if (invalidCharsRead > 0 && sb.length() > 0) {
                    sb.append('_');
                }
                sb.append(c);
                invalidCharsRead = 0;
                continue;
            }
            ++invalidCharsRead;
        }
        return sb.toString();
    }

    public static final String getHTML401TransitionalDoctype() {
        return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">";
    }
}

