/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ReflectionHelper {
    public static Class type2Class(Type iType) {
        if (iType instanceof Class) {
            return (Class)iType;
        }
        if (iType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)iType).getRawType();
        }
        if (iType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)iType).getGenericComponentType();
            Class componentClass = ReflectionHelper.type2Class(componentType);
            return Array.newInstance(componentClass, 0).getClass();
        }
        return null;
    }

    public static Class getNonPrimitiveClass(Class iClass) {
        if (!iClass.isPrimitive()) {
            return iClass;
        }
        if (iClass == Integer.TYPE) {
            return Integer.class;
        }
        if (iClass == Boolean.TYPE) {
            return Boolean.class;
        }
        if (iClass == Double.TYPE) {
            return Double.class;
        }
        if (iClass == Float.TYPE) {
            return Float.class;
        }
        if (iClass == Short.TYPE) {
            return Short.class;
        }
        if (iClass == Byte.TYPE) {
            return Byte.class;
        }
        return null;
    }

    public static boolean isAssignable(Class iClass1, Class iClass2) {
        if (iClass1 == null || iClass2 == null) {
            return false;
        }
        if (ReflectionHelper.isIntegerLike(iClass1) && ReflectionHelper.isIntegerLike(iClass2)) {
            return true;
        }
        iClass1 = ReflectionHelper.getNonPrimitiveClass(iClass1);
        iClass2 = ReflectionHelper.getNonPrimitiveClass(iClass2);
        return iClass1.isAssignableFrom(iClass2);
    }

    public static Class getBestCompatibleClass(Class[] iClasses) {
        if (iClasses == null) {
            return null;
        }
        if (iClasses.length == 0) {
            return Object.class;
        }
        Class c = iClasses[0];
        if (c == Object.class) {
            return Object.class;
        }
        for (int i = 1; i < iClasses.length; ++i) {
            while (!iClasses[i].isAssignableFrom(c)) {
                if ((c = c.getSuperclass()) != Object.class) continue;
                return Object.class;
            }
        }
        return c;
    }

    public static Class getVectorElementClass(Type iType) {
        Type t = ReflectionHelper.getVectorElementType(iType);
        if (t == null) {
            return null;
        }
        return ReflectionHelper.type2Class(t);
    }

    public static Type getVectorElementType(Type iType) {
        if (iType instanceof Class) {
            Class c = (Class)iType;
            if (c.isArray()) {
                return c.getComponentType();
            }
            if (List.class.isAssignableFrom(c)) {
                return Object.class;
            }
            return null;
        }
        if (iType instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)iType;
            Class c = (Class)t.getRawType();
            if (c.isArray()) {
                return c.getComponentType();
            }
            if (List.class.isAssignableFrom(c)) {
                return t.getActualTypeArguments()[0];
            }
            return null;
        }
        if (iType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)iType).getGenericComponentType();
            return componentType;
        }
        return null;
    }

    public static boolean isVector(Type iType) {
        return ReflectionHelper.getVectorElementClass(iType) != null;
    }

    public static List obj2List(Object iVector) {
        if (iVector == null) {
            return null;
        }
        if (iVector.getClass().isArray()) {
            int len = Array.getLength(iVector);
            ArrayList<Object> ret = new ArrayList<Object>(len);
            for (int i = 0; i < len; ++i) {
                ret.add(Array.get(iVector, i));
            }
            return ret;
        }
        if (iVector instanceof List) {
            return (List)iVector;
        }
        return null;
    }

    public static Object vect2obj(List iList, Class iTarget) {
        if (iList == null) {
            return null;
        }
        if (iTarget.isArray()) {
            Object ret = Array.newInstance(iTarget.getComponentType(), iList.size());
            for (int i = 0; i < iList.size(); ++i) {
                Array.set(ret, i, iList.get(i));
            }
            return ret;
        }
        if (List.class.isAssignableFrom(iTarget)) {
            if (iTarget == iList.getClass() || iTarget == List.class) {
                return iList;
            }
            try {
                List ret = (List)iTarget.newInstance();
                ret.addAll(iList);
                return ret;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Object obj2Array(Object iVector) {
        if (iVector == null) {
            return null;
        }
        if (iVector.getClass().isArray()) {
            return iVector;
        }
        if (iVector instanceof List) {
            return ((List)iVector).toArray();
        }
        return null;
    }

    public static Object array2obj(Object iArray, Class iTarget) {
        if (iArray == null) {
            return null;
        }
        int l = Array.getLength(iArray);
        if (iTarget.isArray()) {
            if (iArray.getClass() == iTarget) {
                return iArray;
            }
            Object ret = Array.newInstance(iTarget.getComponentType(), l);
            System.arraycopy(iArray, 0, ret, 0, l);
            return ret;
        }
        if (List.class.isAssignableFrom(iTarget)) {
            try {
                List ret = (List)iTarget.newInstance();
                for (int i = 0; i < l; ++i) {
                    ret.add(Array.get(iArray, i));
                }
                return ret;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isString(Class iClass) {
        return iClass == String.class;
    }

    public static boolean isIntegerLike(Class iClass) {
        return iClass == Integer.TYPE || iClass == Integer.class || iClass == Short.TYPE || iClass == Short.class || iClass == Long.TYPE || iClass == Long.class;
    }

    public static boolean isBoolean(Class iClass) {
        return iClass == Boolean.TYPE || iClass == Boolean.class;
    }

    public static boolean isDate(Class iClass) {
        return iClass == Date.class || iClass == Calendar.class;
    }

    public static Object parse2Type(String iValue, Class target) {
        if (iValue == null) {
            return null;
        }
        if (target == Integer.TYPE || target == Integer.class) {
            return new Integer(iValue);
        }
        if (target == Short.TYPE || target == Short.class) {
            return new Short(iValue);
        }
        if (target == Long.TYPE || target == Long.class) {
            return new Long(iValue);
        }
        if (target == Boolean.TYPE || target == Boolean.class) {
            return "true".equalsIgnoreCase(iValue);
        }
        if (target == String.class) {
            return iValue;
        }
        return iValue;
    }

    public static Date obj2Date(Object iValue) {
        if (iValue == null) {
            return null;
        }
        if (iValue instanceof Date) {
            return (Date)iValue;
        }
        if (iValue instanceof Calendar) {
            return ((Calendar)iValue).getTime();
        }
        return null;
    }

    public static Object date2Obj(Date iDate, Class iTarget) {
        if (iDate == null) {
            return null;
        }
        if (iTarget == Date.class) {
            return iDate;
        }
        if (iTarget == Calendar.class) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(iDate);
            return cal;
        }
        return null;
    }
}

