/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.util;

import com.ebm_ws.infra.bricks.impl.UrlWatcher;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;

public class UrlBuilder {
    protected String _requestUri;
    protected Hashtable _params;

    public UrlBuilder(String iRequestURI) {
        this._requestUri = iRequestURI;
    }

    public String getRequestUri() {
        return this._requestUri;
    }

    public UrlBuilder setParameter(String iName, String iValue) {
        if (iName != null) {
            if (this._params == null) {
                this._params = new Hashtable();
            }
            if (iValue == null) {
                this._params.put(iName, "");
            } else {
                this._params.put(iName, iValue);
            }
        }
        return this;
    }

    public UrlBuilder removeParameter(String iName) {
        if (this._params != null) {
            this._params.remove(iName);
        }
        return this;
    }

    public Enumeration getParameterNames() {
        if (this._params == null) {
            return null;
        }
        return this._params.keys();
    }

    public String getParameterValue(String iName) {
        return (String)this._params.get(iName);
    }

    public String toUrl(String iCharSet, boolean iEncodeHtml) {
        StringBuffer sb = new StringBuffer(this.getRequestUri());
        if (this._params != null) {
            int i = 0;
            Enumeration keys = this._params.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                String value = (String)this._params.get(name);
                if (i == 0) {
                    sb.append('?');
                } else {
                    sb.append(iEncodeHtml ? "&amp;" : "&");
                }
                sb.append(name);
                sb.append('=');
                if (iCharSet != null) {
                    try {
                        value = URLEncoder.encode(value, iCharSet);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                sb.append(value);
                ++i;
            }
        }
        if (UrlWatcher.getInstalled() != null) {
            UrlWatcher.getInstalled().addUrl(sb.toString());
        }
        return sb.toString();
    }
}

