/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.bricks.validation;

import com.ebm_ws.infra.bricks.validation.IValidationMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationErrors
extends Exception {
    private static final long serialVersionUID = 1L;
    private static String GLOBAL_ID = "_";
    private HashMap<String, ArrayList<IValidationMessage>> name2Messages = null;

    public void addErrors(ValidationErrors iErrors) {
        if (this.name2Messages == null) {
            this.name2Messages = new HashMap();
        }
        for (String id : iErrors.name2Messages.keySet()) {
            ArrayList<IValidationMessage> messagesToAdd = iErrors.name2Messages.get(id);
            List<IValidationMessage> existingMessages = this.getItemErrors(id);
            if (existingMessages == null) {
                this.name2Messages.put(id, messagesToAdd);
                continue;
            }
            existingMessages.addAll(messagesToAdd);
        }
    }

    public void addGlobalError(IValidationMessage iError) {
        this.addItemError(GLOBAL_ID, iError);
    }

    public void addItemError(String id, IValidationMessage iError) {
        ArrayList<IValidationMessage> messages;
        if (this.name2Messages == null) {
            this.name2Messages = new HashMap();
        }
        if ((messages = this.name2Messages.get(id)) == null) {
            messages = new ArrayList(1);
            this.name2Messages.put(id, messages);
        }
        messages.add(iError);
    }

    public List<IValidationMessage> getGlobalErrors() {
        return this.getItemErrors(GLOBAL_ID);
    }

    public List<IValidationMessage> getItemErrors(String id) {
        if (this.name2Messages == null) {
            return null;
        }
        return this.name2Messages.get(id);
    }

    public boolean hasErrors() {
        if (this.name2Messages == null) {
            return false;
        }
        return this.name2Messages.size() > 0;
    }

    public boolean hasGlobalErrors() {
        return this.hasItemErrors(GLOBAL_ID);
    }

    public boolean hasItemErrors(String iID) {
        List<IValidationMessage> errors = this.getItemErrors(iID);
        return errors != null && errors.size() > 0;
    }
}

