/**
 * Initializes the autocomplete field
 */
function Autocomplete_init(formName, fieldName, getAutocompleteValuesFn)
{
	var form = document.forms[formName];
	if(!form)
		return;
	var textField = form.elements[fieldName];
	if(!textField)
		return;
	
	// --- deactivate web browser auto-completion
	// FF
	textField.setAttribute("autocomplete", "off");
	// IE
	textField.autocomplete = "off";
	
	// --- keep the function to get values
	textField.getAutocompleteValuesFn = getAutocompleteValuesFn;
	
	// --- register to onfocus, onblur, onchange
	if(textField.attachEvent)
	{
//		textField.attachEvent("onfocus", Autocomplete_onFocus);
		textField.attachEvent("onblur", Autocomplete_onBlur);
		textField.attachEvent("onkeydown", Autocomplete_onKeyDown);
		textField.attachEvent("onkeyup", Autocomplete_onKeyUp);
	}
	else
	{
//		textField.addEventListener("focus", Autocomplete_onFocus, false);
		textField.addEventListener("blur", Autocomplete_onBlur, false);
		textField.addEventListener("keydown", Autocomplete_onKeyDown, false);
		textField.addEventListener("keyup", Autocomplete_onKeyUp, false);
	}
}
// =============================================================================
// === Auto-completion Event Handlers
// =============================================================================
/**
 * Function that is triggered each time the text changes in a field
 * with auto-completion
 * This function retrieves all completed values, then possibly
 * displays a popup with all completed texts
 */
function Autocomplete_onKeyDown(evt)
{
	if(window.event) evt = event;
	var textField = window.event ? event.srcElement : evt.target;
	textField.valueBeforeKeyUp = textField.value;
	
	// --- 1: intercept ENTER, UP, DOWN and ESC keys
	switch(evt.keyCode)
	{
		// TODO: CTRL + SPACE --> invoke auto-complete ?
		case 13: // ENTER
		{
			if(Autocomplete_isPopupVisible(textField))
			{
				// --- set selected item
				textField.value = textField.autocompleteList.childNodes[textField.autocompleteList.selectedItem].autocompleteValue;
				Autocomplete_hidePopup(textField);
				// --- block event (to prevent submission)
				if(evt.preventDefault)
					evt.preventDefault();
				else
					evt.returnValue = false;
				return false;
			}
		}
		case 38: // UP
		{
			if(Autocomplete_isPopupVisible(textField))
			{
				// --- select previous item
				if(textField.autocompleteList.selectedItem > 0)
				{
					textField.autocompleteList.childNodes[textField.autocompleteList.selectedItem].className = null;
					textField.autocompleteList.selectedItem--;
					textField.autocompleteList.childNodes[textField.autocompleteList.selectedItem].className = "Selected";
				}
				return;
			}
		}
		case 40: // DOWN
		{
			if(Autocomplete_isPopupVisible(textField))
			{
				// --- select next item
				if(textField.autocompleteList.selectedItem < textField.autocompleteList.childNodes.length-1)
				{
					textField.autocompleteList.childNodes[textField.autocompleteList.selectedItem].className = null;
					textField.autocompleteList.selectedItem++;
					textField.autocompleteList.childNodes[textField.autocompleteList.selectedItem].className = "Selected";
				}
				return;
			}
		}
		case 27: // ESCAPE
		{
			if(Autocomplete_isPopupVisible(textField))
			{
				// --- close popup
				Autocomplete_hidePopup(textField);
				// --- block event (to prevent textfield from being reset (IE))
				if(evt.preventDefault)
					evt.preventDefault();
				else
					evt.returnValue = false;
				return;
			}
		}
		case 32: // SPACE
		{
			if(evt.ctrlKey && !Autocomplete_isPopupVisible(textField))
			{
				// --- show popup
				Autocomplete_invoke(textField);
				// --- block event (to prevent space from being added to value)
				if(evt.preventDefault)
					evt.preventDefault();
				else
					evt.returnValue = false;
				return;
			}
		}
	}
}
/**
 * At keyup event, the textfield value has changed:
 * time to invoke the autocompletion if value has changed
 */
function Autocomplete_onKeyUp(evt)
{
	if(window.event) evt = event;
	var textField = window.event ? event.srcElement : evt.target;
	
	if(evt.keyCode == 13) // ENTER
		return;
	
	if(textField.value != textField.valueBeforeKeyUp)
	{
		// --- text has changed: invoke
		Autocomplete_invoke(textField);
	}
}
/**
 * onblur event handler
 */
function Autocomplete_onBlur(evt)
{
	var textField = window.event ? event.srcElement : evt.target;
	// --- set timeout to accept item selection
	setTimeout(function(){
		Autocomplete_hidePopup(textField);
	}, 300);
}
function Autocomplete_onClickItem(evt)
{
	if(window.event) evt = event;
	var item = window.event ? event.srcElement : evt.target;
	item.autocompleteField.value = item.autocompleteValue;
	Autocomplete_hidePopup(item.autocompleteField);
	item.autocompleteField.focus();;
}

// =============================================================================
// === Autocompletion Control Functions
// =============================================================================
/**
 * Invokes the autocompletion component with the current field value
 */
function Autocomplete_invoke(textField)
{
//alert("invoke: "+textField.value);
	var completedValues = textField.getAutocompleteValuesFn.call(window, textField);
	if(completedValues == null || completedValues.length == 0)
		Autocomplete_hidePopup(textField);
	else
		Autocomplete_showPopup(textField, completedValues);
}
/**
 * Hides the autocompletion popup for the given textfield
 */
function Autocomplete_hidePopup(textField)
{
	if(textField.autocompleteList != null)
	{
		textField.autocompleteList.parentNode.style.display = "none";
		/*
		while(textField.autocompleteList.firstChild != null)
			textField.autocompleteList.removeChild(textField.autocompleteList.firstChild);
		*/
	}
}
function Autocomplete_createPopup(textField)
{
	// --- get or create popup
	if(textField.autocompleteList == null)
	{
		// --- create new popup
		var popupDiv = document.createElement("DIV");
		popupDiv.className = "Autocomplete Popup";
		popupDiv.style.display = "none";
		var pos = getAbsPos(textField);
//alert("abs position: "+pos.left+", "+pos.top);
		popupDiv.style.top = (pos.top+textField.offsetHeight)+"px";
		popupDiv.style.left = pos.left+"px";
		if(document.all) // IE
			popupDiv.style.width = textField.offsetWidth+"px";
		else // FF
			popupDiv.style.minWidth = textField.offsetWidth+"px";
		
		// --- create the auto-complete list (UL)
		textField.autocompleteList = document.createElement("UL");
		popupDiv.appendChild(textField.autocompleteList);
		
		/*
		// --- min width: given by a child DIV
		var minWidthDiv = document.createElement("DIV");
//		minWidthDiv.style.visibility = "hidden";
minWidthDiv.style.backgroundColor = "pink";
		minWidthDiv.style.display = "block";
		minWidthDiv.style.overflow = "hidden";
		minWidthDiv.style.height = "1px";
		minWidthDiv.style.width = textField.offsetWidth+"px";
		popupDiv.appendChild(minWidthDiv);
		*/
		
// no: layout problems		textField.offsetParent.appendChild(popupDiv);
		document.body.appendChild(popupDiv);
	}
}
/**
 * Displays the auto-completion popup with a loading animation
 */
function Autocomplete_showLoading(textField)
{
	// --- get or create popup
	if(textField.autocompleteList == null)
	{
		// --- create new popup
		Autocomplete_createPopup(textField);
	}
	else
	{
		// --- hide and remove all items from popup
		textField.autocompleteList.parentNode.style.display = "none";
		while(textField.autocompleteList.firstChild != null)
			textField.autocompleteList.removeChild(textField.autocompleteList.firstChild);
	}
	
	// --- create loading item
	var item = document.createElement("LI");
	item.className = "Loading";
	textField.autocompleteList.appendChild(item);

	textField.autocompleteList.selectedItem = -1;
	
	// --- show popup
	textField.autocompleteList.parentNode.style.display = "block";
}
/**
 * Creates and shows the autocompletion popup for the given textfield
 */
function Autocomplete_showPopup(textField, values)
{
	// --- get or create popup
	if(textField.autocompleteList == null)
	{
		// --- create new popup
		Autocomplete_createPopup(textField);
	}
	else
	{
		// --- hide and remove all items from popup
		textField.autocompleteList.parentNode.style.display = "none";
		while(textField.autocompleteList.firstChild != null)
			textField.autocompleteList.removeChild(textField.autocompleteList.firstChild);
	}
	
	// --- create items
	for(var i=0; i<values.length; i++)
	{
		var item = document.createElement("LI");
		if(item.attachEvent)
			item.attachEvent("onclick", Autocomplete_onClickItem);
		else
			item.addEventListener("click", Autocomplete_onClickItem, false);
		item.autocompleteField = textField;
		item.autocompleteValue = values[i];
		item.appendChild(document.createTextNode(values[i]));
		textField.autocompleteList.appendChild(item);
	}
	// --- select first item
	textField.autocompleteList.selectedItem = 0;
	textField.autocompleteList.childNodes[textField.autocompleteList.selectedItem].className = "Selected";
	
	// --- show popup
	textField.autocompleteList.parentNode.style.display = "block";
}
function Autocomplete_isPopupVisible(textField)
{
	return textField.autocompleteList && textField.autocompleteList.selectedItem >= 0 && textField.autocompleteList.parentNode.style.display == "block";
}
/**
 * Function for DynAutocomplete
 * Retrieves list of proposed values dynamically (Ajax)
 */
function Autocomplete_getDynValues(textField, servletUrl)
{
	var curValue = textField.value;
	// --- 1: show loading popup (after 1 sec)
	var showLoadingTimeout = setTimeout(function(){
		Autocomplete_showLoading(textField);
		showLoadingTimeout = undefined;
	}, 1000);
	
	// --- 2: make request
	var req = newXHR();
	var reqUrl = servletUrl+"?value="+escape(curValue);
	req.open("GET", reqUrl , true);//asynchronous
	req.onreadystatechange = function()
	{
		if(req.readyState == 4)
		{
			if(req.status == 200 || req.status == 0)
			{
				if(showLoadingTimeout != undefined)
					clearTimeout(showLoadingTimeout);
				if(textField.value != curValue)
				{
					// --- value has changed: ignore
					// TODO: call xhr.abort() to cancel a request while the value has changed
					return;
				}
				try {
					// --- retrieve completed values
					var completedValues = eval(req.responseText);
					// --- then update autocomplete popup
					if(completedValues == null || completedValues.length == 0)
						Autocomplete_hidePopup(textField);
					else
						Autocomplete_showPopup(textField, completedValues);
				} catch (e) {
					alert("Error while parsing JSON response: "+e);
				}
			}
			else
			{
				alert("HTTP error ("+reqUrl+"): "+req.status);
			}
		}
	}
	req.send(null);
}
