// =======================================================================
// === Common Functions
// === Written by Pierre SMEYERS
// =======================================================================
// === This Javascript Library contains general functions for the online
// === doc runtime infrastructure.
// =======================================================================

// =========================================
// === String methods
// =========================================
String.prototype.endsWith = function(s)
{
	if (typeof s != 'string')
		throw('IllegalArgumentException: String.endsWith() is expecting a string argument.');
	var start = this.length - s.length;
	if(start < 0) return false;
	return this.substr(start) == s;
}
String.prototype.startsWith = function(s)
{
	if (typeof s != 'string')
		throw('IllegalArgumentException: String.startsWith() is expecting a string argument.');
	if(this.length < s.length)
		return false;
	return this.substr(0, s.length) == s;
}
String.prototype.trim = function()
{
    return this.replace(/(?:^\s+|\s+$)/g, "");
}
// =========================================
// === Array methods
// =========================================
Array.prototype.indexOf = function(o, fromIndex)
{
	if(!fromIndex)
		fromIndex = 0;
	for(var i=fromIndex; i<this.length; i++)
	{
		if(this[i] == o)
			return i;
	}
	return -1;
}
Array.prototype.lastIndexOf = function(o, fromIndex)
{
	if(!fromIndex)
		fromIndex = this.length-1;
	for(var i=fromIndex; i>=0; i--)
	{
		if(this[i] == o)
			return i;
	}
	return -1;
}
Array.prototype.contains = function(o)
{
	return this.indexOf(o) >= 0;
}
// =========================================
// === Url Analysis Functions
// =========================================
/**
 * Extracts arguments from the given location object.
 * Arguments are passed in a URL with the grammar:
 * http://server/the/path/to/the/file?arg1=val1&arg2=val2&...
 */
function getUrlParameter(name)
{
	var loc = window.location;
	if(!loc.parameters)
	{
		// --- parse parameters
		loc.parameters = new Object();
		var varAndVals = loc.search.substr(1).split("&");
		for(var i=0; i<varAndVals.length; i++)
		{
			var v = varAndVals[i].split("=");
			loc.parameters[unescape(v[0])] = unescape(v[1]);
		}
	}
	return loc.parameters[name];
}
// =========================================
// === DOM Navigation Helpers
// =========================================
/**
 * Returns the first father node with given tag name.
 * This function pops the DOM hirearchy and returns the parent node with the given tag name.
 */
function getFatherNode(nodeType, node)
{
	var obj = node;
	while(obj != null && (obj.nodeName == null || obj.nodeName != nodeType))
			obj = obj.parentNode;
	return obj;
}
/**
 * Returns the first father node with the given tag name and a non-null ID.
 */
function getFatherNodeWithId(nodeType, node)
{
	var obj = node;
	while(obj != null)
	{
		if(obj.nodeName && obj.nodeName == nodeType && obj.id != null && obj.id != "")
			return obj;
		obj = obj.parentNode;
	}
	return obj;
}
function getDOMObjDesc(obj)
{
	var ret = "<"+obj.nodeName;
	if(obj.id)
		ret += " id='"+obj.id+"'";
	if(obj.className)
		ret += " class='"+obj.className+"'";
	ret += " ...>";
	return ret;
}
/**
 * Returns the postion of obj relatively to the given parent (optional).
 */
function getAbsPos(obj, relativeToAncestor)
{
	var pos = {top: 0, left: 0};
	if(relativeToAncestor == null)
		relativeToAncestor = obj.ownerDocument.body;
//var message = "";
	while(true)
	{
//message += "Position of "+getDOMObjDesc(obj)+": "+obj.offsetTop+","+obj.offsetLeft;
		// --- add offset position relative to the offset parent
		pos.top += obj.offsetTop;
		pos.left += obj.offsetLeft;
		// --- pop to the offset parent, and break if it's the relative object
		obj = obj.offsetParent;
		if(obj == null || obj == relativeToAncestor) break;
//message += " relative to "+getDOMObjDesc(obj)+" (client pos: "+obj.clientTop+","+obj.clientLeft+") (scroll pos: "+obj.scrollTop+","+obj.scrollLeft+")\n";
		// --- compensate offset parent borders
		pos.top += obj.clientTop;
		pos.left += obj.clientLeft;
		// --- compensate offset parent scroll position
		pos.top -= obj.scrollTop;
		pos.left -= obj.scrollLeft;
	}
//alert(message);
	return pos;
}
// =========================================
// === XHR Helpers
// =========================================
/**
 * This function loads the given xml file and returns its root node.
 */
/*
function loadXML(xmlUrl)
{
	if(document.all)
	{
		// --- Internet Explorer
//		var xmlNode = new ActiveXObject("Microsoft.XMLDOM");
		var xmlNode = new ActiveXObject("Msxml2.DOMDocument");
		xmlNode.async = false;
		xmlNode.load(xmlUrl);
		return xmlNode;
	}
	else
	{
		// --- Mozilla
		var req = new XMLHttpRequest();
		req.overrideMimeType("text/xml");
		req.open("GET", xmlUrl, false);
		req.send(null);
		return req.responseXML;
	}
}
*/
/**
 * Instantiates a new XmlHttpRequest object (whatever the platform)
 */
function newXHR()
{
	if (window.XMLHttpRequest)
	{
		// --- Mozilla based browsers
		return new XMLHttpRequest();
	}
	else if (window.ActiveXObject)
	{
		// --- Internet Explorer (2 possible XML engines)
		try {
			return new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e) {}
		try {
			return new ActiveXObject("Microsoft.XMLHTTP");
		} catch (e) {}
	}
	// --- browser does not support XML Http Request
	return null;
}
