// ===================================================================
// === Bricks4WebApps JavaScript Library
// ===================================================================
// === This library is used by the Menu component
// ===================================================================

var LEAVE_MENU_TIMEOUT = null;
function Menu_getParentSubMenu(elt)
{
	while(elt)
	{
		if(elt.nodeName == "LI" && elt.className.indexOf("submenu") >= 0)
			return elt;
		elt = elt.parentNode;
	}
}
function Menu_focus(elt)
{
	var li = Menu_getParentSubMenu(elt);
	if(li.className.indexOf(" focus") < 0)
		li.className += " focus";
	
	if(LEAVE_MENU_TIMEOUT)
	{
		clearTimeout(LEAVE_MENU_TIMEOUT);
		LEAVE_MENU_TIMEOUT = null;
	}
}
function Menu_blur(elt)
{
	if(LEAVE_MENU_TIMEOUT)
	{
		clearTimeout(LEAVE_MENU_TIMEOUT);
		LEAVE_MENU_TIMEOUT = null;
	}
	LEAVE_MENU_TIMEOUT = setTimeout(function(){
		var li = Menu_getParentSubMenu(elt);
		li.className = "submenu";
	}, 50);
}