/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.xmlmapping;

import com.ebm_ws.infra.xmlmapping.interfaces.IEnumeration;
import com.ebm_ws.infra.xmlmapping.schema.ISchema;
import com.ebm_ws.infra.xmlmapping.schema.ISchemaElement;
import com.ebm_ws.infra.xmlmapping.schema.SchemasManager;
import com.ebm_ws.infra.xmlmapping.utils.EnumHelper;
import com.ebm_ws.infra.xmlmapping.utils.MappedField;
import com.ebm_ws.infra.xmlmapping.utils.MessagesHelper;
import com.ebm_ws.infra.xmlmapping.utils.XmlMappings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class DocGenerator {
    private static boolean SHOW_INHERITANCE_IN_FIELDS = false;
    private static String[] STRING_ARRAY = new String[0];
    private static ISchemaElement[] ELT_ARRAY_TYPE = new ISchemaElement[0];
    private SchemasManager _schemas;
    private ISchema _mainSchema;
    private File _docRootDir;
    private Locale _locale = Locale.US;
    private String generatedComment;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: DocGenerator [dest_doc_dir] [java_package] ( [import_package] )*");
            return;
        }
        File outDir = new File(args[0]);
        String javaPackage = args[1];
        try {
            System.out.println("Generate Documentation from code");
            System.out.println("--------------------------------");
            System.out.println("  - output directory : " + outDir);
            System.out.println("  - root code package: " + javaPackage);
            SchemasManager schemas = new SchemasManager();
            ISchema mainSchema = schemas.declareSchema(javaPackage, javaPackage, javaPackage);
            for (int i = 1; i < args.length; ++i) {
                String importPack = args[i];
                schemas.declareSchema(importPack, importPack, importPack);
            }
            System.out.println("");
            mainSchema.buildFromClassPath();
            DocGenerator generator = new DocGenerator(schemas);
            generator.buildDoc(mainSchema, outDir.getAbsoluteFile());
            System.out.println("... Done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DocGenerator(SchemasManager iSchemas) {
        this._schemas = iSchemas;
    }

    public void buildDoc(ISchema iSchema, File iDocRootDir) throws FileNotFoundException {
        int i;
        this._mainSchema = iSchema;
        this._docRootDir = iDocRootDir;
        Date now = new Date();
        this.generatedComment = "Generated by XMLMap DocGenerator on " + now;
        ISchemaElement[] elts = this._mainSchema.getAllElements();
        ArrayList<String> tmp = new ArrayList<String>();
        for (int i2 = 0; i2 < elts.length; ++i2) {
            String pack = elts[i2].getTagName();
            int idx = pack.lastIndexOf(46);
            pack = idx > 0 ? pack.substring(0, idx) : "";
            if (tmp.contains(pack)) continue;
            tmp.add(pack);
        }
        Object[] packages = tmp.toArray(STRING_ARRAY);
        Arrays.sort(packages);
        this.writeIndex();
        this.writePackagesList((String[])packages);
        this.writeClassesList(null);
        for (i = 0; i < packages.length; ++i) {
            this.writeClassesList((String)packages[i]);
        }
        for (i = 0; i < elts.length; ++i) {
            this.writeElement(elts[i]);
        }
    }

    private static boolean recurDeleteDir(File iDir) {
        if (!iDir.exists()) {
            return true;
        }
        File[] files = iDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                DocGenerator.recurDeleteDir(files[i]);
                continue;
            }
            files[i].delete();
        }
        iDir.delete();
        return true;
    }

    private void writeIndex() throws FileNotFoundException {
        File f = new File(this._docRootDir, "index.html");
        f.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(f);
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">");
        writer.println("<HTML>");
        writer.println("<HEAD>");
        writer.println("<!-- " + this.generatedComment + "  -->");
        writer.println("<TITLE>");
        writer.println("XML Components from " + this._mainSchema.getName());
        writer.println("</TITLE>");
        writer.println("</HEAD>");
        writer.println("<FRAMESET cols=\"20%,80%\">");
        writer.println("\t<FRAMESET rows=\"30%,70%\">");
        writer.println("\t\t<FRAME src=\"overview-frame.html\" name=\"packageListFrame\" title=\"All Packages\">");
        writer.println("\t\t<FRAME src=\"allclasses-frame.html\" name=\"packageFrame\" title=\"All elements and substitution groups\">");
        writer.println("\t</FRAMESET>");
        writer.println("\t<FRAME src=\"overview-summary.html\" name=\"classFrame\" title=\"Package, element and substitution group descriptions\">");
        writer.println("</FRAMESET>");
        writer.println("</HTML>");
        writer.close();
    }

    private void writePackagesList(String[] packages) throws FileNotFoundException {
        File f = new File(this._docRootDir, "overview-frame.html");
        f.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(f);
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.println("<HTML>");
        writer.println("<HEAD>");
        writer.println("<!-- " + this.generatedComment + " -->");
        writer.println("<TITLE>");
        writer.println("Packages List");
        writer.println("</TITLE>");
        writer.println("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"stylesheet.css\" TITLE=\"Style\">");
        writer.println("<base target=\"packageFrame\">");
        writer.println("</HEAD>");
        writer.println("<BODY BGCOLOR=\"white\">");
        writer.println("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
        writer.println("<TR>");
        writer.println("<TD NOWRAP><FONT CLASS=\"FrameItemFont\"><A HREF=\"allclasses-frame.html\">All Classes</A></FONT>");
        writer.println("<P>");
        writer.println("<FONT size=\"+1\" CLASS=\"FrameHeadingFont\">Packages</FONT>");
        writer.println("<BR>");
        for (int i = 0; i < packages.length; ++i) {
            String packageName = packages[i];
            String packageDir = null;
            if (packageName.length() == 0) {
                packageName = "(root)";
                packageDir = ".";
            } else {
                packageDir = packages[i].replace('.', '/');
            }
            writer.println("<FONT CLASS=\"FrameItemFont\"><A HREF=\"" + packageDir + "/package-frame.html\">" + packageName + "</A></FONT>");
            writer.println("<BR>");
        }
        writer.println("</TD>");
        writer.println("</TR>");
        writer.println("</TABLE>");
        writer.println("</BODY>");
        writer.println("</HTML>");
        writer.close();
    }

    private String toRoot(File file, File dir) {
        File d;
        String toRoot = ".";
        for (d = file.getParentFile(); d != null && !d.equals(dir); d = d.getParentFile()) {
            toRoot = toRoot + "/..";
        }
        if (d == null) {
            System.out.println("error: toRoot(" + file + ", " + dir + ")... null");
        }
        return toRoot;
    }

    private void writeClassesList(String pack) throws FileNotFoundException {
        String toRoot = ".";
        String title = "All Elements";
        File f = null;
        if (pack == null) {
            f = new File(this._docRootDir, "allclasses-frame.html");
        } else if (pack.length() == 0) {
            title = "Elements from root package";
            f = new File(this._docRootDir.getAbsolutePath() + "/package-frame.html");
        } else {
            title = "Elements from package '" + pack + "'";
            f = new File(this._docRootDir.getAbsolutePath() + "/" + pack.replace('.', '/') + "/package-frame.html");
            toRoot = this.toRoot(f, this._docRootDir);
        }
        f.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(f);
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.println("<HTML>");
        writer.println("<HEAD>");
        writer.println("<!-- " + this.generatedComment + "  -->");
        writer.println("<TITLE>");
        writer.println(title);
        writer.println("</TITLE>");
        writer.println("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"" + toRoot + "/stylesheet.css\" TITLE=\"Style\">");
        writer.println("<base target=\"classFrame\">");
        writer.println("</HEAD>");
        writer.println("<BODY BGCOLOR=\"white\">");
        writer.println("<FONT size=\"+1\" CLASS=\"FrameHeadingFont\">");
        writer.println("<B>" + title + "</B></FONT>");
        writer.println("<BR>");
        writer.println("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
        writer.println("<TR>");
        writer.println("<TD NOWRAP><FONT CLASS=\"FrameItemFont\">");
        ISchemaElement[] elts = this._mainSchema.getAllElements();
        if (pack != null) {
            ArrayList<ISchemaElement> eltsFromPackage = new ArrayList<ISchemaElement>();
            for (int i = 0; i < elts.length; ++i) {
                String eltPack = elts[i].getTagName();
                int idx = eltPack.lastIndexOf(46);
                eltPack = idx > 0 ? eltPack.substring(0, idx) : "";
                if (!eltPack.equals(pack)) continue;
                eltsFromPackage.add(elts[i]);
            }
            elts = eltsFromPackage.toArray(ELT_ARRAY_TYPE);
        }
        Arrays.sort(elts, new Comparator(){

            public int compare(Object o1, Object o2) {
                ISchemaElement e1 = (ISchemaElement)o1;
                ISchemaElement e2 = (ISchemaElement)o2;
                return e1.getTagName().compareTo(e2.getTagName());
            }
        });
        for (int i = 0; i < elts.length; ++i) {
            String link = this.getElementLink(elts[i]);
            if (elts[i].getMappedClass().isInterface()) {
                writer.println("<I>");
            }
            writer.println("<A HREF=\"" + toRoot + "/" + link + "\">" + elts[i].getTagName() + "</A>");
            if (elts[i].getMappedClass().isInterface()) {
                writer.println("</I>");
            }
            writer.println("<BR>");
        }
        writer.println("</TD>");
        writer.println("</TR>");
        writer.println("</TABLE>");
        writer.println("</BODY>");
        writer.println("</HTML>");
        writer.close();
    }

    private String getElementLink(ISchemaElement iElt) {
        if (iElt.getSchema() != this._mainSchema) {
            return null;
        }
        return iElt.getTagName().replace('.', '/') + ".html";
    }

    private void writeElement(ISchemaElement iElt) throws FileNotFoundException {
        ISchemaElement fieldTypeElt;
        String fieldDetails;
        String link;
        MappedField field;
        MappedField[] mappedFields;
        ISchemaElement[] substitutionGroups;
        int i;
        ISchemaElement ancestor;
        boolean isAbstract = (iElt.getMappedClass().getModifiers() & 0x400) != 0;
        int idx = iElt.getTagName().lastIndexOf(46);
        String simpleEltName = iElt.getTagName();
        String packageName = "(root)";
        if (idx > 0) {
            packageName = iElt.getTagName().substring(0, idx);
            simpleEltName = iElt.getTagName().substring(idx + 1);
        }
        String title = null;
        title = iElt.getType() == 4 ? (isAbstract ? "abstract Element " + iElt.getTagName() : "Element " + iElt.getTagName()) : (iElt.getType() == 1 ? "Enumeration " + iElt.getTagName() : "Substitution Group " + iElt.getTagName());
        ArrayList<ISchemaElement> ancestors = new ArrayList<ISchemaElement>();
        for (ancestor = iElt.getSuperType(); ancestor != null; ancestor = ancestor.getSuperType()) {
            ancestors.add(0, ancestor);
        }
        ancestors.add(iElt);
        ArrayList fieldAncestors = new ArrayList();
        ArrayList<XmlMappings> mappings = new ArrayList<XmlMappings>();
        if (SHOW_INHERITANCE_IN_FIELDS) {
            for (int i2 = 0; i2 < ancestors.size(); ++i2) {
                fieldAncestors.add(ancestors.get(i2));
                mappings.add(XmlMappings.getMappings(((ISchemaElement)fieldAncestors.get(i2)).getMappedClass(), false));
            }
        } else {
            fieldAncestors.add(iElt);
            mappings.add(XmlMappings.getMappings(iElt.getMappedClass(), true));
        }
        File f = new File(this._docRootDir.getAbsolutePath() + "/" + iElt.getTagName().replace('.', '/') + ".html");
        f.getParentFile().mkdirs();
        String toRoot = this.toRoot(f, this._docRootDir);
        PrintWriter writer = new PrintWriter(f);
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.println("<HTML>");
        writer.println("<HEAD>");
        writer.println("<!-- " + this.generatedComment + "  -->");
        writer.println("<TITLE>");
        writer.println(title);
        writer.println("</TITLE>");
        writer.println("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"" + toRoot + "/stylesheet.css\" TITLE=\"Style\">");
        writer.println("<base target=\"classFrame\">");
        writer.println("</HEAD>");
        writer.println("<SCRIPT type=\"text/javascript\">");
        writer.println("function windowTitle()");
        writer.println("{");
        writer.println("\tparent.document.title=\"" + title + "\";");
        writer.println("}");
        writer.println("</SCRIPT>");
        writer.println("<BODY onload=\"windowTitle()\" BGCOLOR=\"white\">");
        writer.println("<H2>");
        writer.println(title);
        writer.println("</H2>");
        if (ancestors.size() > 1) {
            writer.println("<PRE>");
            for (int i3 = 0; i3 < ancestors.size(); ++i3) {
                String link2;
                if (i3 > 0) {
                    int j;
                    for (j = 0; j < i3; ++j) {
                        writer.print("  ");
                    }
                    writer.println("|");
                    for (j = 0; j < i3; ++j) {
                        writer.print("  ");
                    }
                    writer.print("+-- ");
                }
                ancestor = (ISchemaElement)ancestors.get(i3);
                String string = link2 = i3 == ancestors.size() - 1 ? null : this.getElementLink(ancestor);
                if (link2 != null) {
                    writer.print("<A HREF=\"" + toRoot + "/" + link2 + "\">");
                }
                writer.print(ancestor.getTagName());
                if (link2 != null) {
                    writer.print("</A>");
                }
                writer.println();
            }
            writer.println("</PRE>");
        }
        if (iElt.getType() == 2 || isAbstract) {
            writer.println("<DL>");
            writer.println("<DT><B>Known Implementing Elements:</B></DT>");
            writer.println("<DD>");
            ISchemaElement[] allElements = this._mainSchema.getAllElements();
            int nbImpl = 0;
            for (i = 0; i < allElements.length; ++i) {
                String link3;
                if (iElt.getMappedClass() == allElements[i].getMappedClass() || !iElt.getMappedClass().isAssignableFrom(allElements[i].getMappedClass())) continue;
                if (nbImpl > 0) {
                    writer.print(", ");
                }
                if ((link3 = this.getElementLink(allElements[i])) != null) {
                    writer.print("<A HREF=\"" + toRoot + "/" + link3 + "\">");
                }
                writer.print(allElements[i].getTagName());
                if (link3 != null) {
                    writer.print("</A>");
                }
                ++nbImpl;
            }
            if (nbImpl == 0) {
                writer.print("None.");
            }
            writer.println("</DD>");
            writer.println("</DL>");
        }
        if ((substitutionGroups = iElt.getSubstitutionGroups()) != null && substitutionGroups.length > 0) {
            writer.println("<DL>");
            writer.println("<DT><B>Substitution Groups:</B></DT>");
            writer.println("<DD>");
            for (int i4 = 0; i4 < substitutionGroups.length; ++i4) {
                String link4;
                if (i4 > 0) {
                    writer.print(", ");
                }
                if ((link4 = this.getElementLink(substitutionGroups[i4])) != null) {
                    writer.print("<A HREF=\"" + toRoot + "/" + link4 + "\">");
                }
                writer.print(substitutionGroups[i4].getTagName());
                if (link4 == null) continue;
                writer.print("</A>");
            }
            writer.println("</DD>");
            writer.println("</DL>");
        }
        writer.println("<HR>");
        String compDetails = MessagesHelper.getComponentDetails(this._locale, iElt.getMappedClass());
        if (compDetails == null) {
            compDetails = MessagesHelper.getComponentName(this._locale, iElt.getMappedClass());
        }
        writer.println("<P>");
        writer.println(compDetails);
        writer.println("<P>");
        writer.println("<HR>");
        if (iElt.getType() == 1) {
            writer.println("<P>");
            writer.println("<A NAME=\"ENUM_ITEMS\"/>");
            writer.println("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\">");
            writer.println("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">");
            writer.println("<TD COLSPAN=2><FONT SIZE=\"+2\">");
            writer.println("<B>Enumeration Items</B></FONT></TD>");
            writer.println("</TR>");
            int nbItems = EnumHelper.getNbOfItems(iElt.getMappedClass());
            for (int i5 = 0; i5 < nbItems; ++i5) {
                String itemName = EnumHelper.getItemName(iElt.getMappedClass(), i5);
                String itemDetails = MessagesHelper.getAttributeDetails(this._locale, iElt.getMappedClass(), itemName);
                if (itemDetails == null) {
                    itemDetails = MessagesHelper.getAttributeName(this._locale, iElt.getMappedClass(), itemName);
                }
                writer.println("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">");
                writer.println("<TD nowrap><CODE><B>" + itemName + "</B></CODE></TD>");
                writer.println("<TD width=\"100%\">" + itemDetails + "</TD>");
                writer.println("</TR>");
            }
            writer.println("</TABLE>");
        } else {
            String attrDetails;
            int j;
            ISchemaElement elt;
            writer.println("<P>");
            writer.println("<!-- ======== CONTENT ======== -->");
            writer.println("<A NAME=\"CONTENT\"/>");
            for (i = 0; i < fieldAncestors.size(); ++i) {
                elt = (ISchemaElement)fieldAncestors.get(fieldAncestors.size() - i - 1);
                mappedFields = ((XmlMappings)mappings.get(i)).getMappings(8);
                if (mappedFields == null || mappedFields.length <= 0) continue;
                writer.println("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\">");
                writer.println("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">");
                writer.println("<TD COLSPAN=1><FONT SIZE=\"+2\"><B>");
                if (i == 0) {
                    writer.println("Element Textual Content");
                } else {
                    writer.println("Element Textual Content Inherited from ");
                    String link5 = this.getElementLink(elt);
                    if (link5 != null) {
                        writer.print("<A HREF=\"" + toRoot + "/" + link5 + "\">");
                    }
                    writer.print(elt.getTagName());
                    if (link5 != null) {
                        writer.print("</A>");
                    }
                }
                writer.println("</B></FONT></TD>");
                writer.println("</TR>");
                for (j = 0; j < mappedFields.length; ++j) {
                    field = mappedFields[j];
                    attrDetails = MessagesHelper.getAttributeDetails(this._locale, iElt.getMappedClass(), field.getName());
                    if (attrDetails == null) {
                        attrDetails = MessagesHelper.getAttributeName(this._locale, iElt.getMappedClass(), field.getName());
                    }
                    writer.println("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">");
                    writer.println("<TD width=\"100%\">" + attrDetails + "</TD>");
                    writer.println("</TR>");
                }
                writer.println("</TABLE>");
                writer.println("<P>");
            }
            writer.println("<P>");
            writer.println("<!-- ======== ATTRIBUTES ======== -->");
            writer.println("<A NAME=\"ATTRIBUTES\"/>");
            for (i = 0; i < fieldAncestors.size(); ++i) {
                elt = (ISchemaElement)fieldAncestors.get(fieldAncestors.size() - i - 1);
                mappedFields = ((XmlMappings)mappings.get(i)).getMappings(1);
                if (mappedFields == null || mappedFields.length <= 0) continue;
                writer.println("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\">");
                writer.println("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">");
                writer.println("<TD COLSPAN=3><FONT SIZE=\"+2\"><B>");
                if (i == 0) {
                    writer.println("Attributes");
                } else {
                    writer.println("Attributes Inherited from ");
                    String link6 = this.getElementLink(elt);
                    if (link6 != null) {
                        writer.print("<A HREF=\"" + toRoot + "/" + link6 + "\">");
                    }
                    writer.print(elt.getTagName());
                    if (link6 != null) {
                        writer.print("</A>");
                    }
                }
                writer.println("</B></FONT></TD>");
                writer.println("</TR>");
                for (j = 0; j < mappedFields.length; ++j) {
                    field = mappedFields[j];
                    attrDetails = MessagesHelper.getAttributeDetails(this._locale, iElt.getMappedClass(), field.getName());
                    if (attrDetails == null) {
                        attrDetails = MessagesHelper.getAttributeName(this._locale, iElt.getMappedClass(), field.getName());
                    }
                    writer.println("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">");
                    writer.println("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">");
                    writer.println("<CODE>");
                    if (field.isUseRequired()) {
                        writer.println("mandatory");
                    } else {
                        writer.println("optional");
                    }
                    writer.println("&nbsp;");
                    if (IEnumeration.class.isAssignableFrom(field.getBaseClass())) {
                        ISchemaElement enumElt = this._schemas.getElement(field.getBaseClass());
                        if (enumElt != null) {
                            link = this.getElementLink(enumElt);
                            if (link != null) {
                                writer.print("<A HREF=\"" + toRoot + "/" + link + "\">");
                            }
                            writer.print(enumElt.getTagName());
                            if (link != null) {
                                writer.print("</A>");
                            }
                        } else {
                            writer.println(field.getBaseClass().getSimpleName());
                        }
                    } else {
                        writer.println(field.getBaseClass().getSimpleName());
                    }
                    writer.println("</CODE></FONT></TD>");
                    writer.println("<TD nowrap><CODE><B>" + field.getName() + "</B></CODE></TD>");
                    writer.println("<TD width=\"100%\">" + attrDetails + "</TD>");
                    writer.println("</TR>");
                }
                writer.println("</TABLE>");
                writer.println("<P>");
            }
            writer.println("<P>");
            writer.println("<!-- ======== CHILDREN ======== -->");
            writer.println("<A NAME=\"CHILDREN\"/>");
            for (i = 0; i < fieldAncestors.size(); ++i) {
                elt = (ISchemaElement)fieldAncestors.get(fieldAncestors.size() - i - 1);
                mappedFields = ((XmlMappings)mappings.get(i)).getMappings(2);
                if (mappedFields == null || mappedFields.length <= 0) continue;
                writer.println("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\">");
                writer.println("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">");
                writer.println("<TD COLSPAN=3><FONT SIZE=\"+2\"><B>");
                if (i == 0) {
                    writer.println("Named Children Elements");
                } else {
                    writer.println("Named Children Elements Inherited from ");
                    String link7 = this.getElementLink(elt);
                    if (link7 != null) {
                        writer.print("<A HREF=\"" + toRoot + "/" + link7 + "\">");
                    }
                    writer.print(elt.getTagName());
                    if (link7 != null) {
                        writer.print("</A>");
                    }
                }
                writer.println("</B></FONT></TD>");
                writer.println("</TR>");
                for (j = 0; j < mappedFields.length; ++j) {
                    field = mappedFields[j];
                    fieldDetails = MessagesHelper.getAttributeDetails(this._locale, iElt.getMappedClass(), field.getName());
                    if (fieldDetails == null) {
                        fieldDetails = MessagesHelper.getAttributeName(this._locale, iElt.getMappedClass(), field.getName());
                    }
                    writer.println("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">");
                    writer.println("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">");
                    writer.println("<CODE>");
                    if (field.getMaxOccurs() == 1) {
                        if (field.isUseRequired()) {
                            writer.println("mandatory");
                        } else {
                            writer.println("optional");
                        }
                    } else if (field.getMinOccurs() == field.getMaxOccurs()) {
                        writer.println("extactly " + field.getMaxOccurs());
                    } else {
                        writer.println(String.valueOf(field.getMinOccurs()) + "&nbsp;-&nbsp;" + (field.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : String.valueOf(field.getMaxOccurs())));
                    }
                    writer.println("&nbsp;");
                    fieldTypeElt = this._schemas.getElement(field.getBaseClass());
                    if (fieldTypeElt != null) {
                        link = this.getElementLink(fieldTypeElt);
                        if (link != null) {
                            writer.print("<A HREF=\"" + toRoot + "/" + link + "\">");
                        }
                        writer.print(fieldTypeElt.getTagName());
                        if (link != null) {
                            writer.print("</A>");
                        }
                    } else {
                        writer.print(field.getBaseClass().getSimpleName());
                    }
                    if (field.getMaxOccurs() > 1) {
                        writer.print("[]");
                    }
                    writer.println("</CODE></FONT></TD>");
                    writer.println("<TD nowrap><CODE><B>" + field.getName() + "</B></CODE></TD>");
                    writer.println("<TD width=\"100%\">" + fieldDetails + "</TD>");
                    writer.println("</TR>");
                }
                writer.println("</TABLE>");
                writer.println("<P>");
            }
        }
        writer.println("<P>");
        writer.println("<!-- ======== CHILDREN ======== -->");
        writer.println("<A NAME=\"CHILDREN\"/>");
        for (i = 0; i < fieldAncestors.size(); ++i) {
            ISchemaElement elt = (ISchemaElement)fieldAncestors.get(fieldAncestors.size() - i - 1);
            mappedFields = ((XmlMappings)mappings.get(i)).getMappings(4);
            if (mappedFields == null || mappedFields.length <= 0) continue;
            writer.println("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\">");
            writer.println("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">");
            writer.println("<TD COLSPAN=2><FONT SIZE=\"+2\"><B>");
            if (i == 0) {
                writer.println("Direct Children Elements");
            } else {
                writer.println("Direct Children Elements Inherited from ");
                String link8 = this.getElementLink(elt);
                if (link8 != null) {
                    writer.print("<A HREF=\"" + toRoot + "/" + link8 + "\">");
                }
                writer.print(elt.getTagName());
                if (link8 != null) {
                    writer.print("</A>");
                }
            }
            writer.println("</B></FONT></TD>");
            writer.println("</TR>");
            for (int j = 0; j < mappedFields.length; ++j) {
                field = mappedFields[j];
                fieldDetails = MessagesHelper.getAttributeDetails(this._locale, iElt.getMappedClass(), field.getName());
                if (fieldDetails == null) {
                    fieldDetails = MessagesHelper.getAttributeName(this._locale, iElt.getMappedClass(), field.getName());
                }
                writer.println("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">");
                writer.println("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\"><FONT SIZE=\"-1\">");
                writer.println("<CODE>");
                if (field.getMaxOccurs() == 1) {
                    if (field.isUseRequired()) {
                        writer.println("mandatory");
                    } else {
                        writer.println("optional");
                    }
                } else if (field.getMinOccurs() == field.getMaxOccurs()) {
                    writer.println("extactly " + field.getMaxOccurs());
                } else {
                    writer.println(String.valueOf(field.getMinOccurs()) + "&nbsp;-&nbsp;" + (field.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : String.valueOf(field.getMaxOccurs())));
                }
                writer.println("&nbsp;");
                fieldTypeElt = this._schemas.getElement(field.getBaseClass());
                if (fieldTypeElt != null) {
                    link = this.getElementLink(fieldTypeElt);
                    if (link != null) {
                        writer.print("<A HREF=\"" + toRoot + "/" + link + "\">");
                    }
                    writer.print(fieldTypeElt.getTagName());
                    if (link != null) {
                        writer.print("</A>");
                    }
                } else {
                    writer.print(field.getBaseClass().getSimpleName());
                }
                if (field.getMaxOccurs() > 1) {
                    writer.print("[]");
                }
                writer.println("</CODE></FONT></TD>");
                writer.println("<TD width=\"100%\">" + fieldDetails + "</TD>");
                writer.println("</TR>");
            }
            writer.println("</TABLE>");
            writer.println("<P>");
        }
        writer.println("</BODY>");
        writer.println("</HTML>");
        writer.close();
    }
}

