/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.xmlmapping;

import com.ebm_ws.infra.xmlmapping.IXmlModelMessage;
import com.ebm_ws.infra.xmlmapping.impl.ObjInfo;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class ObjInfoHolder {
    private Vector _elements = new Vector();

    public ObjInfo getInfoFromObj(IXmlObject iObj) {
        for (int i = 0; i < this._elements.size(); ++i) {
            if (iObj != ((ObjInfo)this._elements.elementAt(i)).getObject()) continue;
            return (ObjInfo)this._elements.elementAt(i);
        }
        return null;
    }

    public ObjInfo getInfoFromId(String iPathId) {
        for (int i = 0; i < this._elements.size(); ++i) {
            if (!((ObjInfo)this._elements.elementAt(i)).getIdPath().equals(iPathId)) continue;
            return (ObjInfo)this._elements.elementAt(i);
        }
        return null;
    }

    protected void addInfo(ObjInfo info) {
        this._elements.addElement(info);
    }

    protected void removeAllInfo() {
        this._elements.clear();
    }

    private int countMessages(int treshold) {
        int nbErrs = 0;
        for (int i = 0; i < this._elements.size(); ++i) {
            ObjInfo oi = (ObjInfo)this._elements.elementAt(i);
            nbErrs += oi.countMessages(treshold);
        }
        return nbErrs;
    }

    public void dumpMessages(int treshold, PrintWriter iPrinter) {
        for (int i = 0; i < this._elements.size(); ++i) {
            ((ObjInfo)this._elements.elementAt(i)).dumpMessages(treshold, iPrinter);
        }
        iPrinter.flush();
    }

    public boolean hasMessages(int treshold) {
        return this.countMessages(treshold) > 0;
    }

    public IXmlModelMessage[] getAllMessages() {
        ArrayList retList = new ArrayList();
        for (int i = 0; i < this._elements.size(); ++i) {
            ObjInfo oi = (ObjInfo)this._elements.elementAt(i);
            List msgs = oi.getMessages(5);
            if (msgs == null) continue;
            retList.addAll(msgs);
        }
        IXmlModelMessage[] ret = new IXmlModelMessage[retList.size()];
        retList.toArray(ret);
        return ret;
    }

    public IXmlModelMessage[] getAllElementMessages(IXmlObject iXmlElement) {
        ObjInfo oi = this.getInfoFromObj(iXmlElement);
        if (oi == null) {
            return null;
        }
        List msgs = oi.getMessages(5);
        if (msgs == null) {
            return null;
        }
        IXmlModelMessage[] ret = new IXmlModelMessage[msgs.size()];
        msgs.toArray(ret);
        return ret;
    }

    public IXmlModelMessage[] getGlobalElementMessages(IXmlObject iXmlElement) {
        ObjInfo oi = this.getInfoFromObj(iXmlElement);
        if (oi == null) {
            return null;
        }
        List msgs = oi.getMessages(5);
        if (msgs == null) {
            return null;
        }
        ArrayList<IXmlModelMessage> retList = new ArrayList<IXmlModelMessage>();
        for (int i = 0; i < msgs.size(); ++i) {
            IXmlModelMessage msg = (IXmlModelMessage)msgs.get(i);
            if (msg.getMappingName() != null) continue;
            retList.add(msg);
        }
        if (retList.isEmpty()) {
            return null;
        }
        IXmlModelMessage[] ret = new IXmlModelMessage[retList.size()];
        retList.toArray(ret);
        return ret;
    }

    public IXmlModelMessage[] getMappingElementMessages(IXmlObject iXmlElement, String iMappingName) {
        ObjInfo oi = this.getInfoFromObj(iXmlElement);
        if (oi == null) {
            return null;
        }
        List msgs = oi.getMessages(5);
        if (msgs == null) {
            return null;
        }
        ArrayList<IXmlModelMessage> retList = new ArrayList<IXmlModelMessage>();
        for (int i = 0; i < msgs.size(); ++i) {
            IXmlModelMessage msg = (IXmlModelMessage)msgs.get(i);
            if (!iMappingName.equals(msg.getMappingName())) continue;
            retList.add(msg);
        }
        if (retList.isEmpty()) {
            return null;
        }
        IXmlModelMessage[] ret = new IXmlModelMessage[retList.size()];
        retList.toArray(ret);
        return ret;
    }

    protected void checkAllNodes(Object iValidSupport) {
        for (int i = 0; i < this._elements.size(); ++i) {
            ObjInfo info = (ObjInfo)this._elements.elementAt(i);
            if (info.getObject() == null) continue;
            try {
                info.getObject().checkThisNode(iValidSupport, info);
                continue;
            }
            catch (Throwable t) {
                StringWriter w = new StringWriter();
                t.printStackTrace(new PrintWriter(w));
                info.logMessage(null, 1, w.toString());
            }
        }
    }
}

