/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.xmlmapping;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestSAX {
    private URL _mainDoc;

    public static void main(String[] args) throws MalformedURLException, SAXException, IOException, ParserConfigurationException {
        File f = new File(args[0]);
        TestSAX.instantiate(new URL("file", "", f.getAbsolutePath()));
    }

    private TestSAX(URL iMainDocUrl) {
        this._mainDoc = iMainDocUrl;
    }

    public static final TestSAX instantiate(URL iXmlFileUrl) throws SAXException, IOException, ParserConfigurationException {
        TestSAX doc = new TestSAX(iXmlFileUrl);
        doc.instantiateMainDoc();
        return doc;
    }

    private void instantiateMainDoc() throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        InputStream in = this._mainDoc.openStream();
        TrackerInputStream tin = new TrackerInputStream(in);
        parser.parse((InputStream)tin, (DefaultHandler)new SAXHandler(tin));
        in.close();
    }

    private class SAXHandler
    extends DefaultHandler {
        private TrackerInputStream in;
        private Vector infoAncestors = new Vector();

        public SAXHandler(TrackerInputStream in) {
            this.in = in;
        }

        public void startDocument() throws SAXException {
            Thread.dumpStack();
            System.out.println("[l" + this.in.line + " c" + this.in.col + "] startDocument()");
        }

        public void endDocument() throws SAXException {
            System.out.println("[l" + this.in.line + " c" + this.in.col + "] endDocument()");
        }

        public void startElement(String uri, String localName, String name, Attributes attribs) throws SAXException {
            System.out.println("[l" + this.in.line + " c" + this.in.col + "] startElement('" + uri + "', '" + localName + "', '" + name + "')");
            if (localName.startsWith("Import_")) {
                String file = attribs.getValue("File");
                if (file == null) {
                    System.out.println("Attribute File expected on an Import element.");
                    return;
                }
                try {
                    StringBuffer fileUrl = new StringBuffer();
                    int idx = TestSAX.this._mainDoc.getFile().lastIndexOf(47);
                    fileUrl.append(TestSAX.this._mainDoc.getFile().substring(0, idx + 1));
                    fileUrl.append(fileUrl);
                    URL docUrl = new URL(TestSAX.this._mainDoc.getProtocol(), TestSAX.this._mainDoc.getHost(), fileUrl.toString());
                    SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                    parserFactory.setNamespaceAware(true);
                    SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                    InputStream in = docUrl.openStream();
                    parser.parse(in, (DefaultHandler)this);
                    in.close();
                    return;
                }
                catch (Exception e) {
                    System.out.println("Error while importing document '" + file + "': " + e.getMessage());
                    return;
                }
            }
        }

        public void characters(char[] chars, int start, int length) throws SAXException {
            System.out.println("[l" + this.in.line + " c" + this.in.col + "] characters: " + new String(chars, start, length));
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            System.out.println("[l" + this.in.line + " c" + this.in.col + "] endElement('" + uri + "', '" + localName + "', '" + name + "')");
        }
    }

    private class TrackerInputStream
    extends InputStream {
        private InputStream in;
        private StringBuilder buffer = new StringBuilder();
        private int line = 0;
        private int col = 0;

        public TrackerInputStream(InputStream in) {
            this.in = in;
        }

        public int read() throws IOException {
            if (this.line == 0 && this.col == 0) {
                Thread.dumpStack();
            }
            int c = this.in.read();
            switch (c) {
                case 10: {
                    ++this.line;
                    this.col = 0;
                    this.buffer.setLength(0);
                    break;
                }
                case 13: {
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    ++this.col;
                    this.buffer.append((char)c);
                }
            }
            return c;
        }

        public int getLine() {
            return this.line;
        }

        public int getCol() {
            return this.col;
        }

        public String getCurLine() {
            return this.buffer.toString();
        }
    }
}

