/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.xmlmapping;

import com.ebm_ws.infra.xmlmapping.ObjInfoHolder;
import com.ebm_ws.infra.xmlmapping.XmlInstantiator;
import com.ebm_ws.infra.xmlmapping.XmlSerializer;
import com.ebm_ws.infra.xmlmapping.impl.ObjInfo;
import com.ebm_ws.infra.xmlmapping.interfaces.IEnumeration;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import com.ebm_ws.infra.xmlmapping.schema.ISchemaElement;
import com.ebm_ws.infra.xmlmapping.schema.SchemasManager;
import com.ebm_ws.infra.xmlmapping.utils.MappedField;
import com.ebm_ws.infra.xmlmapping.utils.XmlMappings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.xml.sax.SAXException;

public class XmlEditor
extends ObjInfoHolder {
    private Object _validSupport;
    private SchemasManager _manager;
    private IXmlObject _root;

    public XmlEditor(Object iSupport) {
        this._validSupport = iSupport;
    }

    public void load(InputStream xmlInput) throws ParserConfigurationException, SAXException, IOException {
        XmlInstantiator model = XmlInstantiator.instantiate(xmlInput, this._validSupport);
        this._manager = model.getSchemas();
        this._root = model.getRoot();
        this.revalidate();
    }

    public void save(OutputStream xmlOutput) throws UnsupportedEncodingException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        XmlSerializer.serialize(this._manager, this._root, xmlOutput);
    }

    public IXmlObject getRoot() {
        return this._root;
    }

    public SchemasManager getSchemas() {
        return this._manager;
    }

    public void delete(IXmlObject iObj) {
    }

    public void changeType(IXmlObject iObj, Class iNewType) {
    }

    public void changeValues(IXmlObject iObj, MappedField[] iFields, Object[] iValues) {
    }

    public void add(IXmlObject iParent, MappedField iMapping, IXmlObject iChild) {
    }

    private void revalidate() {
        this.removeAllInfo();
        ObjInfo rootInfo = new ObjInfo(null, null, this._manager.getElement(this._root.getClass()), this._root);
        this.addInfo(rootInfo);
        this.glueAndCheckObj(rootInfo);
        this.checkAllNodes(this._validSupport);
    }

    private void glueAndCheckObj(ObjInfo info) {
        MappedField[] contentMappings;
        MappedField fieldMapping;
        IXmlObject obj = info.getObject();
        ObjInfo parent = info.getParent();
        ISchemaElement schemaElt = this._manager.getElement(obj.getClass());
        if (schemaElt == null) {
            info.logMessage(null, 0, "Object not found in any declared schema.");
            return;
        }
        XmlMappings mappings = XmlMappings.getMappings(obj.getClass(), true);
        if (parent != null) {
            MappedField[] rootMappings = mappings.getMappings(32);
            for (int i = 0; i < rootMappings.length; ++i) {
                MappedField fieldMapping2 = rootMappings[i];
                if (!fieldMapping2.getField().getType().isInstance(this._root)) {
                    info.logMessage(fieldMapping2.getName(), 0, "Root field '" + fieldMapping2.getField().getName() + "' type (" + fieldMapping2.getBaseClass().getName() + ") is not compatible with the root type: " + this._root.getClass().getName());
                    continue;
                }
                try {
                    fieldMapping2.getField().setAccessible(true);
                    fieldMapping2.getField().set(obj, this._root);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    info.logMessage(fieldMapping2.getName(), 0, "Root field '" + fieldMapping2.getField().getName() + "' type (" + fieldMapping2.getBaseClass().getName() + ") is not compatible with the root type: " + this._root.getClass().getName());
                    continue;
                }
                catch (IllegalAccessException e) {
                    info.logMessage(fieldMapping2.getName(), 0, "Root field '" + fieldMapping2.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
                }
            }
            MappedField[] parentMappings = mappings.getMappings(16);
            for (int i = 0; i < parentMappings.length; ++i) {
                MappedField fieldMapping3 = parentMappings[i];
                if (!fieldMapping3.getField().getType().isInstance(parent.getObject())) {
                    info.logMessage(fieldMapping3.getName(), 2, "Parent field '" + fieldMapping3.getField().getName() + "' type (" + fieldMapping3.getBaseClass().getName() + ") is not compatible with the parent type: " + parent.getObject().getClass().getName() + ". Will be null.");
                    continue;
                }
                try {
                    fieldMapping3.getField().setAccessible(true);
                    fieldMapping3.getField().set(obj, parent.getObject());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    info.logMessage(fieldMapping3.getName(), 2, "Parent field '" + fieldMapping3.getField().getName() + "' type (" + fieldMapping3.getBaseClass().getName() + ") is not compatible with the parent type: " + parent.getObject().getClass().getName() + ". Will be null.");
                    continue;
                }
                catch (IllegalAccessException e) {
                    info.logMessage(fieldMapping3.getName(), 0, "Parent field '" + fieldMapping3.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
                }
            }
            MappedField[] ancestorMappings = mappings.getMappings(64);
            for (int i = 0; i < ancestorMappings.length; ++i) {
                ObjInfo ancestor;
                fieldMapping = ancestorMappings[i];
                for (ancestor = info.getParent(); ancestor != null && !fieldMapping.getField().getType().isInstance(ancestor.getObject()); ancestor = ancestor.getParent()) {
                }
                if (ancestor != null) {
                    try {
                        fieldMapping.getField().setAccessible(true);
                        fieldMapping.getField().set(obj, ancestor.getObject());
                    }
                    catch (IllegalArgumentException e) {
                        info.logMessage(fieldMapping.getName(), 2, "Ancestor field '" + fieldMapping.getField().getName() + "' type (" + fieldMapping.getBaseClass().getName() + ") is not compatible with the parent type: " + ancestor.getObject().getClass().getName() + ". Will be null.");
                    }
                    catch (IllegalAccessException e) {
                        info.logMessage(fieldMapping.getName(), 0, "Ancestor field '" + fieldMapping.getField().getName() + "' cannot be set in class '" + obj.getClass().getName() + "'.");
                    }
                    continue;
                }
                info.logMessage(fieldMapping.getName(), 4, "No matching ancestor for field '" + fieldMapping.getField().getName() + "' type (" + fieldMapping.getBaseClass().getName() + "). Will be null.");
            }
        }
        if ((contentMappings = mappings.getMappings(8)).length > 0) {
            for (int i = 0; i < contentMappings.length; ++i) {
                MappedField fieldMapping4 = contentMappings[i];
                fieldMapping4.getField().setAccessible(true);
                try {
                    String content = (String)fieldMapping4.getField().get(obj);
                    continue;
                }
                catch (Exception e) {
                    info.logMessage(fieldMapping4.getName(), 0, "Content field '" + fieldMapping4.getField().getName() + "' could not be retreived: " + e.getMessage());
                }
            }
        }
        MappedField[] attrMappings = mappings.getMappings(1);
        for (int i = 0; i < attrMappings.length; ++i) {
            MappedField fieldMapping5 = attrMappings[i];
            fieldMapping5.getField().setAccessible(true);
            Object val = null;
            try {
                val = fieldMapping5.getField().get(obj);
            }
            catch (Exception e) {
                info.logMessage(fieldMapping5.getName(), 0, "Attribute field '" + fieldMapping5.getField().getName() + "' could not be retreived: " + e.getMessage());
                continue;
            }
            if (val == null) {
                if (!fieldMapping5.isUseRequired()) continue;
                info.logMessage(fieldMapping5.getName(), 0, "Attribute '" + fieldMapping5.getName() + "' required.");
                continue;
            }
            if (String.class.isAssignableFrom(fieldMapping5.getBaseClass()) || Integer.TYPE.isAssignableFrom(fieldMapping5.getBaseClass()) || Integer.class.isAssignableFrom(fieldMapping5.getBaseClass()) || Boolean.TYPE.isAssignableFrom(fieldMapping5.getBaseClass()) || Boolean.class.isAssignableFrom(fieldMapping5.getBaseClass()) || IEnumeration.class.isAssignableFrom(fieldMapping5.getBaseClass())) continue;
            info.logMessage(fieldMapping5.getName(), 0, "Attribute '" + fieldMapping5.getName() + "' has an unsupported type: " + fieldMapping5.getBaseClass() + ".");
        }
        MappedField[] childMappings = mappings.getMappings(2);
        for (int i = 0; i < childMappings.length; ++i) {
            fieldMapping = childMappings[i];
            fieldMapping.getField().setAccessible(true);
            Object val = null;
            try {
                val = fieldMapping.getField().get(obj);
            }
            catch (Exception e) {
                info.logMessage(fieldMapping.getName(), 0, "Child node field '" + fieldMapping.getField().getName() + "' could not be retreived: " + e.getMessage());
                continue;
            }
            if (val == null) {
                if (!fieldMapping.isUseRequired()) continue;
                info.logMessage(fieldMapping.getName(), 0, "Child node '" + fieldMapping.getName() + "' required.");
                continue;
            }
            if (fieldMapping.getField().getType().isArray()) {
                int len = Array.getLength(val);
                if (len < fieldMapping.getMinOccurs()) {
                    info.logMessage(fieldMapping.getName(), 0, "Child node '" + fieldMapping.getName() + "' expects at least " + fieldMapping.getMinOccurs() + " children.");
                } else if (len > fieldMapping.getMaxOccurs()) {
                    info.logMessage(fieldMapping.getName(), 0, "Child node '" + fieldMapping.getName() + "' expects at most " + fieldMapping.getMaxOccurs() + " children.");
                }
                for (int j = 0; j < len; ++j) {
                    IXmlObject v = (IXmlObject)Array.get(val, j);
                    ObjInfo childInfo = new ObjInfo(info, fieldMapping, j, this._manager.getElement(v.getClass()), v);
                    this.addInfo(childInfo);
                    this.glueAndCheckObj(childInfo);
                }
                continue;
            }
            ObjInfo childInfo = new ObjInfo(info, fieldMapping, this._manager.getElement(val.getClass()), (IXmlObject)val);
            this.addInfo(childInfo);
            this.glueAndCheckObj(childInfo);
        }
        MappedField[] collectedMappings = mappings.getMappings(4);
        for (int i = 0; i < collectedMappings.length; ++i) {
            MappedField fieldMapping6 = collectedMappings[i];
            fieldMapping6.getField().setAccessible(true);
            Object val = null;
            try {
                val = fieldMapping6.getField().get(obj);
            }
            catch (Exception e) {
                info.logMessage(fieldMapping6.getName(), 0, "Collected node '" + fieldMapping6.getField().getName() + "' could not be retreived: " + e.getMessage());
                continue;
            }
            if (val == null) {
                if (!fieldMapping6.isUseRequired()) continue;
                info.logMessage(fieldMapping6.getName(), 0, "Collected node '" + fieldMapping6.getName() + "' required.");
                continue;
            }
            if (fieldMapping6.getField().getType().isArray()) {
                int len = Array.getLength(val);
                if (len < fieldMapping6.getMinOccurs()) {
                    info.logMessage(fieldMapping6.getName(), 0, "Collected node '" + fieldMapping6.getName() + "' expects at least " + fieldMapping6.getMinOccurs() + " children.");
                } else if (len > fieldMapping6.getMaxOccurs()) {
                    info.logMessage(fieldMapping6.getName(), 0, "Collected node '" + fieldMapping6.getName() + "' expects at most " + fieldMapping6.getMaxOccurs() + " children.");
                }
                for (int j = 0; j < len; ++j) {
                    IXmlObject v = (IXmlObject)Array.get(val, j);
                    ObjInfo childInfo = new ObjInfo(info, fieldMapping6, j, this._manager.getElement(v.getClass()), v);
                    this.addInfo(childInfo);
                    this.glueAndCheckObj(childInfo);
                }
                continue;
            }
            ObjInfo childInfo = new ObjInfo(info, fieldMapping6, this._manager.getElement(val.getClass()), (IXmlObject)val);
            this.addInfo(childInfo);
            this.glueAndCheckObj(childInfo);
        }
    }
}

