/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.xmlmapping;

import com.ebm_ws.infra.xmlmapping.ObjInfoHolder;
import com.ebm_ws.infra.xmlmapping.impl.ObjInfo;
import com.ebm_ws.infra.xmlmapping.interfaces.IEnumeration;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import com.ebm_ws.infra.xmlmapping.schema.ISchema;
import com.ebm_ws.infra.xmlmapping.schema.ISchemaElement;
import com.ebm_ws.infra.xmlmapping.schema.SchemasManager;
import com.ebm_ws.infra.xmlmapping.utils.EnumHelper;
import com.ebm_ws.infra.xmlmapping.utils.MappedField;
import com.ebm_ws.infra.xmlmapping.utils.XmlHelper;
import com.ebm_ws.infra.xmlmapping.utils.XmlMappings;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlSerializer
extends ObjInfoHolder {
    private Document _doc;
    private SchemasManager _manager;
    private IXmlObject _root;

    public Document getDocument() {
        return this._doc;
    }

    public static final XmlSerializer serialize(SchemasManager iManager, IXmlObject iRoot) throws ParserConfigurationException {
        XmlSerializer serializer = new XmlSerializer(iManager, iRoot);
        serializer.serialize();
        return serializer;
    }

    public static final XmlSerializer serialize(SchemasManager iManager, IXmlObject iRoot, OutputStream output) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException {
        XmlSerializer serializer = XmlSerializer.serialize(iManager, iRoot);
        XmlHelper.serializeXml(serializer.getDocument(), output);
        return serializer;
    }

    public XmlSerializer(SchemasManager iManager, IXmlObject iRoot) throws ParserConfigurationException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this._doc = docBuilder.newDocument();
        this._manager = iManager;
        this._root = iRoot;
    }

    private void serialize() {
        ObjInfo rootInfo = new ObjInfo(null, null, this._manager.getElement(this._root.getClass()), this._root);
        this.addInfo(rootInfo);
        this.serializeObj(this._doc, rootInfo);
        Element element = this._doc.getDocumentElement();
        element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        ISchema[] imports = this._manager.getAllSchemas();
        StringBuffer schemaLocation = new StringBuffer();
        for (int i = 0; i < imports.length; ++i) {
            element.setAttribute("xmlns:" + imports[i].getName(), imports[i].getRootPackage());
            schemaLocation.append(imports[i].getRootPackage());
            schemaLocation.append(" ");
            schemaLocation.append(imports[i].getLocator());
            schemaLocation.append(" ");
        }
        element.setAttribute("xsi:schemaLocation", schemaLocation.toString());
    }

    private void serializeObj(Node iParent, ObjInfo iObjInfo) {
        ObjInfo childInfo;
        IXmlObject v;
        int j;
        ISchemaElement schemaElt = iObjInfo.getSchemaElement();
        if (schemaElt == null) {
            iObjInfo.logMessage(null, 0, "Object not found in any declared schema.");
            return;
        }
        Element element = this._doc.createElement(schemaElt.getSchema().getName() + ":" + schemaElt.getTagName());
        iParent.appendChild(element);
        XmlMappings mappings = XmlMappings.getMappings(iObjInfo.getObject().getClass(), true);
        MappedField[] contentMappings = mappings.getMappings(8);
        if (contentMappings.length > 0) {
            for (int i = 0; i < contentMappings.length; ++i) {
                MappedField fieldMapping = contentMappings[i];
                fieldMapping.getField().setAccessible(true);
                try {
                    String content = (String)fieldMapping.getField().get(iObjInfo.getObject());
                    if (content == null) continue;
                    CDATASection cdata = this._doc.createCDATASection(content);
                    element.appendChild(cdata);
                    continue;
                }
                catch (Exception e) {
                    iObjInfo.logMessage(fieldMapping.getName(), 0, "Content field '" + fieldMapping.getField().getName() + "' could not be retreived: " + e.getMessage());
                }
            }
        }
        MappedField[] attrMappings = mappings.getMappings(1);
        for (int i = 0; i < attrMappings.length; ++i) {
            MappedField fieldMapping = attrMappings[i];
            fieldMapping.getField().setAccessible(true);
            Object val = null;
            try {
                val = fieldMapping.getField().get(iObjInfo.getObject());
            }
            catch (Exception e) {
                iObjInfo.logMessage(fieldMapping.getName(), 0, "Attribute field '" + fieldMapping.getField().getName() + "' could not be retreived: " + e.getMessage());
                continue;
            }
            if (val == null) {
                if (!fieldMapping.isUseRequired()) continue;
                iObjInfo.logMessage(fieldMapping.getName(), 0, "Attribute '" + fieldMapping.getName() + "' required.");
                continue;
            }
            if (String.class.isAssignableFrom(fieldMapping.getBaseClass())) {
                element.setAttribute(fieldMapping.getName(), (String)val);
                continue;
            }
            if (Integer.TYPE.isAssignableFrom(fieldMapping.getBaseClass()) || Integer.class.isAssignableFrom(fieldMapping.getBaseClass())) {
                element.setAttribute(fieldMapping.getName(), String.valueOf(val));
                continue;
            }
            if (Boolean.TYPE.isAssignableFrom(fieldMapping.getBaseClass()) || Boolean.class.isAssignableFrom(fieldMapping.getBaseClass())) {
                element.setAttribute(fieldMapping.getName(), String.valueOf(val));
                continue;
            }
            if (!IEnumeration.class.isAssignableFrom(fieldMapping.getBaseClass())) continue;
            String enumValName = EnumHelper.getItemName(val);
            element.setAttribute(fieldMapping.getName(), enumValName);
        }
        MappedField[] childMappings = mappings.getMappings(2);
        for (int i = 0; i < childMappings.length; ++i) {
            MappedField fieldMapping = childMappings[i];
            fieldMapping.getField().setAccessible(true);
            Object val = null;
            try {
                val = fieldMapping.getField().get(iObjInfo.getObject());
            }
            catch (Exception e) {
                iObjInfo.logMessage(fieldMapping.getName(), 0, "Child node field '" + fieldMapping.getField().getName() + "' could not be retreived: " + e.getMessage());
                continue;
            }
            if (val == null) {
                if (!fieldMapping.isUseRequired()) continue;
                iObjInfo.logMessage(fieldMapping.getName(), 0, "Child node '" + fieldMapping.getName() + "' required.");
                continue;
            }
            Element childNode = this._doc.createElement(fieldMapping.getName());
            element.appendChild(childNode);
            if (fieldMapping.getField().getType().isArray()) {
                int len = Array.getLength(val);
                if (len < fieldMapping.getMinOccurs()) {
                    iObjInfo.logMessage(fieldMapping.getName(), 0, "Child node '" + fieldMapping.getName() + "' expects at least " + fieldMapping.getMinOccurs() + " children.");
                } else if (len > fieldMapping.getMaxOccurs()) {
                    iObjInfo.logMessage(fieldMapping.getName(), 0, "Child node '" + fieldMapping.getName() + "' expects at most " + fieldMapping.getMaxOccurs() + " children.");
                }
                for (j = 0; j < len; ++j) {
                    v = (IXmlObject)Array.get(val, j);
                    if (v == null) continue;
                    childInfo = new ObjInfo(iObjInfo, fieldMapping, j, this._manager.getElement(v.getClass()), v);
                    this.addInfo(childInfo);
                    this.serializeObj(childNode, childInfo);
                }
                continue;
            }
            ObjInfo childInfo2 = new ObjInfo(iObjInfo, fieldMapping, this._manager.getElement(val.getClass()), (IXmlObject)val);
            this.addInfo(childInfo2);
            this.serializeObj(childNode, childInfo2);
        }
        MappedField[] collectedMappings = mappings.getMappings(4);
        for (int i = 0; i < collectedMappings.length; ++i) {
            MappedField fieldMapping = collectedMappings[i];
            fieldMapping.getField().setAccessible(true);
            Object val = null;
            try {
                val = fieldMapping.getField().get(iObjInfo.getObject());
            }
            catch (Exception e) {
                iObjInfo.logMessage(fieldMapping.getName(), 0, "Collected node '" + fieldMapping.getField().getName() + "' could not be retreived: " + e.getMessage());
                continue;
            }
            if (val == null) {
                if (!fieldMapping.isUseRequired()) continue;
                iObjInfo.logMessage(fieldMapping.getName(), 0, "Collected node '" + fieldMapping.getName() + "' required.");
                continue;
            }
            if (fieldMapping.getField().getType().isArray()) {
                int len = Array.getLength(val);
                if (len < fieldMapping.getMinOccurs()) {
                    iObjInfo.logMessage(fieldMapping.getName(), 0, "Collected node '" + fieldMapping.getName() + "' expects at least " + fieldMapping.getMinOccurs() + " children.");
                } else if (len > fieldMapping.getMaxOccurs()) {
                    iObjInfo.logMessage(fieldMapping.getName(), 0, "Collected node '" + fieldMapping.getName() + "' expects at most " + fieldMapping.getMaxOccurs() + " children.");
                }
                for (j = 0; j < len; ++j) {
                    v = (IXmlObject)Array.get(val, j);
                    childInfo = new ObjInfo(iObjInfo, fieldMapping, j, this._manager.getElement(v.getClass()), v);
                    this.addInfo(childInfo);
                    this.serializeObj(element, childInfo);
                }
                continue;
            }
            ObjInfo childInfo3 = new ObjInfo(iObjInfo, fieldMapping, this._manager.getElement(val.getClass()), (IXmlObject)val);
            this.addInfo(childInfo3);
            this.serializeObj(element, childInfo3);
        }
    }
}

