/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.xmlmapping;

import com.ebm_ws.infra.xmlmapping.schema.ISchema;
import com.ebm_ws.infra.xmlmapping.schema.SchemasManager;
import com.ebm_ws.infra.xmlmapping.utils.XmlHelper;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class XsdGenerator {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: GenXSD [output_xsd_file] [java_package] ( [import_xsd_file] [import_package] )*");
            return;
        }
        String xsdFile = args[0];
        String javaPackage = args[1];
        try {
            System.out.println("Generate XSD schema from code");
            System.out.println("-----------------------------");
            System.out.println("  - output file           : " + xsdFile);
            System.out.println("  - root code package     : " + javaPackage);
            SchemasManager schemas = new SchemasManager();
            ISchema mainSchema = schemas.declareSchema(XsdGenerator.getPrefix(xsdFile), xsdFile, javaPackage);
            for (int i = 2; i < args.length; i += 2) {
                String importXsd = args[i];
                String importPrefix = XsdGenerator.getPrefix(importXsd);
                String importPack = args[i + 1];
                System.out.println("  --> import file : " + importXsd + ", prefix : " + importPrefix + ", Java package: " + importPack);
                schemas.declareSchema(importPrefix, importXsd, importPack);
            }
            System.out.println("");
            mainSchema.buildFromClassPath();
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xmlDoc = docBuilder.newDocument();
            mainSchema.generateXSD(xmlDoc);
            XmlHelper.serializeXml(xmlDoc, new FileOutputStream(xsdFile));
            System.out.println("... Done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getPrefix(String iXsdFile) {
        String prefix = iXsdFile;
        int idx = prefix.lastIndexOf(47);
        if (idx >= 0) {
            prefix = prefix.substring(idx + 1);
        }
        if ((idx = prefix.indexOf(46)) >= 0) {
            prefix = prefix.substring(0, idx);
        }
        return prefix;
    }
}

