/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.xmlmapping.impl;

import com.ebm_ws.infra.xmlmapping.impl.ModelMessageImpl;
import com.ebm_ws.infra.xmlmapping.interfaces.IEnumeration;
import com.ebm_ws.infra.xmlmapping.interfaces.IValidityLogger;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import com.ebm_ws.infra.xmlmapping.schema.ISchemaElement;
import com.ebm_ws.infra.xmlmapping.utils.EnumHelper;
import com.ebm_ws.infra.xmlmapping.utils.MappedField;
import com.ebm_ws.infra.xmlmapping.utils.XmlMappings;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ObjInfo
implements IValidityLogger {
    private ObjInfo _parent;
    private MappedField _parentMapping;
    private int _childIndex = -1;
    private IXmlObject _obj;
    private ISchemaElement _elt;
    private List _errors;
    private URL xmlFile;

    public ObjInfo(ObjInfo iParent, MappedField iParentMapping, ISchemaElement iSchemaElt, IXmlObject iObj) {
        this._parent = iParent;
        this._parentMapping = iParentMapping;
        this._elt = iSchemaElt;
        this._obj = iObj;
    }

    public ObjInfo(ObjInfo iParent, MappedField iParentMapping, int iChildIdx, ISchemaElement iSchemaElt, IXmlObject iObj) {
        this._parent = iParent;
        this._parentMapping = iParentMapping;
        this._elt = iSchemaElt;
        this._childIndex = iChildIdx;
        this._obj = iObj;
    }

    public URL getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(URL xmlFile) {
        this.xmlFile = xmlFile;
    }

    public IXmlObject getObject() {
        return this._obj;
    }

    public ISchemaElement getSchemaElement() {
        return this._elt;
    }

    public ObjInfo getParent() {
        return this._parent;
    }

    public MappedField getParentMapping() {
        return this._parentMapping;
    }

    public int getParentChildIndex() {
        return this._childIndex;
    }

    public void logMessage(IXmlObject iFromNode, String iMappingName, int iSeverity, String iMessage) {
        this.logMessage(iMappingName, iSeverity, iMessage);
    }

    public void clearMessages() {
        if (this._errors == null) {
            return;
        }
        this._errors.clear();
    }

    public void logMessage(String iMappingName, int iType, String iMessage) {
        if (this._errors == null) {
            this._errors = new ArrayList(1);
        }
        this._errors.add(new ModelMessageImpl(this, iMappingName, iType, iMessage));
    }

    public int countMessages(int treshold) {
        if (this._errors == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this._errors.size(); ++i) {
            if (((ModelMessageImpl)this._errors.get(i)).getSeverity() > treshold) continue;
            ++count;
        }
        return this._errors.size();
    }

    public List getMessages(int treshold) {
        if (this._errors == null) {
            return null;
        }
        ArrayList ret = new ArrayList();
        for (int i = 0; i < this._errors.size(); ++i) {
            if (((ModelMessageImpl)this._errors.get(i)).getSeverity() > treshold) continue;
            ret.add(this._errors.get(i));
        }
        return ret;
    }

    public String getNiceName() {
        if (this._obj == null) {
            return "Doc";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this._elt.getSchema().getName());
        sb.append(":");
        sb.append(this._elt.getTagName());
        XmlMappings mappings = XmlMappings.getMappings(this._obj.getClass(), true);
        MappedField[] v = mappings.getMappings(1);
        for (int i = 0; i < v.length; ++i) {
            MappedField field = v[i];
            if (!field.isUseRequired()) continue;
            try {
                field.getField().setAccessible(true);
                Object value = field.getField().get(this._obj);
                if (value == null) continue;
                sb.append(" ");
                sb.append(field.getName());
                sb.append("=");
                sb.append("'");
                if (IEnumeration.class.isAssignableFrom(field.getBaseClass())) {
                    sb.append(EnumHelper.getItemName(value));
                } else {
                    sb.append(String.valueOf(value));
                }
                sb.append("'");
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public String getNicePath() {
        if (this._parent == null) {
            if (this.xmlFile != null) {
                return this.xmlFile.toExternalForm() + " > " + this.getNiceName();
            }
            return this.getNiceName();
        }
        if (this.xmlFile != null && !this.xmlFile.equals(this._parent.xmlFile)) {
            return this.xmlFile.toExternalForm() + " > " + this.getNiceName();
        }
        return this._parent.getNicePath() + " > " + this.getNiceName();
    }

    public String getId() {
        if (this._parent == null) {
            return "root";
        }
        if (this._parentMapping.getMappingType() == 4) {
            if (this._childIndex < 0) {
                return this._parentMapping.getName();
            }
            return this._parentMapping.getName() + "." + this._childIndex;
        }
        if (this._childIndex < 0) {
            return "_";
        }
        return String.valueOf(this._childIndex);
    }

    public String getIdPath() {
        if (this._parent == null) {
            return "/" + this.getId();
        }
        if (this._parentMapping.getMappingType() == 4) {
            return this._parent.getIdPath() + "/" + this.getId();
        }
        return this._parent.getIdPath() + "/" + this._parentMapping.getName() + "/" + this.getId();
    }

    public void dumpMessages(int treshold, PrintWriter iPrinter) {
        List errors = this.getMessages(treshold);
        if (errors == null || errors.size() == 0) {
            return;
        }
        iPrinter.println("[" + this.getNicePath() + "]:");
        for (int i = 0; i < errors.size(); ++i) {
            ((ModelMessageImpl)errors.get(i)).dump(iPrinter);
        }
        iPrinter.println(" ");
    }
}

