/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.xmlmapping.impl;

import com.ebm_ws.infra.xmlmapping.interfaces.IEnumeration;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlImportable;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import com.ebm_ws.infra.xmlmapping.interfaces.IXmlSubstitutionGroup;
import com.ebm_ws.infra.xmlmapping.schema.ISchema;
import com.ebm_ws.infra.xmlmapping.schema.ISchemaElement;
import com.ebm_ws.infra.xmlmapping.schema.SchemasManager;
import com.ebm_ws.infra.xmlmapping.utils.EnumHelper;
import com.ebm_ws.infra.xmlmapping.utils.MappedField;
import com.ebm_ws.infra.xmlmapping.utils.MessagesHelper;
import com.ebm_ws.infra.xmlmapping.utils.XmlMappings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class SchemaImpl
implements ISchema {
    private static ISchemaElement[] ELTS_ARRAY_TYPE = new ISchemaElement[0];
    private static SchemaElement NO_ELT = new SchemaElement();
    private SchemasManager _manager;
    private Vector _usedSchemas = new Vector();
    private boolean _manageInheritance = true;
    private boolean _built = false;
    private String _name;
    private String _locator;
    private String _package;
    private Hashtable _class2Infos = new Hashtable();

    public SchemaImpl(SchemasManager iMgr, String iName, String iLocator, String iPackage) {
        this._manager = iMgr;
        this._name = iName;
        this._locator = iLocator;
        this._package = iPackage;
    }

    public String getName() {
        return this._name;
    }

    public String getLocator() {
        return this._locator;
    }

    public String getRootPackage() {
        return this._package;
    }

    public boolean isFullyBuilt() {
        return this._built;
    }

    public String toString() {
        return "Schema[" + this._name + "," + this._locator + "," + this._package + "]";
    }

    private void setUsedSchema(ISchema iSchema) {
        if (iSchema == this) {
            return;
        }
        if (!this._usedSchemas.contains(iSchema)) {
            this._usedSchemas.addElement(iSchema);
        }
    }

    public ISchemaElement getElement(Class iClass) {
        SchemaElement elt = (SchemaElement)this._class2Infos.get(iClass);
        if (elt == null) {
            if (iClass.isAnonymousClass()) {
                return null;
            }
            String className = iClass.getName();
            if (!className.startsWith(this._package + ".")) {
                return null;
            }
            String tag = className.substring(this._package.length() + 1);
            if (iClass.isInterface()) {
                if (IXmlSubstitutionGroup.class.isAssignableFrom(iClass)) {
                    elt = new SchemaElement();
                    elt._type = 2;
                    elt._class = iClass;
                    elt._tag = tag;
                    elt._schema = this;
                } else {
                    elt = NO_ELT;
                }
            } else if (IEnumeration.class.isAssignableFrom(iClass)) {
                elt = new SchemaElement();
                elt._type = 1;
                elt._class = iClass;
                elt._tag = tag;
                elt._schema = this;
            } else if (!IXmlObject.class.isAssignableFrom(iClass)) {
                elt = NO_ELT;
            } else {
                elt = new SchemaElement();
                elt._type = 4;
                elt._class = iClass;
                elt._tag = tag;
                elt._schema = this;
                Vector<ISchemaElement> substGroupElements = new Vector<ISchemaElement>();
                for (Class cls = iClass; cls != Object.class && cls != null; cls = cls.getSuperclass()) {
                    ISchemaElement abstractClassElement;
                    if (cls != iClass && (cls.getModifiers() & 0x400) != 0 && (abstractClassElement = this._manager.getElement(cls)) != null) {
                        substGroupElements.addElement(abstractClassElement);
                        this.setUsedSchema(abstractClassElement.getSchema());
                    }
                    Class<?>[] itfs = cls.getInterfaces();
                    for (int i = 0; i < itfs.length; ++i) {
                        ISchemaElement itfElement;
                        if (itfs[i] == IXmlObject.class || (itfElement = this._manager.getElement(itfs[i])) == null) continue;
                        substGroupElements.addElement(itfElement);
                        this.setUsedSchema(itfElement.getSchema());
                    }
                }
                if (substGroupElements.size() > 0) {
                    SchemaElement.access$502(elt, new ISchemaElement[substGroupElements.size()]);
                    substGroupElements.copyInto(elt._substitutionGroups);
                }
                Class superClass = iClass.getSuperclass();
                if (this._manageInheritance && superClass != Object.class) {
                    elt._superClass = this._manager.getElement(superClass);
                    if (elt._superClass != null) {
                        this.setUsedSchema(elt._superClass.getSchema());
                    }
                }
            }
            this._class2Infos.put(iClass, elt);
        }
        if (elt == NO_ELT) {
            return null;
        }
        return elt;
    }

    public ISchema[] getUsedSchemas() {
        Object[] ret = new ISchema[this._usedSchemas.size()];
        this._usedSchemas.copyInto(ret);
        return ret;
    }

    public ISchemaElement[] getAllElements() {
        ArrayList<ISchemaElement> ret = new ArrayList<ISchemaElement>();
        Enumeration elements = this._class2Infos.elements();
        while (elements.hasMoreElements()) {
            ISchemaElement elt = (ISchemaElement)elements.nextElement();
            if (elt == NO_ELT) continue;
            ret.add(elt);
        }
        return ret.toArray(ELTS_ARRAY_TYPE);
    }

    public void buildFromClassPath() {
        String packageEntryName = this._package.replace('.', '/') + "/";
        System.out.println("Building Schema for package: " + this._package + "...");
        Enumeration<URL> res = null;
        try {
            res = this.getClass().getClassLoader().getResources(packageEntryName);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (res == null) {
            System.out.println(" --> Directory " + packageEntryName + " not found in classpath.");
            return;
        }
        while (res.hasMoreElements()) {
            URL url = res.nextElement();
            if (url.getProtocol().equals("file")) {
                File packageDir = new File(URLDecoder.decode(url.getFile()));
                if (!packageDir.isDirectory()) continue;
                System.out.println(" --> Directory found: " + packageDir);
                int elts = this.buildFromFiles(packageDir, this._package, true);
                System.out.println("     (" + elts + " elements)");
                continue;
            }
            if (url.getProtocol().equals("jar") || url.getProtocol().equals("zip")) {
                String jarUrlStr = URLDecoder.decode(url.getFile());
                int idx = jarUrlStr.lastIndexOf(33);
                if (idx > 0) {
                    jarUrlStr = jarUrlStr.substring(0, idx);
                }
                System.out.println(" --> Jar found: " + jarUrlStr);
                int elts = 0;
                try {
                    URL jarUrl = new URL(jarUrlStr);
                    ZipInputStream zip = new ZipInputStream(jarUrl.openStream());
                    ZipEntry entry = null;
                    while ((entry = zip.getNextEntry()) != null) {
                        if (!entry.isDirectory() && entry.getName().startsWith(packageEntryName) && entry.getName().endsWith(".class")) {
                            String className = entry.getName().substring(0, entry.getName().length() - 6).replace("/", ".");
                            try {
                                Class<?> c = Class.forName(className);
                                if (this.getElement(c) != null) {
                                    ++elts;
                                }
                            }
                            catch (Throwable e) {
                                System.out.println("Error while computing schema element for class '" + className + "'.");
                                e.printStackTrace();
                            }
                        }
                        zip.closeEntry();
                    }
                    zip.close();
                    System.out.println("     (" + elts + " elements)");
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println(" --> Unsupported protocol: " + url);
        }
    }

    public void buildFromClassPathOFF() {
        String packageEntryName = this._package.replace('.', '/') + "/";
        try {
            Enumeration<URL> res = this.getClass().getClassLoader().getResources(packageEntryName);
            if (res != null) {
                while (res.hasMoreElements()) {
                    URL url = res.nextElement();
                    System.out.println(" --> " + url);
                    System.out.println(" --> " + url.getProtocol());
                    System.out.println(" --> " + url.getFile());
                    System.out.println(" --> " + url.getRef());
                }
            }
            if ((res = this.getClass().getClassLoader().getResources(this._package)) != null) {
                while (res.hasMoreElements()) {
                    System.out.println(" --> " + res.nextElement());
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Enumeration<Object> ppties = System.getProperties().keys();
        while (ppties.hasMoreElements()) {
            String name = (String)ppties.nextElement();
            System.out.println("[" + name + "]: " + System.getProperty(name));
        }
        String classPath = System.getProperty("java.class.path");
        StringTokenizer classPathElements = new StringTokenizer(classPath, File.pathSeparator);
        while (classPathElements.hasMoreTokens()) {
            String classPathElementName = classPathElements.nextToken();
            File classPathElement = new File(classPathElementName);
            if (!classPathElement.exists()) continue;
            if (classPathElement.isFile()) {
                if (!classPathElement.getName().endsWith(".zip") && !classPathElement.getName().endsWith(".jar")) continue;
                try {
                    ZipFile jar = new ZipFile(classPathElement);
                    ZipEntry packageEntry = jar.getEntry(packageEntryName);
                    if (packageEntry == null || !packageEntry.isDirectory()) continue;
                    Enumeration<? extends ZipEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (entry.isDirectory() || !entry.getName().startsWith(packageEntryName) || !entry.getName().endsWith(".class")) continue;
                        String className = entry.getName().substring(0, entry.getName().length() - 6).replace("/", ".");
                        try {
                            Class<?> c = Class.forName(className);
                            this.getElement(c);
                        }
                        catch (Throwable e) {
                            System.out.println("Error while computing schema element for class '" + className + "'.");
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
                catch (ZipException e) {
                    continue;
                }
                catch (IOException e) {
                    System.out.println("Error while reading Zip file: " + classPathElement);
                    continue;
                }
            }
            File packageDir = new File(classPathElement.getPath().replace("\\", "/") + "/" + this._package.replace('.', '/'));
            if (!packageDir.exists()) continue;
            this.buildFromFiles(packageDir, this._package, true);
        }
    }

    public void buildFromSource(String iSourceDir) throws Exception {
        File packageDir = new File(iSourceDir + "/" + this._package.replace('.', '/'));
        if (!packageDir.exists()) {
            throw new Exception("Package dir " + packageDir + " not found.");
        }
        this.buildFromFiles(packageDir, this._package, false);
        this._built = true;
    }

    private int buildFromFiles(File packageDir, String iPackage, boolean iSearchClassFiles) {
        if (!packageDir.exists()) {
            return 0;
        }
        String[] names = packageDir.list();
        int processed = 0;
        for (int i = 0; i < names.length; ++i) {
            File f = new File(packageDir, names[i]);
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                processed += this.buildFromFiles(new File(packageDir, names[i]), iPackage + "." + names[i], iSearchClassFiles);
                continue;
            }
            if (!names[i].endsWith(iSearchClassFiles ? ".class" : ".java")) continue;
            String className = iPackage + "." + names[i].substring(0, names[i].length() - (iSearchClassFiles ? 6 : 5));
            try {
                Class<?> c = Class.forName(className);
                if (this.getElement(c) == null) continue;
                ++processed;
                continue;
            }
            catch (Throwable e) {
                System.out.println("Error while computing schema element for class '" + className + "'.");
                e.printStackTrace();
            }
        }
        return processed;
    }

    public void generateXSD(Document iXmlDoc) {
        int i;
        ISchemaElement[] elements = this.getAllElements();
        Element schemaElt = iXmlDoc.createElement("xs:schema");
        schemaElt.setAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        schemaElt.setAttribute("xmlns", this.getRootPackage());
        schemaElt.setAttribute("targetNamespace", this.getRootPackage());
        ISchema[] imports = this.getUsedSchemas();
        for (int i2 = 0; i2 < imports.length; ++i2) {
            schemaElt.setAttribute("xmlns:" + imports[i2].getName(), imports[i2].getRootPackage());
            Element importNode = iXmlDoc.createElement("xs:import");
            importNode.setAttribute("schemaLocation", imports[i2].getLocator());
            importNode.setAttribute("namespace", imports[i2].getRootPackage());
            schemaElt.appendChild(importNode);
        }
        iXmlDoc.appendChild(schemaElt);
        Element importTypeElt = iXmlDoc.createElement("xs:complexType");
        importTypeElt.setAttribute("name", "__import");
        Element importTypeAttr = iXmlDoc.createElement("xs:attribute");
        importTypeAttr.setAttribute("name", "File");
        importTypeAttr.setAttribute("type", "xs:string");
        importTypeAttr.setAttribute("use", "required");
        importTypeElt.appendChild(importTypeAttr);
        schemaElt.appendChild(importTypeElt);
        System.out.println("Declaring enumerated types...");
        for (i = 0; i < elements.length; ++i) {
            if (elements[i].getType() != 1) continue;
            int nbElts = EnumHelper.getNbOfItems(elements[i].getMappedClass());
            System.out.println(" --> enumeration '" + elements[i].getTagName() + "': " + nbElts + " items");
            Element typeElt = iXmlDoc.createElement("xs:simpleType");
            typeElt.setAttribute("name", elements[i].getTagName());
            this.addComponentDoc(typeElt, elements[i]);
            Element restrictionElt = iXmlDoc.createElement("xs:restriction");
            restrictionElt.setAttribute("base", "xs:string");
            for (int j = 0; j < nbElts; ++j) {
                Element enumElt = iXmlDoc.createElement("xs:enumeration");
                String enumName = EnumHelper.getItemName(elements[i].getMappedClass(), j);
                enumElt.setAttribute("value", enumName);
                restrictionElt.appendChild(enumElt);
                this.addAttributeDoc(enumElt, elements[i], enumName);
            }
            typeElt.appendChild(restrictionElt);
            schemaElt.appendChild(typeElt);
        }
        System.out.println("Declaring substitution groups...");
        for (i = 0; i < elements.length; ++i) {
            if (elements[i].getType() != 2) continue;
            System.out.println(" --> interface '" + elements[i].getTagName() + "'");
            Element ifElt = iXmlDoc.createElement("xs:element");
            ifElt.setAttribute("name", elements[i].getTagName());
            ifElt.setAttribute("abstract", "true");
            schemaElt.appendChild(ifElt);
            this.addComponentDoc(ifElt, elements[i]);
            if (!IXmlImportable.class.isAssignableFrom(elements[i].getMappedClass())) continue;
            Element importElt = iXmlDoc.createElement("xs:element");
            String importEltName = "Import_" + elements[i].getTagName();
            importElt.setAttribute("name", importEltName);
            importElt.setAttribute("substitutionGroup", elements[i].getTagName());
            importElt.setAttribute("type", "__import");
            schemaElt.appendChild(importElt);
        }
        System.out.println("Declaring elements and types...");
        for (i = 0; i < elements.length; ++i) {
            ISchemaElement ref;
            MappedField fieldMapping;
            int j;
            ISchemaElement superType;
            if (elements[i].getType() != 4) continue;
            System.out.println(" --> element '" + elements[i].getTagName() + "' and type '_" + elements[i].getTagName() + "'");
            boolean isAbstract = (elements[i].getMappedClass().getModifiers() & 0x400) != 0;
            XmlMappings mappings = XmlMappings.getMappings(elements[i].getMappedClass(), !this._manageInheritance);
            for (int j2 = 0; j2 < mappings.getMappingErrors().length; ++j2) {
                System.err.println(mappings.getMappingErrors()[j2].getMessage());
            }
            MappedField[] contentMappings = mappings.getMappings(8);
            MappedField[] childMappings = mappings.getMappings(2);
            MappedField[] collectedMappings = mappings.getMappings(4);
            MappedField[] attrMappings = mappings.getMappings(1);
            boolean hasContentMappings = contentMappings.length > 0;
            Element typeElt = iXmlDoc.createElement("xs:complexType");
            schemaElt.appendChild(typeElt);
            typeElt.setAttribute("name", "_" + elements[i].getTagName());
            if (isAbstract) {
                typeElt.setAttribute("abstract", "true");
            }
            if (hasContentMappings) {
                typeElt.setAttribute("mixed", "true");
            }
            if ((superType = elements[i].getSuperType()) != null) {
                Element cc = iXmlDoc.createElement("xs:complexContent");
                typeElt.appendChild(cc);
                Element ext = iXmlDoc.createElement("xs:extension");
                ext.setAttribute("base", this.getPrefixAndTag(superType, true));
                cc.appendChild(ext);
                typeElt = ext;
            }
            Element sequence = null;
            for (j = 0; j < childMappings.length; ++j) {
                fieldMapping = childMappings[j];
                if (sequence == null) {
                    sequence = iXmlDoc.createElement("xs:sequence");
                    typeElt.appendChild(sequence);
                }
                Element eltNode = iXmlDoc.createElement("xs:element");
                eltNode.setAttribute("name", fieldMapping.getName());
                eltNode.setAttribute("minOccurs", fieldMapping.isUseRequired() ? "1" : "0");
                eltNode.setAttribute("maxOccurs", "1");
                sequence.appendChild(eltNode);
                this.addAttributeDoc(eltNode, elements[i], fieldMapping.getName());
                Element ctNode = iXmlDoc.createElement("xs:complexType");
                eltNode.appendChild(ctNode);
                Element seqNode = iXmlDoc.createElement("xs:sequence");
                ctNode.appendChild(seqNode);
                Element eltChild = iXmlDoc.createElement("xs:element");
                ISchemaElement ref2 = this._manager.getElement(fieldMapping.getBaseClass());
                eltChild.setAttribute("ref", this.getPrefixAndTag(ref2, false));
                eltChild.setAttribute("minOccurs", String.valueOf(fieldMapping.getMinOccurs()));
                eltChild.setAttribute("maxOccurs", fieldMapping.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : String.valueOf(fieldMapping.getMaxOccurs()));
                seqNode.appendChild(eltChild);
            }
            for (j = 0; j < collectedMappings.length; ++j) {
                fieldMapping = collectedMappings[j];
                if (sequence == null) {
                    sequence = iXmlDoc.createElement("xs:sequence");
                    typeElt.appendChild(sequence);
                }
                Element eltChild = iXmlDoc.createElement("xs:element");
                ref = this._manager.getElement(fieldMapping.getBaseClass());
                eltChild.setAttribute("ref", this.getPrefixAndTag(ref, false));
                eltChild.setAttribute("minOccurs", String.valueOf(fieldMapping.getMinOccurs()));
                eltChild.setAttribute("maxOccurs", fieldMapping.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : String.valueOf(fieldMapping.getMaxOccurs()));
                sequence.appendChild(eltChild);
                this.addAttributeDoc(eltChild, elements[i], fieldMapping.getName());
            }
            if (hasContentMappings && sequence == null) {
                sequence = iXmlDoc.createElement("xs:sequence");
                typeElt.appendChild(sequence);
                Element any = iXmlDoc.createElement("xs:any");
                any.setAttribute("minOccurs", "0");
                any.setAttribute("maxOccurs", "unbounded");
                sequence.appendChild(any);
            }
            for (int j3 = 0; j3 < attrMappings.length; ++j3) {
                fieldMapping = attrMappings[j3];
                Element attr = iXmlDoc.createElement("xs:attribute");
                attr.setAttribute("name", fieldMapping.getName());
                attr.setAttribute("use", fieldMapping.isUseRequired() ? "required" : "optional");
                typeElt.appendChild(attr);
                if (String.class.isAssignableFrom(fieldMapping.getBaseClass())) {
                    attr.setAttribute("type", "xs:string");
                } else if (Integer.TYPE.isAssignableFrom(fieldMapping.getBaseClass()) || Integer.class.isAssignableFrom(fieldMapping.getBaseClass())) {
                    attr.setAttribute("type", "xs:int");
                } else if (Boolean.TYPE.isAssignableFrom(fieldMapping.getBaseClass()) || Boolean.class.isAssignableFrom(fieldMapping.getBaseClass())) {
                    attr.setAttribute("type", "xs:boolean");
                } else if (IEnumeration.class.isAssignableFrom(fieldMapping.getBaseClass()) || Boolean.class.isAssignableFrom(fieldMapping.getBaseClass())) {
                    ref = this._manager.getElement(fieldMapping.getBaseClass());
                    attr.setAttribute("type", this.getPrefixAndTag(ref, false));
                } else {
                    System.out.println("Unsupported attribute type: '" + fieldMapping.getBaseClass() + "'");
                }
                this.addAttributeDoc(attr, elements[i], fieldMapping.getName());
            }
            Element elt = iXmlDoc.createElement("xs:element");
            elt.setAttribute("name", elements[i].getTagName());
            elt.setAttribute("type", "_" + elements[i].getTagName());
            if (isAbstract) {
                elt.setAttribute("abstract", "true");
            }
            this.addComponentDoc(elt, elements[i]);
            ISchemaElement[] substGroups = elements[i].getSubstitutionGroups();
            if (substGroups != null && substGroups.length > 0) {
                if (substGroups.length > 1) {
                    System.out.println("Warning: class '" + elements[i].getMappedClass().getName() + "' has more than one interface. Only the first one will be declared as substitution group: " + substGroups[0].getMappedClass().getName());
                }
                elt.setAttribute("substitutionGroup", this.getPrefixAndTag(substGroups[0], false));
            }
            schemaElt.appendChild(elt);
        }
    }

    private boolean addComponentDoc(Element iElement, ISchemaElement iElt) {
        String doc = MessagesHelper.getComponentDetails(Locale.getDefault(), iElt.getMappedClass());
        if (doc == null) {
            return false;
        }
        Element annotation = iElement.getOwnerDocument().createElement("xs:annotation");
        iElement.appendChild(annotation);
        Element documentation = iElement.getOwnerDocument().createElement("xs:documentation");
        annotation.appendChild(documentation);
        CDATASection cdata = iElement.getOwnerDocument().createCDATASection(doc);
        documentation.appendChild(cdata);
        return true;
    }

    private boolean addAttributeDoc(Element iElement, ISchemaElement iElt, String iAttributeName) {
        String doc = MessagesHelper.getAttributeDetails(Locale.getDefault(), iElt.getMappedClass(), iAttributeName);
        if (doc == null) {
            return false;
        }
        Element annotation = iElement.getOwnerDocument().createElement("xs:annotation");
        iElement.appendChild(annotation);
        Element documentation = iElement.getOwnerDocument().createElement("xs:documentation");
        annotation.appendChild(documentation);
        CDATASection cdata = iElement.getOwnerDocument().createCDATASection(doc);
        documentation.appendChild(cdata);
        return true;
    }

    private String getPrefixAndTag(ISchemaElement iElt, boolean iAsType) {
        if (iAsType && iElt.getType() == 4) {
            if (iElt.getSchema() == this || iElt.getSchema().getName() == null) {
                return "_" + iElt.getTagName();
            }
            return iElt.getSchema().getName() + ":_" + iElt.getTagName();
        }
        if (iElt.getSchema() == this || iElt.getSchema().getName() == null) {
            return iElt.getTagName();
        }
        return iElt.getSchema().getName() + ":" + iElt.getTagName();
    }

    public void buildFromXsd(InputStream iInput) throws Exception {
        Document doc = null;
        DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        DocumentBuilder parser = parserFactory.newDocumentBuilder();
        doc = parser.parse(iInput);
        this.buildFromXsd(doc);
    }

    private static String getPrefix(String iXsdFile) {
        String prefix = iXsdFile;
        int idx = prefix.lastIndexOf(47);
        if (idx >= 0) {
            prefix = prefix.substring(idx + 1);
        }
        if ((idx = prefix.indexOf(46)) >= 0) {
            prefix = prefix.substring(0, idx);
        }
        return prefix;
    }

    public void buildFromXsd(Document iDoc) {
        Element schemaElt = iDoc.getDocumentElement();
        this._package = schemaElt.getAttribute("targetNamespace");
        NodeList imports = schemaElt.getElementsByTagName("import");
        for (int i = 0; i < imports.getLength(); ++i) {
            if (!(imports.item(i) instanceof Element)) continue;
            Element importElt = (Element)imports.item(i);
            String importPackage = importElt.getAttribute("namespace");
            String importLocation = importElt.getAttribute("schemaLocation");
            String importPrefix = null;
            NamedNodeMap attributes = schemaElt.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Attr attr;
                if (!(attributes.item(j) instanceof Attr) || !"xmlns".equals((attr = (Attr)attributes.item(j)).getPrefix()) || !importPackage.equals(attr.getValue())) continue;
                importPrefix = attr.getLocalName();
                break;
            }
            if (importPrefix == null) {
                importPrefix = SchemaImpl.getPrefix(importLocation);
            }
            this._manager.declareSchema(importPrefix, importLocation, importPackage);
        }
        NodeList children = schemaElt.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element node;
            if (!(children.item(i) instanceof Element) || !(node = (Element)children.item(i)).getLocalName().equals("simpleType") && !node.getLocalName().equals("element")) continue;
            try {
                Class<?> c = Class.forName(this._package + "." + node.getAttribute("name"));
                this.getElement(c);
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }

    private static class SchemaElement
    implements ISchemaElement {
        private Class _class;
        private int _type;
        private String _tag;
        private ISchema _schema;
        private ISchemaElement[] _substitutionGroups;
        private ISchemaElement _superClass;

        private SchemaElement() {
        }

        public Class getMappedClass() {
            return this._class;
        }

        public ISchema getSchema() {
            return this._schema;
        }

        public ISchemaElement[] getSubstitutionGroups() {
            return this._substitutionGroups;
        }

        public ISchemaElement getSuperType() {
            return this._superClass;
        }

        public String getTagName() {
            return this._tag;
        }

        public int getType() {
            return this._type;
        }

        public String toString() {
            return "SchemaElement[" + (this._type == 4 ? "ELT" : (this._type == 1 ? "ENUM" : "INTERF")) + ":" + this.getMappedClass().getName() + "]";
        }

        static /* synthetic */ ISchemaElement[] access$502(SchemaElement x0, ISchemaElement[] x1) {
            x0._substitutionGroups = x1;
            return x1;
        }
    }
}

