/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.xmlmapping.schema;

import com.ebm_ws.infra.xmlmapping.impl.SchemaImpl;
import com.ebm_ws.infra.xmlmapping.schema.ISchema;
import com.ebm_ws.infra.xmlmapping.schema.ISchemaElement;
import java.util.Hashtable;
import java.util.Vector;

public class SchemasManager {
    private Vector _schemas = new Vector();
    private Hashtable _interface2Implementors = new Hashtable();

    public ISchema declareSchema(String iName, String iLocator, String iPackage) {
        ISchema schema = this.getSchema(iPackage);
        if (schema == null) {
            schema = new SchemaImpl(this, iName, iLocator, iPackage);
            this._schemas.addElement(schema);
        }
        return schema;
    }

    public ISchema getSchema(String iPackage) {
        for (int i = 0; i < this._schemas.size(); ++i) {
            ISchema schema = (ISchema)this._schemas.elementAt(i);
            if (!iPackage.equals(schema.getRootPackage())) continue;
            return schema;
        }
        return null;
    }

    public void buildAllFromSource(String iSourceRootDir) throws Exception {
        for (int i = 0; i < this._schemas.size(); ++i) {
            SchemaImpl schema = (SchemaImpl)this._schemas.elementAt(i);
            schema.buildFromSource(iSourceRootDir);
        }
    }

    public void buildAllFromClassPath() throws Exception {
        for (int i = 0; i < this._schemas.size(); ++i) {
            SchemaImpl schema = (SchemaImpl)this._schemas.elementAt(i);
            schema.buildFromClassPath();
        }
    }

    public ISchema[] getAllSchemas() {
        Object[] ret = new ISchema[this._schemas.size()];
        this._schemas.copyInto(ret);
        return ret;
    }

    public ISchemaElement getElement(Class iClass) {
        SchemaImpl schema = (SchemaImpl)this.getDeclaringSchema(iClass);
        if (schema == null) {
            return null;
        }
        return schema.getElement(iClass);
    }

    public ISchemaElement[] getAllImplementors(Class iSubstitutionGroup) {
        Object[] implementors = (ISchemaElement[])this._interface2Implementors.get(iSubstitutionGroup);
        if (implementors == null) {
            Vector<ISchemaElement> implementorsVect = new Vector<ISchemaElement>();
            for (int i = 0; i < this._schemas.size(); ++i) {
                ISchema schema = (ISchema)this._schemas.elementAt(i);
                ISchemaElement[] elements = schema.getAllElements();
                for (int j = 0; j < elements.length; ++j) {
                    if (elements[j].getMappedClass().isInterface() || (elements[j].getMappedClass().getModifiers() & 0x400) != 0 || !iSubstitutionGroup.isAssignableFrom(elements[j].getMappedClass())) continue;
                    implementorsVect.addElement(elements[j]);
                }
            }
            implementors = new ISchemaElement[implementorsVect.size()];
            implementorsVect.copyInto(implementors);
            this._interface2Implementors.put(iSubstitutionGroup, implementors);
        }
        return implementors;
    }

    public ISchema getDeclaringSchema(Class iClass) {
        String classname = iClass.getName();
        int lastDotIdx = classname.lastIndexOf(46);
        String pack = classname.substring(0, lastDotIdx);
        if (this._schemas != null) {
            for (int i = 0; i < this._schemas.size(); ++i) {
                ISchema schema = (ISchema)this._schemas.elementAt(i);
                if (!pack.startsWith(schema.getRootPackage())) continue;
                return schema;
            }
        }
        return null;
    }
}

