/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.xmlmapping.utils;

import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import com.ebm_ws.infra.xmlmapping.utils.XmlMappingException;
import java.lang.reflect.Field;

public class MappedField {
    private static final String CONTENT_FIELD = "_xmlcontent";
    private static final String PARENT_FIELD = "_xmlparent";
    private static final String ANCESTOR_FIELD = "_xmlancestor";
    private static final String ROOT_FIELD = "_xmlroot";
    private static final String ATTR_PREFIX = "_xmlattr_";
    private static final String NODE_PREFIX = "_xmlnode_";
    private static final String COLLECT_PREFIX = "_xmlcollect_";
    public static final int ATTRIBUTE = 1;
    public static final int CHILD_ELT = 2;
    public static final int COLLECTED_ELT = 4;
    public static final int CONTENT = 8;
    public static final int PARENT = 16;
    public static final int ROOT = 32;
    public static final int ANCESTOR = 64;
    private Field _field;
    private int _type;
    private String _name;
    private int _minOccurs = 1;
    private int _maxOccurs = 1;

    public String toString() {
        if (this._type == 1) {
            return this._field.getName() + ": " + (this._minOccurs == 0 ? "optional" : "required") + " attribute '" + this._name + "' of type " + this._field.getType().getName();
        }
        if (this._type == 8) {
            return this._field.getName() + ": HTML content";
        }
        if (this._type == 16) {
            return this._field.getName() + ": parent node";
        }
        if (this._type == 16) {
            return this._field.getName() + ": root node";
        }
        if (this._field.getType().isArray()) {
            return this._field.getName() + ": " + (this._type == 2 ? "nodes in child '" + this._name + "'" : "collected nodes") + " [" + this._minOccurs + "," + (this._maxOccurs == Integer.MAX_VALUE ? "unbounded" : String.valueOf(this._maxOccurs)) + "] of type " + this._field.getType().getComponentType().getName();
        }
        return this._field.getName() + ": " + (this._minOccurs == 0 ? "optional" : "required") + " " + (this._type == 2 ? "node in child '" + this._name + "'" : "collected node") + " of type " + this._field.getType().getName();
    }

    private static void extractMinMaxInfo(Field field, String iPrefix, MappedField ret) throws XmlMappingException {
        if (field.getType().isArray()) {
            int idx1 = field.getName().indexOf(95, iPrefix.length());
            if (idx1 < 0) {
                throw new XmlMappingException("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': missing 'minOccurs' part.");
            }
            int idx2 = field.getName().indexOf(95, idx1 + 1);
            if (idx2 < 0) {
                throw new XmlMappingException("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': missing 'maxOccurs' part.");
            }
            ret._name = field.getName().substring(idx2 + 1);
            try {
                ret._minOccurs = Integer.parseInt(field.getName().substring(iPrefix.length(), idx1));
            }
            catch (Exception e) {
                throw new XmlMappingException("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': the 'minOccurs' part is not a number.");
            }
            String max = field.getName().substring(idx1 + 1, idx2);
            if ("unbounded".startsWith(max)) {
                ret._maxOccurs = Integer.MAX_VALUE;
            } else {
                try {
                    ret._maxOccurs = Integer.parseInt(max);
                }
                catch (Exception e) {
                    throw new XmlMappingException("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': the 'maxOccurs' part is not a number, nor 'unbounded'.");
                }
            }
        } else {
            int idx = field.getName().indexOf(95, iPrefix.length());
            if (idx < 0) {
                throw new XmlMappingException("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': no 'use' part (required|optional).");
            }
            ret._name = field.getName().substring(idx + 1);
            ret._maxOccurs = 1;
            String use = field.getName().substring(iPrefix.length(), idx);
            if ("required".startsWith(use)) {
                ret._minOccurs = 1;
            } else if ("optional".startsWith(use)) {
                ret._minOccurs = 0;
            } else {
                throw new XmlMappingException("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': 'use' part not in (required|optional).");
            }
        }
    }

    protected static MappedField getXmlMapping(Field field) throws XmlMappingException {
        if (field.getName().startsWith(ATTR_PREFIX)) {
            if (field.getType().isArray()) {
                throw new XmlMappingException("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': mapping to an xmlattr involves the field type is not an array.");
            }
            MappedField ret = new MappedField();
            ret._field = field;
            ret._type = 1;
            MappedField.extractMinMaxInfo(field, ATTR_PREFIX, ret);
            return ret;
        }
        if (field.getName().startsWith(NODE_PREFIX)) {
            MappedField ret = new MappedField();
            ret._field = field;
            ret._type = 2;
            MappedField.extractMinMaxInfo(field, NODE_PREFIX, ret);
            return ret;
        }
        if (field.getName().startsWith(COLLECT_PREFIX)) {
            MappedField ret = new MappedField();
            ret._field = field;
            ret._type = 4;
            MappedField.extractMinMaxInfo(field, COLLECT_PREFIX, ret);
            return ret;
        }
        if (field.getName().equals(CONTENT_FIELD)) {
            if (field.getType() != String.class) {
                throw new XmlMappingException("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': xmlcontent field has to be of type String.");
            }
            MappedField ret = new MappedField();
            ret._field = field;
            ret._type = 8;
            return ret;
        }
        if (field.getName().startsWith(ANCESTOR_FIELD)) {
            MappedField ret = new MappedField();
            ret._field = field;
            ret._type = 64;
            return ret;
        }
        if (field.getName().equals(PARENT_FIELD)) {
            if (!IXmlObject.class.isAssignableFrom(field.getType())) {
                throw new XmlMappingException("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': xmlparent field should necessarily be a subclass of IXmlObject.");
            }
            MappedField ret = new MappedField();
            ret._field = field;
            ret._type = 16;
            return ret;
        }
        if (field.getName().equals(ROOT_FIELD)) {
            if (!IXmlObject.class.isAssignableFrom(field.getType())) {
                throw new XmlMappingException("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': xmlroot field should necessarily be a subclass of IXmlObject.");
            }
            MappedField ret = new MappedField();
            ret._field = field;
            ret._type = 32;
            return ret;
        }
        return null;
    }

    public int getMappingType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public Field getField() {
        return this._field;
    }

    public Class getBaseClass() {
        return this._field.getType().isArray() ? this._field.getType().getComponentType() : this._field.getType();
    }

    public boolean isUseRequired() {
        return this._minOccurs > 0;
    }

    public int getMinOccurs() {
        return this._minOccurs;
    }

    public int getMaxOccurs() {
        return this._maxOccurs;
    }
}

