/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.xmlmapping.utils;

import com.ebm_ws.infra.xmlmapping.utils.MappedField;
import com.ebm_ws.infra.xmlmapping.utils.XmlMappings;
import java.util.Locale;
import java.util.ResourceBundle;
import org.w3c.dom.Element;

public class MessagesHelper {
    private static String getMessage(Locale iLocale, Class iComponentClass, String iKey, String iDefault) {
        for (Class c = iComponentClass; c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                ResourceBundle rb = ResourceBundle.getBundle(c.getName(), iLocale);
                String msg = rb.getString(iKey);
                if (msg == null) continue;
                return msg;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return iDefault;
    }

    public static String getElementName(Locale iLocale, Element iElement) {
        String instName;
        Class<?> c = null;
        try {
            c = Class.forName(iElement.getNamespaceURI() + "." + iElement.getLocalName());
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        String string = instName = c == null ? null : MessagesHelper.getMessage(iLocale, c, "InstName", null);
        if (instName != null) {
            StringBuffer sb = new StringBuffer();
            int curIdx = 0;
            while (true) {
                int idx1;
                int idx2;
                int n = idx2 = (idx1 = instName.indexOf(37, curIdx)) < 0 ? -1 : instName.indexOf(37, idx1 + 1);
                if (idx2 < 0) {
                    sb.append(instName.substring(curIdx));
                    return sb.toString();
                }
                String mappingName = instName.substring(idx1 + 1, idx2);
                String val = iElement.getAttribute(mappingName);
                if (val != null && val.length() == 0) {
                    val = null;
                }
                if (val == null) break;
                sb.append(instName.substring(curIdx, idx1));
                sb.append(String.valueOf(val));
                curIdx = idx2 + 1;
            }
        }
        return MessagesHelper.getComponentName(iLocale, c);
    }

    public static String getInstanceName(Locale iLocale, Object iObj) {
        String instName = MessagesHelper.getMessage(iLocale, iObj.getClass(), "InstName", null);
        if (instName != null) {
            XmlMappings mappings = XmlMappings.getMappings(iObj.getClass(), true);
            StringBuffer sb = new StringBuffer();
            int curIdx = 0;
            while (true) {
                int idx1;
                int idx2;
                int n = idx2 = (idx1 = instName.indexOf(37, curIdx)) < 0 ? -1 : instName.indexOf(37, idx1 + 1);
                if (idx2 < 0) {
                    sb.append(instName.substring(curIdx));
                    return sb.toString();
                }
                String mappingName = instName.substring(idx1 + 1, idx2);
                MappedField mapping = mappings.getMappingByNameAndType(mappingName, 1);
                if (mapping == null) break;
                Object val = null;
                try {
                    val = mapping.getField().get(iObj);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (val == null) break;
                sb.append(instName.substring(curIdx, idx1));
                sb.append(String.valueOf(val));
                curIdx = idx2 + 1;
            }
        }
        return MessagesHelper.getComponentName(iLocale, iObj.getClass());
    }

    public static String getComponentName(Locale iLocale, Class iComponentClass) {
        String name = MessagesHelper.getMessage(iLocale, iComponentClass, "Name", null);
        if (name != null) {
            return name;
        }
        int idx = iComponentClass.getName().lastIndexOf(46);
        if (idx >= 0) {
            return iComponentClass.getName().substring(idx + 1);
        }
        return iComponentClass.getName();
    }

    public static String getComponentDetails(Locale iLocale, Class iComponentClass) {
        return MessagesHelper.getMessage(iLocale, iComponentClass, "Details", null);
    }

    public static String getAttributeName(Locale iLocale, Class iComponentClass, String iAttribute) {
        return MessagesHelper.getMessage(iLocale, iComponentClass, iAttribute + ".Name", iAttribute);
    }

    public static String getAttributeDetails(Locale iLocale, Class iComponentClass, String iAttribute) {
        return MessagesHelper.getMessage(iLocale, iComponentClass, iAttribute + ".Details", null);
    }
}

