/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.xmlmapping.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XML2HTML {
    private Document doc;
    private PrintWriter writer;
    private int indent = 0;

    public static void main(String[] args) throws ParserConfigurationException, IOException, SAXException {
        if (args.length < 1) {
            System.out.println("Usage: XML2HTML <xml_file> [output file or dir]");
            return;
        }
        File inXmlFile = new File(args[0]);
        if (!inXmlFile.exists()) {
            System.out.println("File [" + args[0] + "] not found.");
            return;
        }
        if (!inXmlFile.isFile()) {
            System.out.println("[" + args[0] + "] is not a file.");
            return;
        }
        File outHtmlFile = null;
        if (args.length > 1) {
            outHtmlFile = new File(args[1]);
        }
        if (outHtmlFile == null) {
            outHtmlFile = new File(inXmlFile.getParentFile(), inXmlFile.getName().replace('.', '_') + ".html");
        } else if (outHtmlFile.exists() && outHtmlFile.isDirectory()) {
            outHtmlFile = new File(outHtmlFile, inXmlFile.getName().replace('.', '_') + ".html");
        }
        Document doc = null;
        DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        parserFactory.setIgnoringComments(false);
        parserFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder parser = parserFactory.newDocumentBuilder();
        FileInputStream in = new FileInputStream(inXmlFile);
        doc = parser.parse(in);
        ((InputStream)in).close();
        new XML2HTML().format(doc, new FileOutputStream(outHtmlFile));
    }

    private void format(Document doc, OutputStream output) {
        this.doc = doc;
        this.writer = new PrintWriter(output);
        this.openHtml();
        this.writeElement(doc.getDocumentElement());
        this.closeHtml();
        this.writer.flush();
        this.writer.close();
    }

    private void openHtml() {
        this.writer.println("<html>");
        this.writer.println("<head>");
        this.writer.println("</head>");
        this.writer.println("<style type='text/css'>");
        this.writer.println("pre.XML {");
        this.writer.println("\tfont-family: courier;");
        this.writer.println("\tfont-size: 10pt;");
        this.writer.println("\tcolor: #3F7F7F;");
        this.writer.println("\tbackground-color: #FFFFFF;");
        this.writer.println("}");
        this.writer.println("span.AttrName {");
        this.writer.println("\tcolor: #7F007F;");
        this.writer.println("}");
        this.writer.println("span.AttrValue {");
        this.writer.println("\tcolor: #2A00FF;");
        this.writer.println("}");
        this.writer.println("span.Comment {");
        this.writer.println("\tcolor: #3F5FBF;");
        this.writer.println("}");
        this.writer.println("span.Text {");
        this.writer.println("\tcolor: #000000;");
        this.writer.println("}");
        this.writer.println("</style>");
        this.writer.println("<body>");
        this.writer.println("<pre class=XML>");
    }

    private void closeHtml() {
        this.writer.println("</pre>");
        this.writer.println("</body>");
        this.writer.println("</html>");
    }

    private void writeIndentation() {
        for (int i = 0; i < this.indent; ++i) {
            this.writer.print("&nbsp;&nbsp;");
        }
    }

    private boolean isEmpty(CharacterData node) {
        return node.getData() == null || node.getData().trim().length() == 0;
    }

    private boolean isMultiLine(CharacterData node) {
        return node.getData() != null && node.getData().trim().indexOf(10) > 0;
    }

    private void writeCData(CDATASection node) {
        this.writer.print("&lt;![CDATA[<span class=Text>");
        this.writer.print(XML2HTML.encode2HTML(node.getData(), false));
        this.writer.print("</span>]]&gt;");
    }

    private void writeComment(Comment node) {
        this.writer.print("<span class=Comment>&lt;!-- ");
        this.writer.print(XML2HTML.encode2HTML(node.getData(), false));
        this.writer.print("--&gt;</span>");
    }

    private void writeText(Text node) {
        this.writer.print("<span class=Text>");
        this.writer.print(XML2HTML.encode2HTML(node.getData(), false));
        this.writer.print("</span>");
    }

    private void writeElement(Element node) {
        Node child;
        int i;
        this.writer.print("&lt;");
        this.writer.print(node.getNodeName());
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                Attr attr = (Attr)attributes.item(i2);
                this.writer.print(" ");
                this.writer.print("<span class=AttrName>");
                this.writer.print(attr.getName());
                this.writer.print("</span>");
                this.writer.print("=");
                this.writer.print("<span class=AttrValue>");
                this.writer.print("\"");
                this.writer.print(attr.getValue());
                this.writer.print("\"");
                this.writer.print("</span>");
            }
        }
        if (!node.hasChildNodes()) {
            this.writer.print("/&gt;");
            return;
        }
        this.writer.print("&gt;");
        NodeList children = node.getChildNodes();
        boolean writeChildrenInline = true;
        int countChildren = 0;
        for (i = 0; writeChildrenInline && i < children.getLength(); ++i) {
            child = children.item(i);
            switch (child.getNodeType()) {
                case 4: {
                    if (this.isEmpty((CharacterData)child)) break;
                    if (this.isMultiLine((CharacterData)child)) {
                        writeChildrenInline = false;
                    }
                    ++countChildren;
                    break;
                }
                case 3: {
                    if (this.isEmpty((CharacterData)child)) break;
                    if (this.isMultiLine((CharacterData)child)) {
                        writeChildrenInline = false;
                    }
                    ++countChildren;
                    break;
                }
                case 1: {
                    writeChildrenInline = false;
                    break;
                }
                case 8: {
                    writeChildrenInline = false;
                }
            }
            if (countChildren <= true) continue;
            writeChildrenInline = false;
        }
        if (!writeChildrenInline) {
            this.writer.println();
        }
        ++this.indent;
        block14: for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            switch (child.getNodeType()) {
                case 4: {
                    if (this.isEmpty((CharacterData)child)) continue block14;
                    if (!writeChildrenInline) {
                        this.writeIndentation();
                    }
                    this.writeCData((CDATASection)child);
                    if (writeChildrenInline) continue block14;
                    this.writer.println();
                    continue block14;
                }
                case 3: {
                    if (this.isEmpty((CharacterData)child)) continue block14;
                    if (!writeChildrenInline) {
                        this.writeIndentation();
                    }
                    this.writeText((Text)child);
                    if (writeChildrenInline) continue block14;
                    this.writer.println();
                    continue block14;
                }
                case 1: {
                    if (!writeChildrenInline) {
                        this.writeIndentation();
                    }
                    this.writeElement((Element)child);
                    if (writeChildrenInline) continue block14;
                    this.writer.println();
                    continue block14;
                }
                case 8: {
                    if (!writeChildrenInline) {
                        this.writeIndentation();
                    }
                    this.writeComment((Comment)child);
                    if (writeChildrenInline) continue block14;
                    this.writer.println();
                }
            }
        }
        --this.indent;
        if (!writeChildrenInline) {
            this.writeIndentation();
        }
        this.writer.print("&lt;/");
        this.writer.print(node.getNodeName());
        this.writer.print("&gt;");
    }

    public static String encode2HTML(String text, boolean iNBSP) {
        int nbChars = text.length();
        StringBuffer sb = new StringBuffer(nbChars);
        block10: for (int i = 0; i < nbChars; ++i) {
            char c = text.charAt(i);
            if (iNBSP && c == ' ') {
                sb.append("&nbsp;");
                continue;
            }
            switch (c) {
                case '\n': {
                    sb.append("<br>");
                    continue block10;
                }
                case '\r': {
                    sb.append(" ");
                    continue block10;
                }
                case '\t': {
                    sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    continue block10;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block10;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block10;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block10;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

