/*
 * Decompiled with CFR 0.152.
 */
package com.ebm_ws.infra.xmlmapping.utils;

import com.ebm_ws.infra.xmlmapping.interfaces.IXmlObject;
import com.ebm_ws.infra.xmlmapping.utils.MappedField;
import com.ebm_ws.infra.xmlmapping.utils.XmlMappingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class XmlMappings {
    private static int JVM_FIELD_ENUM_DIRECTION = 0;
    private static MappedField[] MAPPED_ARRAY_TYPE = new MappedField[0];
    private static Hashtable _class2Mappings = new Hashtable();
    private Constructor _defaultCS;
    private List _mappings;
    private XmlMappingException[] _mappingErrors;

    private static boolean fieldEnumFollowsDeclaration() {
        if (JVM_FIELD_ENUM_DIRECTION == 0) {
            Field[] fields = TestClass.class.getDeclaredFields();
            JVM_FIELD_ENUM_DIRECTION = fields[0].getName().equals("field1") ? 1 : -1;
        }
        return JVM_FIELD_ENUM_DIRECTION == 1;
    }

    private static void addMappings(List mappedFields, Vector mappingErrors, Class iClass, Class iExcludeFrom) {
        if (iClass.getSuperclass() != null && iClass.getSuperclass() != iExcludeFrom) {
            XmlMappings.addMappings(mappedFields, mappingErrors, iClass.getSuperclass(), iExcludeFrom);
        }
        Field[] fields = iClass.getDeclaredFields();
        boolean fieldsInDeclOrder = XmlMappings.fieldEnumFollowsDeclaration();
        for (int i = 0; i < fields.length; ++i) {
            try {
                int idx = fieldsInDeclOrder ? i : fields.length - i - 1;
                MappedField mapping = MappedField.getXmlMapping(fields[idx]);
                if (mapping == null) continue;
                mappedFields.add(mapping);
                continue;
            }
            catch (XmlMappingException e) {
                mappingErrors.addElement(e);
            }
        }
    }

    public static XmlMappings getMappings(Class iClass, boolean iGetInherited) {
        XmlMappings mappings;
        String key = iClass.getName();
        if (iGetInherited) {
            key = "(full)@" + key;
        }
        if ((mappings = (XmlMappings)_class2Mappings.get(key)) == null) {
            ArrayList mappedFields = new ArrayList();
            Vector<XmlMappingException> mappingErrors = new Vector<XmlMappingException>();
            Constructor cs = null;
            if (IXmlObject.class.isAssignableFrom(iClass) && (iClass.getModifiers() & 0x400) == 0) {
                try {
                    cs = iClass.getConstructor(new Class[0]);
                    if (cs == null) {
                        mappingErrors.addElement(new XmlMappingException("Class '" + iClass.getName() + "' has no default constructor."));
                    }
                }
                catch (SecurityException e) {
                    mappingErrors.addElement(new XmlMappingException("SecurityError while retrieveing '" + iClass.getName() + "' default constructor: " + e.getMessage()));
                }
                catch (NoSuchMethodException e) {
                    mappingErrors.addElement(new XmlMappingException("Class '" + iClass.getName() + "' has no default constructor."));
                }
            }
            Class excludeFromClass = iGetInherited ? Object.class : iClass.getSuperclass();
            XmlMappings.addMappings(mappedFields, mappingErrors, iClass, excludeFromClass);
            Object[] errors = new XmlMappingException[mappingErrors.size()];
            mappingErrors.copyInto(errors);
            mappings = new XmlMappings(cs, mappedFields, (XmlMappingException[])errors);
            _class2Mappings.put(key, mappings);
        }
        return mappings;
    }

    private XmlMappings(Constructor iCS, List mappings, XmlMappingException[] mappingErrors) {
        this._defaultCS = iCS;
        this._mappings = mappings;
        this._mappingErrors = mappingErrors;
    }

    public Constructor getDefaultConstructor() {
        return this._defaultCS;
    }

    public XmlMappingException[] getMappingErrors() {
        return this._mappingErrors;
    }

    public MappedField[] getMappings(int iTypes) {
        ArrayList<MappedField> ret = new ArrayList<MappedField>();
        for (int i = 0; i < this._mappings.size(); ++i) {
            MappedField mapping = (MappedField)this._mappings.get(i);
            if ((mapping.getMappingType() & iTypes) == 0) continue;
            ret.add(mapping);
        }
        return ret.toArray(MAPPED_ARRAY_TYPE);
    }

    public MappedField getMappingByNameAndType(String iName, int iType) {
        for (int i = 0; i < this._mappings.size(); ++i) {
            MappedField mapping = (MappedField)this._mappings.get(i);
            if (mapping.getMappingType() != iType || !mapping.getName().equals(iName)) continue;
            return mapping;
        }
        return null;
    }

    public MappedField getCollectedMapping(Class iClass) {
        for (int i = 0; i < this._mappings.size(); ++i) {
            MappedField mapping = (MappedField)this._mappings.get(i);
            if (mapping.getMappingType() != 4 || !mapping.getBaseClass().isAssignableFrom(iClass)) continue;
            return mapping;
        }
        return null;
    }

    private static class TestClass {
        private Object field1;
        private Object field2;

        private TestClass() {
        }
    }
}

