/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.ow2.choreos.chors.datamodel.Choreography;
import org.ow2.choreos.chors.datamodel.ChoreographySpec;

public class ChorRegistry {
    private static ChorRegistry instance = new ChorRegistry();
    private Map<String, Choreography> chors = new ConcurrentHashMap<String, Choreography>();
    private AtomicInteger counter = new AtomicInteger();

    private ChorRegistry() {
    }

    public static ChorRegistry getInstance() {
        return instance;
    }

    public String create(ChoreographySpec chorSpec) {
        String id = Integer.toString(this.counter.incrementAndGet());
        Choreography chor = new Choreography();
        chor.setId(id);
        chor.setChoreographySpec(chorSpec);
        this.chors.put(id, chor);
        return id;
    }

    public Choreography get(String chorId) {
        return this.chors.get(chorId);
    }
}

