/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors.bus;

import java.util.List;
import org.ow2.choreos.chors.bus.BusHandler;
import org.ow2.choreos.chors.bus.EasyESBNode;
import org.ow2.choreos.chors.bus.EasyESBNodeImpl;
import org.ow2.choreos.chors.bus.NoBusAvailableException;
import org.ow2.choreos.nodes.ConfigNotAppliedException;
import org.ow2.choreos.nodes.NodeNotFoundException;
import org.ow2.choreos.nodes.NodeNotUpgradedException;
import org.ow2.choreos.nodes.NodePoolManager;
import org.ow2.choreos.nodes.datamodel.Config;
import org.ow2.choreos.nodes.datamodel.Node;

class SimpleBusHandler
implements BusHandler {
    private static final String EASY_ESB_RECIPE = "easyesb";
    private NodePoolManager npm;

    public SimpleBusHandler(NodePoolManager npm) {
        this.npm = npm;
    }

    SimpleBusHandler(NodePoolManager npm, int waitStep) {
        this.npm = npm;
    }

    @Override
    public EasyESBNode retrieveBusNode() throws NoBusAvailableException {
        String endpoint = null;
        try {
            List nodes = this.npm.applyConfig(new Config(EASY_ESB_RECIPE));
            this.npm.upgradeNode(((Node)nodes.get(0)).getId());
            endpoint = this.getEndpoint(((Node)nodes.get(0)).getIp());
        }
        catch (ConfigNotAppliedException e) {
            throw new NoBusAvailableException();
        }
        catch (NodeNotUpgradedException e) {
            throw new NoBusAvailableException();
        }
        catch (NodeNotFoundException e) {
            throw new NoBusAvailableException();
        }
        return new EasyESBNodeImpl(endpoint);
    }

    private String getEndpoint(String nodeIp) {
        return "http://" + nodeIp + ":8180/services/adminExternalEndpoint";
    }
}

