/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chors.context;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.ow2.choreos.chors.context.ContextNotSentException;
import org.ow2.choreos.chors.context.ContextSender;

public class SoapContextSender
implements ContextSender {
    private String parseNamespace(String endpoint) throws XMLStreamException, IOException {
        String wsdl = this.getWsdl(endpoint);
        URL url = new URL(wsdl);
        InputStreamReader streamReader = new InputStreamReader(url.openStream());
        BufferedReader wsdlInputStream = new BufferedReader(streamReader);
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader reader = xmlInputFactory.createXMLEventReader(wsdlInputStream);
        String namespace = "";
        while (reader.hasNext()) {
            StartElement element;
            String elementName;
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement() || !"definitions".equals(elementName = (element = event.asStartElement()).getName().getLocalPart())) continue;
            QName qname = new QName("targetNamespace");
            namespace = element.getAttributeByName(qname).getValue();
            break;
        }
        reader.close();
        return namespace;
    }

    private String getWsdl(String endpoint) {
        String slashLess = endpoint.endsWith("/") ? endpoint.substring(0, endpoint.length() - 1) : endpoint;
        return String.valueOf(slashLess) + "?wsdl";
    }

    @Override
    public void sendContext(String serviceEndpoint, String partnerRole, String partnerName, List<String> partnerEndpoints) throws ContextNotSentException {
        try {
            SOAPConnectionFactory sfc = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = sfc.createConnection();
            MessageFactory mf = MessageFactory.newInstance();
            SOAPMessage sm = mf.createMessage();
            SOAPEnvelope envelope = sm.getSOAPPart().getEnvelope();
            String namespace = this.parseNamespace(serviceEndpoint);
            envelope.addNamespaceDeclaration("pre", namespace);
            SOAPHeader sh = sm.getSOAPHeader();
            SOAPBody sb = sm.getSOAPBody();
            sh.detachNode();
            QName bodyName = new QName("setInvocationAddress");
            SOAPBodyElement bodyElement = sb.addBodyElement(bodyName);
            bodyElement.setPrefix("pre");
            QName role = new QName("arg0");
            SOAPElement quotation1 = bodyElement.addChildElement(role);
            quotation1.addTextNode(partnerRole);
            QName name = new QName("arg1");
            SOAPElement quotation2 = bodyElement.addChildElement(name);
            quotation2.addTextNode(partnerRole);
            for (String partnerEndpoint : partnerEndpoints) {
                QName address = new QName("arg2");
                SOAPElement quotation3 = bodyElement.addChildElement(address);
                quotation3.addTextNode(partnerEndpoint);
            }
            if (serviceEndpoint.trim().endsWith("/")) {
                serviceEndpoint = serviceEndpoint.substring(0, serviceEndpoint.length() - 1);
            }
            URL endpoint = new URL(serviceEndpoint);
            connection.call(sm, (Object)endpoint);
        }
        catch (Exception e) {
            throw new ContextNotSentException(serviceEndpoint, partnerRole, partnerName, partnerEndpoints);
        }
    }

    private void printSOAPMessage(SOAPMessage sm) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamResult result = new StreamResult(System.out);
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            Source sourceContent = sm.getSOAPPart().getContent();
            transformer.transform(sourceContent, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        System.out.println();
    }
}

