/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chef;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChefNode {
    private String name;
    private String environment;
    private String fqdn;
    private String ip;
    private List<String> runList;
    private List<String> roles;
    private List<String> recipes;
    private String platform;

    public boolean hasRecipeOnRunlist(String recipe) {
        for (String entry : this.runList) {
            if (!entry.contains(recipe)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getFqdn() {
        return this.fqdn;
    }

    public void setFqdn(String fqdn) {
        this.fqdn = fqdn;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public List<String> getRunList() {
        return this.runList;
    }

    public void setRunList(List<String> runList) {
        this.runList = runList;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public List<String> getRecipes() {
        return this.recipes;
    }

    public void setRecipes(List<String> recipes) {
        this.recipes = recipes;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChefNode other = (ChefNode)obj;
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "ChefNode [name=" + this.name + ", ip=" + this.ip + ", runList=" + this.runList + ", roles=" + this.roles + ", recipes=" + this.recipes + "]";
    }

    public List<String> getSimpleRunList() {
        Pattern RUNLIST_ITEM = Pattern.compile("[a-z]+\\[(.+?(::.+?)?)\\]");
        ArrayList<String> simpleRunList = new ArrayList<String>();
        for (String item : this.runList) {
            Matcher matcher = RUNLIST_ITEM.matcher(item);
            if (!matcher.matches()) continue;
            simpleRunList.add(matcher.group(1));
        }
        return simpleRunList;
    }
}

