/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.ow2.choreos.utils.CommandLineException;

public class CommandLine {
    private static Logger logger = Logger.getLogger(CommandLine.class);

    public static String run(String command) throws CommandLineException {
        return CommandLine.run(command, false);
    }

    public static String run(String command, boolean verbose) throws CommandLineException {
        return CommandLine.run(command, ".", verbose);
    }

    public static String run(String command, String workingDirectory) throws CommandLineException {
        return CommandLine.run(command, workingDirectory, false);
    }

    public static String run(String command, String workingDirectory, boolean verbose) throws CommandLineException {
        String commandReturn = "";
        File wd = new File(workingDirectory);
        try {
            String line;
            if (verbose) {
                logger.info((Object)command);
            }
            Process p = Runtime.getRuntime().exec(command, null, wd);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = in.readLine()) != null) {
                commandReturn = commandReturn + line + '\n';
                if (!verbose) continue;
                logger.info((Object)commandReturn);
            }
            try {
                int status = p.waitFor();
                if (status > 0) {
                    throw new CommandLineException("Command failed: " + command);
                }
            }
            catch (InterruptedException e) {
                throw new CommandLineException("Command failed: " + command);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Error while executing " + command));
            throw new CommandLineException("Command failed: " + command);
        }
        return commandReturn;
    }
}

