/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chef.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.choreos.chef.ChefNode;

public class ShowNodeParser {
    private Pattern SIMPLE = Pattern.compile("[a-zA-Z ]+: +(.*)");
    private Pattern RUNLIST_ITEM = Pattern.compile("[a-z]+\\[.+?(::.+?)?\\]");
    private Pattern RECIPES_ITEM = Pattern.compile("[:,] +([^,]+(::[^,]+?)?)");

    public ChefNode parse(String output) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(output));
        ChefNode node = new ChefNode();
        String line = reader.readLine();
        Matcher matcher = this.SIMPLE.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        node.setName(matcher.group(1));
        line = reader.readLine();
        matcher = this.SIMPLE.matcher(line);
        matcher.matches();
        if (!matcher.matches()) {
            return null;
        }
        node.setEnvironment(matcher.group(1));
        line = reader.readLine();
        matcher = this.SIMPLE.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        node.setFqdn(matcher.group(1));
        line = reader.readLine();
        matcher = this.SIMPLE.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        node.setIp(matcher.group(1));
        String runlistLine = reader.readLine();
        node.setRunList(this.parseRunlistLine(runlistLine));
        reader.readLine();
        String recipesLine = reader.readLine();
        node.setRecipes(this.parseRecipesLine(recipesLine));
        line = reader.readLine();
        matcher = this.SIMPLE.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        node.setPlatform(matcher.group(1));
        return node;
    }

    private List<String> parseRunlistLine(String runlistLine) {
        ArrayList<String> runlist = new ArrayList<String>();
        Matcher matcher = this.RUNLIST_ITEM.matcher(runlistLine);
        while (matcher.find()) {
            runlist.add(matcher.group());
        }
        return runlist;
    }

    private List<String> parseRecipesLine(String recipesLine) {
        ArrayList<String> runlist = new ArrayList<String>();
        Matcher matcher = this.RECIPES_ITEM.matcher(recipesLine);
        while (matcher.find()) {
            String item = matcher.group(1).trim();
            if (item.isEmpty()) continue;
            runlist.add(item);
        }
        return runlist;
    }
}

