/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.component.cd.test;

import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easyesb.component.cd.api.CDComponent;
import com.ebmwebsourcing.easyesb.component.cd.client.CDComponentClient;
import com.ebmwebsourcing.easyesb.component.cd.impl.ESBCDFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.esstar.management.UserManagementClient;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.petalslink.abslayer.service.api.Service;
import starter.AirlineGroundStaffMIDStarter;
import starter.AirlineStarter;
import starter.AirtportStarter;
import starter.GroundTransportationCompanyStarter;
import starter.HotelStarter;
import starter.StandAndGateManagementStarter;
import starter.TravelAgencyStarter;
import starter.WeatherForecastServiceStarter;

public class CDRuntimeComponentTest {
    private static ESBCDFactoryImpl factory = new ESBCDFactoryImpl(new String[0]);
    CDComponentClient cdClient;
    UserManagementClient client;
    String endpointService;
    private static String ADMIN_ADDRESS = "http://localhost:8284/services/adminExternalEndpoint";

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException ex) {
            System.out.println("WARNING: Could not open configuration file");
            System.out.println("WARNING: Logging not configured (console output only)");
        }
    }

    private Node createNode(QName name, boolean explorer, String host, int port, int soap_port) throws ESBException {
        ConfigurationImpl confImpl = new ConfigurationImpl(host, port);
        confImpl.getProperties().put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
        Node node = factory.createNode(name, (Configuration)confImpl);
        return node;
    }

    @Ignore
    @Test
    public void testUnblockMessage() {
        try {
            Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), false, "localhost", 9010, 8284);
            QName sn = CDComponent.SERVICE_QNAME;
            String en = null;
            EndpointAddress addr = new EndpointAddress(sn, en, new QueryParam[0]);
            Component cd = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getComponent(ESBUtil.generateURI((EndpointAddress)addr));
            System.out.println("CD QName = " + cd);
            this.client = new UserManagementClient(ADMIN_ADDRESS);
            Service ser = (Service)cd.getDescription().getServices().iterator().next();
            System.out.println("Trying to Expose " + new QName(ser.getQName().getNamespaceURI(), "CDEngine"));
            String cdServiceExternalAddress = this.client.expose(new QName(ser.getQName().getNamespaceURI(), "CDEngine"), null);
            this.cdClient = new CDComponentClient(cdServiceExternalAddress);
            Properties realAddressProp = new Properties();
            realAddressProp.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("partners-noESB-noCD.properties"));
            Properties invocationAddressProp = new Properties();
            invocationAddressProp.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("partners-withESB-noCD.properties"));
            AirlineStarter airlineStarter = new AirlineStarter(realAddressProp.getProperty("airline"), invocationAddressProp, null);
            AirlineGroundStaffMIDStarter airlineGroundStaffMidStarter = new AirlineGroundStaffMIDStarter(realAddressProp.getProperty("airlinegroundstaffmid"), invocationAddressProp);
            WeatherForecastServiceStarter weatherforcasstarter = new WeatherForecastServiceStarter(realAddressProp.getProperty("weatherforecastservice"), invocationAddressProp, 2, 4);
            TravelAgencyStarter travelAgencyStarter = new TravelAgencyStarter(realAddressProp.getProperty("travelagency"), invocationAddressProp);
            AirtportStarter airportStarter = new AirtportStarter(realAddressProp.getProperty("airport"), invocationAddressProp);
            StandAndGateManagementStarter standandgatemanagementStarter = new StandAndGateManagementStarter(realAddressProp.getProperty("standandgatemanagement"), invocationAddressProp);
            HotelStarter hotelStarter = new HotelStarter(realAddressProp.getProperty("hotel"), invocationAddressProp, null);
            GroundTransportationCompanyStarter groundstationcompanyStarter = new GroundTransportationCompanyStarter(realAddressProp.getProperty("groundtransportationcompany"), invocationAddressProp);
            String serviceAddressAirlinecd = this.prepareServiceCDTuple("cdwsdl/cdairline.wsdl", "lts/airline.lts", "http://localhost:8181/airline", new QName("http://services.choreos.org/", "AirlineService"), "CDAirlinePort");
            String serviceAddressAirlineGroundStaffcd = this.prepareServiceCDTuple("cdwsdl/cdairlinegroundstaffmid.wsdl", "lts/airlinegroundstaffmid.lts", "http://localhost:8181/airlinegroundstaffmid", new QName("http://services.choreos.org/", "AirlineGroundStaffMIDService"), "CDAirlineGroundStaffMIDPort");
            String serviceTravelAgencycd = this.prepareServiceCDTuple("cdwsdl/cdtravelagency.wsdl", "lts/travelagency.lts", "http://localhost:8181/travelagency", new QName("http://services.choreos.org/", "TravelAgencyService"), "CDTravelAgencyPort");
            String serviceWeatherForecastcd = this.prepareServiceCDTuple("cdwsdl/cdweatherforecastservice.wsdl", "lts/weatherforecastservice.lts", "http://localhost:8181/weatherforecastservice", new QName("http://services.choreos.org/", "WeatherForecastServiceService"), "CDWeatherForecastServicePort");
            String serviceAirportcd = this.prepareServiceCDTuple("cdwsdl/cdairport.wsdl", "lts/airport.lts", "http://localhost:8181/airport", new QName("http://services.choreos.org/", "AirportService"), "CDAirportPort");
            String serviceHotelcd = this.prepareServiceCDTuple("cdwsdl/cdhotel.wsdl", "lts/hotel.lts", "http://localhost:8181/hotel", new QName("http://services.choreos.org/", "HotelService"), "CDHotelPort");
            String serviceGroundtransportationcompanycd = this.prepareServiceCDTuple("cdwsdl/cdgroundtransportationcompany.wsdl", "lts/groundtransportationcompany.lts", "http://localhost:8181/groundtransportationcompany", new QName("http://services.choreos.org/", "GroundTransportationCompanyService"), "CDGroundTransportationCompanyPort");
            String serviceStandandgatemanagementcd = this.prepareServiceCDTuple("cdwsdl/cdstandandgatemanagement.wsdl", "lts/standandgatemanagement.lts", "http://localhost:8181/standandgatemanagement", new QName("http://services.choreos.org/", "StandandgatemanagementService"), "CDStandandgatemanagementPort");
            Properties invocationAddresses = new Properties();
            invocationAddresses.put("airline", serviceAddressAirlinecd);
            invocationAddresses.put("airlinegroundstaffmid", serviceAddressAirlineGroundStaffcd);
            invocationAddresses.put("travelagency", serviceTravelAgencycd);
            invocationAddresses.put("airport", serviceAirportcd);
            invocationAddresses.put("hotel", serviceHotelcd);
            invocationAddresses.put("groundtransportationcompany", serviceGroundtransportationcompanycd);
            invocationAddresses.put("standandgatemanagement", serviceStandandgatemanagementcd);
            invocationAddresses.put("weatherforecastservice", serviceWeatherForecastcd);
            HashMap<Object, Object> invocationAddressesMap = new HashMap<Object, Object>(invocationAddresses);
            airlineStarter.getServiceAirline().setChoreographyContext(invocationAddressesMap);
            airlineGroundStaffMidStarter.getservice().setChoreographyContext(invocationAddressesMap);
            airportStarter.getservice().setChoreographyContext(invocationAddressesMap);
            groundstationcompanyStarter.getservice().setChoreographyContext(invocationAddressesMap);
            hotelStarter.getservice().setChoreographyContext(invocationAddressesMap);
            standandgatemanagementStarter.getservice().setChoreographyContext(invocationAddressesMap);
            travelAgencyStarter.getservice().setChoreographyContext(invocationAddressesMap);
            weatherforcasstarter.getservice().setChoreographyContext(invocationAddressesMap);
            System.out.println(invocationAddressesMap);
            airlineStarter.getServiceAirline().warnReroute("12", null);
            while (airlineGroundStaffMidStarter.getservice().getNbAmeniyReceiptCalls() < 3) {
                System.out.println(airlineGroundStaffMidStarter.getservice().getNbAmeniyReceiptCalls());
                System.out.println(airlineGroundStaffMidStarter.getservice().getNbBookingReceiptCalls());
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    public String prepareServiceCDTuple(String cdWsdl, String cdLts, String realServiceAddress, QName service, String endpoint) throws URISyntaxException, ManagementException {
        System.out.println("cdWsdl " + cdWsdl + " cdLts" + cdLts + " realServiceAddress" + realServiceAddress + " service " + service + " endpoint" + endpoint);
        File wsdlFile = new File(Thread.currentThread().getContextClassLoader().getResource(cdWsdl).toURI());
        File confFile = new File(Thread.currentThread().getContextClassLoader().getResource(cdLts).toURI());
        EJaxbDeployementReport report = this.cdClient.deploy(confFile, new File[]{wsdlFile});
        System.out.println("CD Deployement report : " + report.getExecutionEnvironmentInformation().getName());
        this.client.bind(realServiceAddress, String.valueOf(realServiceAddress) + "?wsdl");
        this.endpointService = this.client.expose(service, endpoint);
        return this.endpointService;
    }
}

