/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.extensions.wsdl4complexwsdl.test;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlReader;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlWriter;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Import;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.Types;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.w3c.dom.Document;

public class WSDL4ComplexWsdlDescriptorTest
extends TestCase {
    private WSDL4ComplexWsdlReader reader = null;
    private WSDL4ComplexWsdlWriter writer = null;

    public WSDL4ComplexWsdlDescriptorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.reader = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader();
        this.writer = WSDL4ComplexWsdlFactory.newInstance().newWSDLWriter();
    }

    public void testCreateComplexWsdl() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/CustomerSearch.wsdl");
        Description complexDesc = this.reader.read(wsdlURL);
        complexDesc.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)complexDesc);
        WSDL4ComplexWsdlDescriptorTest.assertEquals((int)4, (int)complexDesc.getImportedDocuments().getDocuments().size());
    }

    public void testWriteComplexWsdl() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/CustomerSearch.wsdl");
        Description complexDesc = this.reader.read(wsdlURL);
        complexDesc.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)complexDesc);
        WSDL4ComplexWsdlDescriptorTest.assertEquals((int)4, (int)complexDesc.getImportedDocuments().getDocuments().size());
        Document doc = this.writer.getDocument(complexDesc);
        WSDL4ComplexWsdlDescriptorTest.assertNotNull((Object)doc);
        Description wsdlDesc = complexDesc;
        Map imports = wsdlDesc.deleteImportedDocumentsInWsdl(URI.create("http://localhost:8084/"));
        Assert.assertNotNull((Object)wsdlDesc);
        Document finalDoc = WSDL4ComplexWsdlFactory.newInstance().newWSDLWriter().getDocument(wsdlDesc);
        WSDL4ComplexWsdlDescriptorTest.assertNotNull((Object)finalDoc);
        WSDL4ComplexWsdlDescriptorTest.assertEquals((int)4, (int)imports.values().size());
    }

    public void testReadComplexWsdl() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/otherswsdl/testService.wsdl");
        Description wsdlDescription = this.reader.read(wsdlURL);
        wsdlDescription.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)wsdlDescription);
        Document finalDoc = WSDL4ComplexWsdlFactory.newInstance().newWSDLWriter().getDocument(wsdlDescription);
        Assert.assertNotNull((Object)finalDoc);
        WSDL4ComplexWsdlDescriptorTest.assertEquals((int)1, (int)wsdlDescription.getImportedDocuments().getDocuments().size());
        if (wsdlDescription != null && wsdlDescription.getServices() != null) {
            for (Service service : wsdlDescription.getServices()) {
                if (service.getEndpoint("GetFilesPort") != null) {
                    InterfaceType itf = (InterfaceType)service.getInterface();
                    if (itf != null && itf.getQName() != null) {
                        WSDL4ComplexWsdlDescriptorTest.assertEquals((String)"{http://petals.ow2.org/components/filetransfer/version-2.2}GetFiles", (String)((InterfaceType)service.getInterface()).getQName().toString());
                        continue;
                    }
                    WSDL4ComplexWsdlDescriptorTest.fail((String)"GetFilesPort interface not found");
                    continue;
                }
                WSDL4ComplexWsdlDescriptorTest.fail((String)"GetFilesPort endpoint not found");
            }
        } else {
            WSDL4ComplexWsdlDescriptorTest.fail((String)"GetFilesPort service not found");
        }
    }

    public void testCreateSimpleWsdl() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/testSimpleWSDL.wsdl");
        Description complexDesc = this.reader.read(wsdlURL);
        complexDesc.deleteImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)complexDesc);
        Assert.assertNull((Object)complexDesc.getImportedDocuments());
    }

    public void testReadComplexWsdl2() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/otherswsdl/SnWS.wsdl");
        Description wsdlDescription = this.reader.read(wsdlURL);
        wsdlDescription.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)wsdlDescription);
        Document finalDoc = WSDL4ComplexWsdlFactory.newInstance().newWSDLWriter().getDocument(wsdlDescription);
        Assert.assertNotNull((Object)finalDoc);
        WSDL4ComplexWsdlDescriptorTest.assertEquals((int)1, (int)wsdlDescription.getImportedDocuments().getDocuments().size());
        if (wsdlDescription != null && wsdlDescription.getServices() != null) {
            for (Service service : wsdlDescription.getServices()) {
                if (service.getEndpoint("ServiceQuestionnaireSOAP") != null) {
                    InterfaceType itf = (InterfaceType)service.getInterface();
                    if (itf != null && itf.getQName() != null) {
                        WSDL4ComplexWsdlDescriptorTest.assertEquals((String)"{http://icod/ServiceQuestionnaire/}ServiceQuestionnaire", (String)((InterfaceType)service.getInterface()).getQName().toString());
                        Types types = (Types)wsdlDescription.getTypes();
                        List schemas = types.getSchemas();
                        boolean importedElementFound = false;
                        boolean elementFound = false;
                        for (Schema schema : schemas) {
                            List elements = schema.getElements();
                            for (Element element : elements) {
                                if (element.getQName().getLocalPart().equals("ErreurSysteme")) {
                                    importedElementFound = true;
                                    continue;
                                }
                                if (!element.getQName().getLocalPart().equals("ObtenirQuestionnaireResponse")) continue;
                                elementFound = true;
                            }
                        }
                        WSDL4ComplexWsdlDescriptorTest.assertTrue((boolean)elementFound);
                        WSDL4ComplexWsdlDescriptorTest.assertTrue((boolean)importedElementFound);
                        continue;
                    }
                    WSDL4ComplexWsdlDescriptorTest.fail((String)"ServiceQuestionnaire interface not found");
                    continue;
                }
                WSDL4ComplexWsdlDescriptorTest.fail((String)"ServiceQuestionnaire endpoint not found");
            }
        } else {
            WSDL4ComplexWsdlDescriptorTest.fail((String)"ServiceQuestionnaire service not found");
        }
    }

    public void testReadComplexWsdlDocumentInJBI() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/otherswsdl/testService.wsdl");
        Description wsdlDescription = this.reader.read(wsdlURL);
        wsdlDescription.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)wsdlDescription);
        Document finalDoc = this.writer.getDocument(wsdlDescription);
        finalDoc.setDocumentURI(wsdlURL.toString());
        Assert.assertEquals((String)wsdlURL.toString(), (String)finalDoc.getDocumentURI());
        wsdlDescription = this.reader.read(finalDoc);
        Assert.assertNotNull((Object)wsdlDescription);
    }

    public void testChangeImportLocation() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/otherswsdl/SnWS.wsdl");
        Description wsdlDescription = this.reader.read(wsdlURL);
        wsdlDescription.addImportedDocumentsInWsdl();
        wsdlDescription.deleteImportedDocumentsInWsdl(new File("./src/test/resources/descriptors/otherswsdl/").toURI());
        Types types = (Types)wsdlDescription.getTypes();
        Assert.assertNotNull((String)"No types", (Object)types);
        boolean updatedSchemaFound = false;
        for (Schema schema : types.getSchemas()) {
            if (!"http://icod/ServiceQuestionnaire/".equals(schema.getTargetNamespace())) continue;
            updatedSchemaFound = true;
            Assert.assertNotNull((String)"Import is missing in schema", (Object)schema.getImports());
            Assert.assertEquals((String)"Only one import is expected in the schema", (int)1, (int)schema.getImports().size());
            Assert.assertNotNull((String)"No import of the namespace 'http://icod/SnWS/' in the schema", (Object)schema.getImports("http://icod/SnWS/"));
            Assert.assertEquals((String)"The namespace 'http://icod/SnWS/' is not imported or imported more than once", (int)1, (int)schema.getImports("http://icod/SnWS/").size());
            Import impt = (Import)schema.getImports("http://icod/SnWS/").get(0);
            Assert.assertNotNull((String)"The import is value is null", (Object)impt);
            URI schemaLocationURI = impt.getLocationURI();
            Assert.assertNotNull((String)"No location defined", (Object)schemaLocationURI);
            Assert.assertNotNull((String)"Null scheme part in the new location URI", (Object)schemaLocationURI.getScheme());
            Assert.assertEquals((String)"The scheme part in the new location URI is not the expected one", (String)"file", (String)schemaLocationURI.getScheme());
        }
        WSDL4ComplexWsdlDescriptorTest.assertTrue((String)"Expected schema not found in the WSDL", (boolean)updatedSchemaFound);
    }

    public void testChangeImportLocationHTTP() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/test-update-imports.wsdl");
        Description wsdlDescription = this.reader.read(wsdlURL);
        wsdlDescription.addImportedDocumentsInWsdl();
        wsdlDescription.deleteImportedDocumentsInWsdl(URI.create("myImports/"));
        Types types = (Types)wsdlDescription.getTypes();
        Assert.assertNotNull((String)"No types", (Object)types);
        boolean updatedSchemaFound = false;
        for (Schema schema : types.getSchemas()) {
            if (!"http://icod/ServiceQuestionnaire/".equals(schema.getTargetNamespace())) continue;
            updatedSchemaFound = true;
            Assert.assertNotNull((String)"Import is missing in schema", (Object)schema.getImports());
            Assert.assertEquals((String)"Only one import is expected in the schema", (int)1, (int)schema.getImports().size());
            Assert.assertNotNull((String)"No import of the namespace 'http://www.ebxml.org/BusinessProcess' in the schema", (Object)schema.getImports("http://www.ebxml.org/BusinessProcess"));
            Assert.assertEquals((String)"The namespace 'http://www.ebxml.org/BusinessProcess' is not imported or imported more than once", (int)1, (int)schema.getImports("http://www.ebxml.org/BusinessProcess").size());
            Import impt = (Import)schema.getImports("http://www.ebxml.org/BusinessProcess").get(0);
            Assert.assertNotNull((String)"The import is value is null", (Object)impt);
            URI schemaLocationURI = impt.getLocationURI();
            Assert.assertNotNull((String)"No location defined", (Object)schemaLocationURI);
            Assert.assertNull((String)"No null scheme part in the new location URI", (Object)schemaLocationURI.getScheme());
            Assert.assertEquals((String)"myImports/specs/ebBPSS.xsd", (String)schemaLocationURI.getPath());
        }
        WSDL4ComplexWsdlDescriptorTest.assertTrue((String)"Expected schema not found in the WSDL", (boolean)updatedSchemaFound);
    }

    public void testReadWSDL4ComplexWSDL4BindConsume() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/bindConsumeArtifacts.wsdl");
        Description wsdlDescription = this.reader.read(wsdlURL);
        wsdlDescription.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)wsdlDescription.getImportedDocuments());
        wsdlDescription.deleteImportedDocumentsInWsdl();
        Assert.assertNull((Object)wsdlDescription.getImportedDocuments());
        Assert.assertNotNull((Object)wsdlDescription);
    }

    public void testReadWSDL4ComplexWSDL4Petals() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/person/concreteProcess.wsdl");
        Description wsdlDescription = this.reader.read(wsdlURL);
        wsdlDescription.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)wsdlDescription.getImportedDocuments());
        Document doc = this.writer.getDocument(wsdlDescription);
        System.out.println("[1] -- \n\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
        wsdlDescription = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(doc);
        Map impts = wsdlDescription.deleteImportedDocumentsInWsdl();
        Assert.assertNull((Object)wsdlDescription.getImportedDocuments());
        doc = this.writer.getDocument(wsdlDescription);
        System.out.println("\n[2] -- \n\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
        for (Document d : impts.values()) {
            System.out.println("\n[3] - impt- \n\n" + XMLPrettyPrinter.prettyPrint((Document)d));
        }
        Assert.assertNotNull((Object)wsdlDescription);
    }

    public void testReadWSDL4ComplexWSDL4FT() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/WSDL.wsdl");
        Description wsdlDescription = this.reader.read(wsdlURL);
        wsdlDescription.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)wsdlDescription.getImportedDocuments());
        wsdlDescription.deleteImportedDocumentsInWsdl(new URI("http://localhost:8084/petals/services/convergeruling?wsdl="));
        Assert.assertNull((Object)wsdlDescription.getImportedDocuments());
        Assert.assertEquals((String)"localhost", (String)((Import)((Schema)((Types)wsdlDescription.getTypes()).getSchemas().get(0)).getImports().get(0)).getLocationURI().getHost());
        Assert.assertNotNull((Object)wsdlDescription);
    }

    public void testReadWSDL4ComplexWSDL4FT2() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/WSDL2.wsdl");
        Description wsdlDescription = this.reader.read(wsdlURL);
        wsdlDescription.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)wsdlDescription.getImportedDocuments());
        wsdlDescription.deleteImportedDocumentsInWsdl(new URI("http://localhost:8084/"));
        Assert.assertNull((Object)wsdlDescription.getImportedDocuments());
        Assert.assertEquals((String)"localhost", (String)((Import)((Schema)((Types)wsdlDescription.getTypes()).getSchemas().get(0)).getImports().get(0)).getLocationURI().getHost());
        Assert.assertNotNull((Object)wsdlDescription);
    }

    public void testReadWSDL4ComplexWSDL4Test1RemoteProcess() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("descriptors/test1/Label_1.0.wsdl");
        Description wsdlDescription = this.reader.read(wsdlURL);
        wsdlDescription.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)wsdlDescription.getImportedDocuments());
        wsdlDescription.deleteImportedDocumentsInWsdl();
        Assert.assertNull((Object)wsdlDescription.getImportedDocuments());
        Assert.assertNotNull((Object)wsdlDescription);
    }

    public void testReadWSDL4ComplexWSDL4RedefineProcess() throws URISyntaxException, WSDLException, IOException {
        URL wsdlURL = Thread.currentThread().getContextClassLoader().getResource("wsdl/Admin.wsdl");
        Description wsdlDescription = this.reader.read(wsdlURL);
        wsdlDescription.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)wsdlDescription.getImportedDocuments());
        Map map = wsdlDescription.deleteImportedDocumentsInWsdl(URI.create("http://localhost:8085/services/"));
        Assert.assertNull((Object)wsdlDescription.getImportedDocuments());
        WSDL4ComplexWsdlDescriptorTest.assertEquals((int)2, (int)map.values().size());
        Assert.assertNotNull((Object)wsdlDescription);
    }
}

