/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl;

import java.util.Iterator;

import javax.xml.bind.JAXBElement;

import org.ow2.easywsdl.extensions.complexwsdl.ImportedDocuments;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlElement;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl.inout.WSDL4ComplexWsdlReaderImpl;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLElement;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.org.w3.ns.wsdl.DescriptionType;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TDefinitions;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TExtensibleDocumented;
import org.w3c.dom.Element;

/**
 * Abstract super class for all WSDL Elements, providing some basic
 * common functionality.
 */

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDL4ComplexWsdlElementImpl<T extends WSDLElement> implements WSDL4ComplexWsdlElement {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	protected T tag;

	private org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.ImportedDocuments imptDocs;
	
	private static WSDL4ComplexWsdlReaderImpl reader = null;
	private static WSDL4ComplexWsdlException readerException = null;
	
	static {
		try {
			reader = new WSDL4ComplexWsdlReaderImpl();
		} catch (WSDL4ComplexWsdlException e) {
			readerException = e;
		}
	}
	
	public static WSDL4ComplexWsdlReaderImpl getWSDLReader() throws WSDL4ComplexWsdlException {
		if(readerException != null) {
			throw readerException;
		}
		return reader;
	}
	
	public WSDL4ComplexWsdlElementImpl(final T t) throws WSDL4ComplexWsdlException {
		this.tag = t;
		try {
			getImportedDocumentsInAnyDescription();
		} catch (WSDLException e) {
			throw new WSDL4ComplexWsdlException(e);
		}
	}


	private void getImportedDocumentsInAnyDescription() throws WSDL4ComplexWsdlException,
	WSDLException {
		// get partner link in description
		if(this.tag instanceof Description) {
			if(((AbstractWSDLElementImpl)this.tag).getModel() instanceof DescriptionType) {
				// wsdl 2.0
				Iterator<Object> it = ((DescriptionType)((AbstractWSDLElementImpl)this.tag).getModel()).getImportOrIncludeOrTypes().iterator();
				Object part = null;
				while (it.hasNext()) {
					part = it.next();
					// get partner link type
					if (part instanceof Element) {
						if((((Element)part).getLocalName().equals("importedDocuments"))&&(((Element)part).getNamespaceURI().equals("http://petals.ow2.org/wsdlExtensions"))) {
							WSDL4ComplexWsdlReaderImpl reader = getWSDLReader();
							JAXBElement<ImportedDocuments> jaxbPlt = reader.convertElement2ImportedDocuments((Element)part);

							// change element by jaxb element
							((DescriptionType)((AbstractWSDLElementImpl)this.tag).getModel()).getImportOrIncludeOrTypes().remove(part);
							((DescriptionType)((AbstractWSDLElementImpl)this.tag).getModel()).getImportOrIncludeOrTypes().add(jaxbPlt);

							// create partnerLinkType
							this.imptDocs  = new ImportedDocumentsImpl(jaxbPlt.getValue(), (Description) this.tag);
						}
					}
				}
			} else if(((AbstractWSDLElementImpl)this.tag).getModel() instanceof TDefinitions) {
				// wsdl 1.1
				Iterator<Object> it = ((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().iterator();
				Object part = null;
				while (it.hasNext()) {
					part = it.next();
					// get partner link type
					if (part instanceof Element) {
						if((((Element)part).getLocalName().equals("importedDocuments"))&&(((Element)part).getNamespaceURI().equals("http://petals.ow2.org/wsdlExtensions"))) {
							WSDL4ComplexWsdlReaderImpl reader = getWSDLReader();
							JAXBElement<ImportedDocuments> jaxbPlt = reader.convertElement2ImportedDocuments((Element)part);

							// change element by jaxb element
							((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().remove(part);
							((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().add(jaxbPlt);

							// create importedDocuments
							this.imptDocs = new ImportedDocumentsImpl(jaxbPlt.getValue(), (Description) this.tag);
						}
					} else if((part instanceof JAXBElement)&&(((JAXBElement)part).getValue() instanceof ImportedDocuments)) {
						this.imptDocs = new ImportedDocumentsImpl((ImportedDocuments) ((JAXBElement)part).getValue(), (Description) this.tag);
					}
				}
			} 
		}
	}

	private void setImportedDocumentsInAnyDescription(ImportedDocuments imptDocument) throws WSDL4ComplexWsdlException {
		try {
			// get partner link in description
			if(this.tag instanceof Description) {
				if(((AbstractWSDLElementImpl)this.tag).getModel() instanceof DescriptionType) {
					// wsdl 2.0
					Iterator<Object> it = ((DescriptionType)((AbstractWSDLElementImpl)this.tag).getModel()).getImportOrIncludeOrTypes().iterator();
					Object part = null;
					while (it.hasNext()) {
						part = it.next();
						// get partner link type
						if (part instanceof Element) {
							if((((Element)part).getLocalName().equals("importedDocuments"))&&(((Element)part).getNamespaceURI().equals("http://petals.ow2.org/wsdlExtensions"))) {
								
								// change element by jaxb element
								((DescriptionType)((AbstractWSDLElementImpl)this.tag).getModel()).getImportOrIncludeOrTypes().remove(part);
								if(imptDocument != null) {
									((DescriptionType)((AbstractWSDLElementImpl)this.tag).getModel()).getImportOrIncludeOrTypes().add(imptDocument);
								}
								it = ((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().iterator();
							}
						} else if((part instanceof JAXBElement)&&(((JAXBElement)part).getValue() instanceof ImportedDocuments)) {
							if(imptDocument != null) {
								((JAXBElement)part).setValue(imptDocument);
							} else {
								((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().remove(part);
								it = ((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().iterator();
							}
						}
					}
				} else if(((AbstractWSDLElementImpl)this.tag).getModel() instanceof TDefinitions) {
					// wsdl 1.1
					Iterator<Object> it = ((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().iterator();
					Object part = null;
					while (it.hasNext()) {
						part = it.next();
						// get partner link type
						if (part instanceof Element) {
							if((((Element)part).getLocalName().equals("importedDocuments"))&&(((Element)part).getNamespaceURI().equals("http://petals.ow2.org/wsdlExtensions"))) {
								WSDL4ComplexWsdlReaderImpl reader = getWSDLReader();

								reader.convertElement2ImportedDocuments((Element)part);

								// change element by jaxb element
								((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().remove(part);
								if(imptDocument != null) {
									((DescriptionType)((AbstractWSDLElementImpl)this.tag).getModel()).getImportOrIncludeOrTypes().add(imptDocument);
								}
								it = ((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().iterator();
							}
						} else if((part instanceof JAXBElement)&&(((JAXBElement)part).getValue() instanceof ImportedDocuments)) {
							if(imptDocument != null) {
								((JAXBElement)part).setValue(imptDocument);
							} else {
								((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().remove(part);
								it = ((TExtensibleDocumented)((AbstractWSDLElementImpl)this.tag).getModel()).getAny().iterator();
							}
						}
					}
				} 
			}
		} catch (WSDLException e) {
			throw new WSDL4ComplexWsdlException(e);
		}

	}


	public org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.ImportedDocuments getImportedDocuments() {
		return this.imptDocs;
	}


	public void setImportedDocuments(
			org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.ImportedDocuments docs) throws WSDL4ComplexWsdlException {
		this.imptDocs = docs;
		if(this.imptDocs != null) {
			this.setImportedDocumentsInAnyDescription((ImportedDocuments) ((AbstractWSDLElementImpl)this.imptDocs).getModel());
		} else {
			this.setImportedDocumentsInAnyDescription(null);
		}
	}



}
