/**
 * easyWSDL - easyWSDL toolbox Platform.
 * Copyright (c) 2008,  eBM Websourcing
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl.inout;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.ow2.easywsdl.extensions.complexwsdl.ImportedDocuments;
import org.ow2.easywsdl.extensions.complexwsdl.ObjectFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlWriter;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl.WSDL4ComplexWsdlJAXBContext;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLWriter;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.decorator.DecoratorDescriptionImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSDL4ComplexWsdlWriterImpl implements WSDL4ComplexWsdlWriter {

	private WSDLWriter writer = null;


	private DocumentBuilderFactory builder = null;

	public WSDL4ComplexWsdlWriterImpl() throws WSDL4ComplexWsdlException {
		try {
			WSDLFactory factory = WSDLFactory.newInstance();
	//		factory.setJAXBObjectFactoryList(WSDL4ComplexWsdlJAXBContext.getInstance().getDefaultObjectFactories());

			this.writer = factory.newWSDLWriter();

			builder = DocumentBuilderFactory.newInstance();
			builder.setNamespaceAware(true);

		} catch (final WSDLException e) {
			throw new WSDL4ComplexWsdlException(e);
		} 
	}

	@SuppressWarnings("unchecked")
	public Document getDocument(final Description wsdlDef) throws WSDL4ComplexWsdlException {
		Document res = null;
		try {
			org.ow2.easywsdl.wsdl.api.Description desc = ((DecoratorDescriptionImpl) wsdlDef).getFirstDescription();

			org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.ImportedDocuments imptDocs = wsdlDef.getImportedDocuments();

			if((imptDocs != null)&&(imptDocs.getDocuments().size() > 0)&&!(existImportedDocumentInOthersElements(desc))) {
				desc.addOtherElements(this.convertImportedDocuments2Element((ImportedDocuments) ((AbstractWSDLElementImpl)imptDocs).getModel()));
			}
			
			res = this.writer.getDocument(desc);
			
		} catch (final WSDLException e) {
			throw new WSDL4ComplexWsdlException(e);
		} catch (XmlException e) {
			throw new WSDL4ComplexWsdlException(e);
		}
		return res;
	}

	private boolean existImportedDocumentInOthersElements(
			org.ow2.easywsdl.wsdl.api.Description desc) throws XmlException {
		boolean res = false;
		for(Element elmt: desc.getOtherElements()) {
			if(elmt.getLocalName().equals("importedDocuments")) {
				res = true;
				break;
			}
		}
		return res;
	}

	public boolean getFeature(final String name) throws IllegalArgumentException {
		return this.writer.getFeature(name);
	}

	public void setFeature(final String name, final boolean value) throws IllegalArgumentException {
		this.writer.setFeature(name, value);
	}

	@SuppressWarnings("unchecked")
	public String writeWSDL4ComplexWsdl(final Description wsdlDef) throws WSDL4ComplexWsdlException {
		String res = null;
		try {
			org.ow2.easywsdl.wsdl.api.Description desc = ((DecoratorDescriptionImpl) wsdlDef).getFirstDescription();
			org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.ImportedDocuments imptDocs = wsdlDef.getImportedDocuments();
			if((imptDocs != null)&&(imptDocs.getDocuments().size() > 0)) {
				desc.addOtherElements(this.convertImportedDocuments2Element((ImportedDocuments) ((AbstractWSDLElementImpl)imptDocs).getModel()));
			}
			res = this.writer.writeWSDL(desc);
		} catch (final WSDLException e) {
			throw new WSDL4ComplexWsdlException(e);
		} catch (XmlException e) {
			throw new WSDL4ComplexWsdlException(e);
		}
		return res;
	}

	//	public JAXBElement<ImportedDocuments> convertImportedDocuments2JAXBElement(final ImportedDocuments imptDocs)
	//	throws WSDLException {
	//		ObjectFactory factory = new ObjectFactory();
	//		return factory.createImportedDocuments(imptDocs);
	//	}

	public Element convertImportedDocuments2Element(final ImportedDocuments imptDocs) throws WSDLException {

		Document doc = null;
		try {
			doc = builder.newDocumentBuilder().newDocument();


			ObjectFactory factory = new ObjectFactory();
			JAXBElement<ImportedDocuments>  jaxbImptDoc = factory.createImportedDocuments(imptDocs);

			WSDL4ComplexWsdlJAXBContext.getInstance().getJaxbContext().createMarshaller().marshal(jaxbImptDoc, doc);
		} catch (final JAXBException e) {
			throw new WSDLException(
					"Failed to build Java bindings from WSDL descriptor XML document", e);
		} catch (ParserConfigurationException e) {
			throw new WSDLException(
					"Failed to build Java bindings from WSDL descriptor XML document", e);
		}
		return doc.getDocumentElement();
	}
}
