/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2008 OW2 Consortium, http://www.ow2.org/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.ow2.easywsdl.extensions.wsdl4complexwsdl;

import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlWriter;

import com.ebmwebsourcing.easycommons.pooling.GenericResourcePool;
import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.pooling.PoolPolicy;
import com.ebmwebsourcing.easycommons.pooling.ResourceHandler;

/**
 * This class represent a {@link WSDL4ComplexWsdlWriter} pool, which provided {@link WSDL4ComplexWsdlWriter}
 * object as resource.
 * 
 * @author noddoux
 */
public class WSDL4ComplexWsdlWriterResourcePool {

    /**
     * {@link WSDL4ComplexWsdlWriter} resource handler to manage {@link WSDL4ComplexWsdlWriter} life cycle methods
     */
    private class WSDL4ComplexWsdlWriterResourceHandler implements ResourceHandler<WSDL4ComplexWsdlWriter> {

        final WSDL4ComplexWsdlFactory wsdl4ComplexWsdlFactory;

        public WSDL4ComplexWsdlWriterResourceHandler() {
            try {
                this.wsdl4ComplexWsdlFactory = WSDL4ComplexWsdlFactory.newInstance();
            } catch (WSDL4ComplexWsdlException e) {
                throw new PoolException(e);
            }
        }

        @Override
        public WSDL4ComplexWsdlWriter create() {
            try {
                return this.wsdl4ComplexWsdlFactory.newWSDLWriter();
            } catch (WSDL4ComplexWsdlException e) {
                throw new PoolException(e);
            }
        }

        @Override
        public void onRelease(WSDL4ComplexWsdlWriter wsdl4ComplexWsdlWriter) {
        }

        @Override
        public void onTake(WSDL4ComplexWsdlWriter wsdl4ComplexWsdlWriter) {            
        }
    }
    
    private final GenericResourcePool<WSDL4ComplexWsdlWriter> wsdl4ComplexWsdlWriterResourcePool;

    /**
     * Allowing to instantiate a new {@link WSDL4ComplexWsdlWriterResourcePool} containing {@link WSDL4ComplexWsdlWriter} resources.
     * 
     * @param minPoolSize
     *            The minimum number of {@link WSDL4ComplexWsdlWriter} instances in the pool (created at the
     *            initialization).
     * @param maxPoolSize
     *            the maximum number of {@link WSDL4ComplexWsdlWriter} instances in the current pool (limit of the
     *            pool). It must be greater or equals to the specified minSize.
     *            The maximum value is Integer.MAX_VALUE
     * @param poolPolicy
     *            the {@link PoolPolicy} to adopt when the maximum size is reached. it
     *            must not be null.
     */
    public WSDL4ComplexWsdlWriterResourcePool(int minPoolSize, int maxPoolSize,
            PoolPolicy poolPolicy) {
        WSDL4ComplexWsdlWriterResourceHandler wsdl4ComplexWsdlWriterResourceHandler = new WSDL4ComplexWsdlWriterResourceHandler();
        this.wsdl4ComplexWsdlWriterResourcePool = new GenericResourcePool<WSDL4ComplexWsdlWriter>(
                wsdl4ComplexWsdlWriterResourceHandler, minPoolSize, maxPoolSize, poolPolicy);
    }

    /**
     * Take one unused {@link WSDL4ComplexWsdlWriter} in the current pool. After getting a
     * {@link WSDL4ComplexWsdlWriter} from the pool and before returning a
     * {@link WSDL4ComplexWsdlWriter}, the method onTake() of the {@link WSDL4ComplexWsdlWriter}
     * resource handler is called.
     * 
     * @return one {@link WSDL4ComplexWsdlWriter}
     * 
     * @throws PoolException
     *             if the current thread is interrupted for the pool policy WAIT
     *             or if there is no more available resource in the pool for the
     *             pool policy REJECT
     * 
     */
    public WSDL4ComplexWsdlWriter take() {
        return this.wsdl4ComplexWsdlWriterResourcePool.take();
    }

    /**
     * Release the specified {@link WSDL4ComplexWsdlWriter} After putting back the
     * {@link WSDL4ComplexWsdlWriter} in the pool, the method onRelease() of the
     * {@link WSDL4ComplexWsdlWriter} resource handler is called.
     * 
     * @param wsdl4ComplexWsdlWriter
     *            The {@link WSDL4ComplexWsdlWriter} to release
     */
    public final void release(final WSDL4ComplexWsdlWriter wsdl4ComplexWsdlWriter) {
        this.wsdl4ComplexWsdlWriterResourcePool.release(wsdl4ComplexWsdlWriter);
    }
}
