/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2008 OW2 consortium (www.ow2.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id: XMLUtil.java 98 2006-02-24 16:18:48Z alouis $
 * -------------------------------------------------------------------------
 */

package org.ow2.easywsdl.extensions.wsdl4complexwsdl;

import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlWriter;

import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.pooling.PoolPolicy;

/**
 * A static pool of {@link WSDL4ComplexWsdlWriter} to improve {@link WSDL4ComplexWsdlWriter} creation efficiency. 
 * A {@link WSDL4ComplexWsdlWriter} is initialized the first time this class is used.
 * An infinite number (integer maximum value) of {@link WSDL4ComplexWsdlWriter} may be created. They are never evicted.
 * 
 * @ author noddoux
 */
public final class WSDL4ComplexWsdlWriters {

    private static final WSDL4ComplexWsdlWriterResourcePool wsdl4ComplexWsdlWriterResourcePool = new WSDL4ComplexWsdlWriterResourcePool(1, Integer.MAX_VALUE, PoolPolicy.WAIT);

    /**
     * Take a {@link WSDL4ComplexWsdlWriter} from the pool
     * 
     * @return one {@link WSDL4ComplexWsdlWriter}
     * 
     * @throws PoolException
     *             if the current thread waits for a {@link WSDL4ComplexWsdlWriter}
     *             of the pool and is interrupted
     */
    public final static WSDL4ComplexWsdlWriter takeWSDL4ComplexWsdlWriter() throws PoolException {
       return wsdl4ComplexWsdlWriterResourcePool.take();
    }

    /**
     * Release a {@link WSDL4ComplexWsdlWriter} to the pool
     * 
     * @param wsdl4ComplexWsdlWriter a {@link WSDL4ComplexWsdlWriter} to release
     */
    public final static void releaseWSDL4ComplexWsdlWriter(WSDL4ComplexWsdlWriter wsdl4ComplexWsdlWriter) {
        wsdl4ComplexWsdlWriterResourcePool.release(wsdl4ComplexWsdlWriter);
    }
}
