package org.ow2.easywsdl.extensions.wsdl4complexwsdl.util;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.JAXBElement;

import org.ow2.easywsdl.extensions.complexwsdl.ImportedDocuments;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl.ImportedDocumentsImpl;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl.inout.WSDL4ComplexWsdlReaderImpl;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfImport;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInclude;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImportedDocumentsFilter  {



	private Map<URI, AbsItfDescription> descriptions = new HashMap<URI, AbsItfDescription>();


	private Map<URI, AbsItfSchema> schemas = new HashMap<URI, AbsItfSchema>();



	public ImportedDocumentsFilter(Document doc, WSDL4ComplexWsdlReaderImpl reader) throws WSDLException {
		NodeList elmts = doc.getDocumentElement().getElementsByTagNameNS("http://petals.ow2.org/wsdlExtensions", "importedDocuments");

		if(elmts != null && elmts.getLength() > 0) {
			Element importedDocuments = (Element) elmts.item(0);
			JAXBElement<ImportedDocuments> imptDocsElmt = reader.convertElement2ImportedDocuments(importedDocuments);
			org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.ImportedDocuments imptDocs = new ImportedDocumentsImpl(imptDocsElmt.getValue(), null);
			for(org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Document imptDoc: imptDocs.getDocuments()) {
				if(imptDoc.getImportedDescription() != null) {
					descriptions.put(imptDoc.getLocation(), imptDoc.getImportedDescription());
				} else if(imptDoc.getImportedSchema() != null) {
					schemas.put(imptDoc.getLocation(), imptDoc.getImportedSchema());
				} 
			}
		}

		for(AbsItfDescription d: this.descriptions.values()) { 
			attachDescriptionInAllImportsAndIncludes(d, this.descriptions, this.schemas);
		}

		for(AbsItfSchema d: this.schemas.values()) { 
			attachSchemaInAllImportsAndIncludes(d, this.schemas);
		}
	}


	public static void attachSchemaInAllImportsAndIncludes(AbsItfSchema s,
			Map<URI, AbsItfSchema> schemas) throws WSDLException {


		for(org.ow2.easywsdl.schema.api.absItf.AbsItfImport impt: (List<org.ow2.easywsdl.schema.api.absItf.AbsItfImport>)s.getImports()) {
			impt.setSchema(schemas.get(impt.getLocationURI()));
		}	

		for(org.ow2.easywsdl.schema.api.absItf.AbsItfInclude incl: (List<org.ow2.easywsdl.schema.api.absItf.AbsItfInclude>)s.getImports()) {
			incl.setSchema(schemas.get(incl.getLocationURI()));
		}

	}


	public static void attachDescriptionInAllImportsAndIncludes(AbsItfDescription d,
			Map<URI, AbsItfDescription> descriptions, Map<URI, AbsItfSchema> schemas) throws WSDLException {

		for(AbsItfImport impt: (List<AbsItfImport>)d.getImports()) {
			impt.setDescription(descriptions.get(impt.getLocationURI()));
		}	

		for(AbsItfInclude incl: (List<AbsItfInclude>)d.getIncludes()) {
			incl.setDescription(descriptions.get(incl.getLocationURI()));
		}	

		if(d.getTypes() != null) {
			for(AbsItfSchema s: (List<AbsItfSchema>)d.getTypes().getImportedSchemas()) {
				attachSchemaInAllImportsAndIncludes(s,	schemas);
			}


			for(AbsItfSchema s: (List<AbsItfSchema>)d.getTypes().getSchemas()) {
				attachSchemaInAllImportsAndIncludes(s,	schemas);
			}
		}
	}


	public Map<URI, AbsItfDescription> getDescriptions() {
		return descriptions;
	}


	public Map<URI, AbsItfSchema> getSchemas() {
		return schemas;
	}





}
