/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.extensions.wsdl4complexwsdl.test;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlReader;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlWriter;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Import;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.Types;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.w3c.dom.Document;

public class WSDL4ComplexWsdlDescriptorTest
extends TestCase {
    private WSDL4ComplexWsdlReader reader = null;
    private WSDL4ComplexWsdlWriter writer = null;

    public WSDL4ComplexWsdlDescriptorTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.reader = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader();
        this.writer = WSDL4ComplexWsdlFactory.newInstance().newWSDLWriter();
    }

    public void testCreateComplexWsdl() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/CustomerSearch.wsdl");
        Description description = this.reader.read(uRL);
        description.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)description);
        WSDL4ComplexWsdlDescriptorTest.assertEquals((int)4, (int)description.getImportedDocuments().getDocuments().size());
    }

    public void testWriteComplexWsdl() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/CustomerSearch.wsdl");
        Description description = this.reader.read(uRL);
        description.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)description);
        WSDL4ComplexWsdlDescriptorTest.assertEquals((int)4, (int)description.getImportedDocuments().getDocuments().size());
        Document document = this.writer.getDocument(description);
        WSDL4ComplexWsdlDescriptorTest.assertNotNull((Object)document);
        Description description2 = description;
        Map map = description2.deleteImportedDocumentsInWsdl(URI.create("http://localhost:8084/"));
        Assert.assertNotNull((Object)description2);
        Document document2 = WSDL4ComplexWsdlFactory.newInstance().newWSDLWriter().getDocument(description2);
        WSDL4ComplexWsdlDescriptorTest.assertNotNull((Object)document2);
        WSDL4ComplexWsdlDescriptorTest.assertEquals((int)4, (int)map.values().size());
    }

    public void testReadComplexWsdl() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/otherswsdl/testService.wsdl");
        Description description = this.reader.read(uRL);
        description.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)description);
        Document document = WSDL4ComplexWsdlFactory.newInstance().newWSDLWriter().getDocument(description);
        Assert.assertNotNull((Object)document);
        WSDL4ComplexWsdlDescriptorTest.assertEquals((int)1, (int)description.getImportedDocuments().getDocuments().size());
        if (description != null && description.getServices() != null) {
            for (Service service : description.getServices()) {
                if (service.getEndpoint("GetFilesPort") != null) {
                    InterfaceType interfaceType = (InterfaceType)service.getInterface();
                    if (interfaceType != null && interfaceType.getQName() != null) {
                        WSDL4ComplexWsdlDescriptorTest.assertEquals((String)"{http://petals.ow2.org/components/filetransfer/version-2.2}GetFiles", (String)((InterfaceType)service.getInterface()).getQName().toString());
                        continue;
                    }
                    WSDL4ComplexWsdlDescriptorTest.fail((String)"GetFilesPort interface not found");
                    continue;
                }
                WSDL4ComplexWsdlDescriptorTest.fail((String)"GetFilesPort endpoint not found");
            }
        } else {
            WSDL4ComplexWsdlDescriptorTest.fail((String)"GetFilesPort service not found");
        }
    }

    public void testCreateSimpleWsdl() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/testSimpleWSDL.wsdl");
        Description description = this.reader.read(uRL);
        description.deleteImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)description);
        Assert.assertNull((Object)description.getImportedDocuments());
    }

    public void testReadComplexWsdl2() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/otherswsdl/SnWS.wsdl");
        Description description = this.reader.read(uRL);
        description.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)description);
        Document document = WSDL4ComplexWsdlFactory.newInstance().newWSDLWriter().getDocument(description);
        Assert.assertNotNull((Object)document);
        WSDL4ComplexWsdlDescriptorTest.assertEquals((int)1, (int)description.getImportedDocuments().getDocuments().size());
        if (description != null && description.getServices() != null) {
            for (Service service : description.getServices()) {
                if (service.getEndpoint("ServiceQuestionnaireSOAP") != null) {
                    InterfaceType interfaceType = (InterfaceType)service.getInterface();
                    if (interfaceType != null && interfaceType.getQName() != null) {
                        WSDL4ComplexWsdlDescriptorTest.assertEquals((String)"{http://icod/ServiceQuestionnaire/}ServiceQuestionnaire", (String)((InterfaceType)service.getInterface()).getQName().toString());
                        Types types = (Types)description.getTypes();
                        List list = types.getSchemas();
                        boolean bl = false;
                        boolean bl2 = false;
                        for (Schema schema : list) {
                            List list2 = schema.getElements();
                            for (Element element : list2) {
                                if (element.getQName().getLocalPart().equals("ErreurSysteme")) {
                                    bl = true;
                                    continue;
                                }
                                if (!element.getQName().getLocalPart().equals("ObtenirQuestionnaireResponse")) continue;
                                bl2 = true;
                            }
                        }
                        WSDL4ComplexWsdlDescriptorTest.assertTrue((boolean)bl2);
                        WSDL4ComplexWsdlDescriptorTest.assertTrue((boolean)bl);
                        continue;
                    }
                    WSDL4ComplexWsdlDescriptorTest.fail((String)"ServiceQuestionnaire interface not found");
                    continue;
                }
                WSDL4ComplexWsdlDescriptorTest.fail((String)"ServiceQuestionnaire endpoint not found");
            }
        } else {
            WSDL4ComplexWsdlDescriptorTest.fail((String)"ServiceQuestionnaire service not found");
        }
    }

    public void testReadComplexWsdlDocumentInJBI() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/otherswsdl/testService.wsdl");
        Description description = this.reader.read(uRL);
        description.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)description);
        Document document = this.writer.getDocument(description);
        document.setDocumentURI(uRL.toString());
        Assert.assertEquals((String)uRL.toString(), (String)document.getDocumentURI());
        description = this.reader.read(document);
        Assert.assertNotNull((Object)description);
    }

    public void testChangeImportLocation() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/otherswsdl/SnWS.wsdl");
        Description description = this.reader.read(uRL);
        description.addImportedDocumentsInWsdl();
        description.deleteImportedDocumentsInWsdl(new File("./src/test/resources/descriptors/otherswsdl/").toURI());
        Types types = (Types)description.getTypes();
        Assert.assertNotNull((String)"No types", (Object)types);
        boolean bl = false;
        for (Schema schema : types.getSchemas()) {
            if (!"http://icod/ServiceQuestionnaire/".equals(schema.getTargetNamespace())) continue;
            bl = true;
            Assert.assertNotNull((String)"Import is missing in schema", (Object)schema.getImports());
            Assert.assertEquals((String)"Only one import is expected in the schema", (int)1, (int)schema.getImports().size());
            Assert.assertNotNull((String)"No import of the namespace 'http://icod/SnWS/' in the schema", (Object)schema.getImports("http://icod/SnWS/"));
            Assert.assertEquals((String)"The namespace 'http://icod/SnWS/' is not imported or imported more than once", (int)1, (int)schema.getImports("http://icod/SnWS/").size());
            Import import_ = (Import)schema.getImports("http://icod/SnWS/").get(0);
            Assert.assertNotNull((String)"The import is value is null", (Object)import_);
            URI uRI = import_.getLocationURI();
            Assert.assertNotNull((String)"No location defined", (Object)uRI);
            Assert.assertNotNull((String)"Null scheme part in the new location URI", (Object)uRI.getScheme());
            Assert.assertEquals((String)"The scheme part in the new location URI is not the expected one", (String)"file", (String)uRI.getScheme());
        }
        WSDL4ComplexWsdlDescriptorTest.assertTrue((String)"Expected schema not found in the WSDL", (boolean)bl);
    }

    public void testChangeImportLocationHTTP() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/test-update-imports.wsdl");
        Description description = this.reader.read(uRL);
        description.addImportedDocumentsInWsdl();
        description.deleteImportedDocumentsInWsdl(URI.create("myImports/"));
        Types types = (Types)description.getTypes();
        Assert.assertNotNull((String)"No types", (Object)types);
        boolean bl = false;
        for (Schema schema : types.getSchemas()) {
            if (!"http://icod/ServiceQuestionnaire/".equals(schema.getTargetNamespace())) continue;
            bl = true;
            Assert.assertNotNull((String)"Import is missing in schema", (Object)schema.getImports());
            Assert.assertEquals((String)"Only one import is expected in the schema", (int)1, (int)schema.getImports().size());
            Assert.assertNotNull((String)"No import of the namespace 'http://www.ebxml.org/BusinessProcess' in the schema", (Object)schema.getImports("http://www.ebxml.org/BusinessProcess"));
            Assert.assertEquals((String)"The namespace 'http://www.ebxml.org/BusinessProcess' is not imported or imported more than once", (int)1, (int)schema.getImports("http://www.ebxml.org/BusinessProcess").size());
            Import import_ = (Import)schema.getImports("http://www.ebxml.org/BusinessProcess").get(0);
            Assert.assertNotNull((String)"The import is value is null", (Object)import_);
            URI uRI = import_.getLocationURI();
            Assert.assertNotNull((String)"No location defined", (Object)uRI);
            Assert.assertNull((String)"No null scheme part in the new location URI", (Object)uRI.getScheme());
            Assert.assertEquals((String)"myImports/specs/ebBPSS.xsd", (String)uRI.getPath());
        }
        WSDL4ComplexWsdlDescriptorTest.assertTrue((String)"Expected schema not found in the WSDL", (boolean)bl);
    }

    public void testReadWSDL4ComplexWSDL4BindConsume() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/bindConsumeArtifacts.wsdl");
        Description description = this.reader.read(uRL);
        description.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)description.getImportedDocuments());
        description.deleteImportedDocumentsInWsdl();
        Assert.assertNull((Object)description.getImportedDocuments());
        Assert.assertNotNull((Object)description);
    }

    public void testReadWSDL4ComplexWSDL4Petals() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/person/concreteProcess.wsdl");
        Description description = this.reader.read(uRL);
        description.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)description.getImportedDocuments());
        Document document = this.writer.getDocument(description);
        System.out.println("[1] -- \n\n" + XMLPrettyPrinter.prettyPrint((Document)document));
        description = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(document);
        Map map = description.deleteImportedDocumentsInWsdl();
        Assert.assertNull((Object)description.getImportedDocuments());
        document = this.writer.getDocument(description);
        System.out.println("\n[2] -- \n\n" + XMLPrettyPrinter.prettyPrint((Document)document));
        for (Document document2 : map.values()) {
            System.out.println("\n[3] - impt- \n\n" + XMLPrettyPrinter.prettyPrint((Document)document2));
        }
        Assert.assertNotNull((Object)description);
    }

    public void testReadWSDL4ComplexWSDL4FT() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/WSDL.wsdl");
        Description description = this.reader.read(uRL);
        description.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)description.getImportedDocuments());
        description.deleteImportedDocumentsInWsdl(new URI("http://localhost:8084/petals/services/convergeruling?wsdl="));
        Assert.assertNull((Object)description.getImportedDocuments());
        Assert.assertEquals((String)"localhost", (String)((Import)((Schema)((Types)description.getTypes()).getSchemas().get(0)).getImports().get(0)).getLocationURI().getHost());
        Assert.assertNotNull((Object)description);
    }

    public void testReadWSDL4ComplexWSDL4FT2() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/WSDL2.wsdl");
        Description description = this.reader.read(uRL);
        description.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)description.getImportedDocuments());
        description.deleteImportedDocumentsInWsdl(new URI("http://localhost:8084/"));
        Assert.assertNull((Object)description.getImportedDocuments());
        Assert.assertEquals((String)"localhost", (String)((Import)((Schema)((Types)description.getTypes()).getSchemas().get(0)).getImports().get(0)).getLocationURI().getHost());
        Assert.assertNotNull((Object)description);
    }

    public void testReadWSDL4ComplexWSDL4Test1RemoteProcess() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("descriptors/test1/Label_1.0.wsdl");
        Description description = this.reader.read(uRL);
        description.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)description.getImportedDocuments());
        description.deleteImportedDocumentsInWsdl();
        Assert.assertNull((Object)description.getImportedDocuments());
        Assert.assertNotNull((Object)description);
    }

    public void testReadWSDL4ComplexWSDL4RedefineProcess() throws URISyntaxException, WSDLException, IOException {
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("wsdl/Admin.wsdl");
        Description description = this.reader.read(uRL);
        description.addImportedDocumentsInWsdl();
        Assert.assertNotNull((Object)description.getImportedDocuments());
        Map map = description.deleteImportedDocumentsInWsdl(URI.create("http://localhost:8085/services/"));
        Assert.assertNull((Object)description.getImportedDocuments());
        WSDL4ComplexWsdlDescriptorTest.assertEquals((int)2, (int)map.values().size());
        Assert.assertNotNull((Object)description);
    }
}

